/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.discovery;

import java.util.ArrayList;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.beans.factory.FactoryBean;

public class OidcServerDiscoverySettingsFactory
implements FactoryBean<OidcServerDiscoverySettings> {
    private final CasConfigurationProperties casProperties;

    public OidcServerDiscoverySettingsFactory(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }

    public OidcServerDiscoverySettings getObject() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        OidcServerDiscoverySettings discoveryProperties = new OidcServerDiscoverySettings(this.casProperties, oidc.getIssuer());
        discoveryProperties.setClaimsSupported(oidc.getClaims());
        discoveryProperties.setScopesSupported(oidc.getScopes());
        discoveryProperties.setResponseTypesSupported(CollectionUtils.wrapList((Object[])new String[]{OAuth20ResponseTypes.CODE.getType(), OAuth20ResponseTypes.TOKEN.getType(), OAuth20ResponseTypes.IDTOKEN_TOKEN.getType()}));
        discoveryProperties.setSubjectTypesSupported(oidc.getSubjectTypes());
        discoveryProperties.setClaimTypesSupported(CollectionUtils.wrap((Object)"normal"));
        ArrayList<String> authnMethods = new ArrayList<String>();
        authnMethods.add("client_secret_basic");
        discoveryProperties.setIntrospectionSupportedAuthenticationMethods(authnMethods);
        discoveryProperties.setGrantTypesSupported(CollectionUtils.wrapList((Object[])new String[]{OAuth20GrantTypes.AUTHORIZATION_CODE.getType(), OAuth20GrantTypes.PASSWORD.getType(), OAuth20GrantTypes.REFRESH_TOKEN.getType()}));
        discoveryProperties.setIdTokenSigningAlgValuesSupported(CollectionUtils.wrapList((Object[])new String[]{"none", "RS256"}));
        return discoveryProperties;
    }

    public Class<?> getObjectType() {
        return OidcServerDiscoverySettings.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

