/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordPolicyContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.jdbc.JdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.QueryJdbcAuthenticationProperties;
import org.apereo.cas.jdbc.JdbcAuthenticationUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Authentication}, module="jdbc")
@Configuration(value="CasJdbcQueryAuthenticationConfiguration", proxyBeanMethods=false)
class CasJdbcQueryAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasJdbcQueryAuthenticationConfiguration.class);

    CasJdbcQueryAuthenticationConfiguration() {
    }

    @ConditionalOnMissingBean(name={"queryDatabaseAuthenticationHandlers"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Collection<AuthenticationHandler> queryDatabaseAuthenticationHandlers(@Qualifier(value="queryDatabasePasswordPolicyConfiguration") PasswordPolicyContext queryPasswordPolicyConfiguration, ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="queryDatabasePrincipalFactory") PrincipalFactory jdbcPrincipalFactory, CasConfigurationProperties casProperties) {
        HashSet<AuthenticationHandler> handlers = new HashSet<AuthenticationHandler>();
        JdbcAuthenticationProperties jdbc = casProperties.getAuthn().getJdbc();
        jdbc.getQuery().forEach(properties -> {
            AuthenticationHandler handler = JdbcAuthenticationUtils.newAuthenticationHandler((QueryJdbcAuthenticationProperties)properties, (ConfigurableApplicationContext)applicationContext, (PrincipalFactory)jdbcPrincipalFactory, (PasswordPolicyContext)queryPasswordPolicyConfiguration);
            handlers.add(handler);
        });
        return handlers;
    }

    @ConditionalOnMissingBean(name={"queryDatabasePrincipalFactory"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PrincipalFactory queryDatabasePrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"queryDatabasePasswordPolicyConfiguration"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PasswordPolicyContext queryDatabasePasswordPolicyConfiguration() {
        return new PasswordPolicyContext();
    }

    @ConditionalOnMissingBean(name={"queryDatabaseAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationEventExecutionPlanConfigurer jdbcAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="queryDatabaseAuthenticationHandlers") Collection<AuthenticationHandler> jdbcAuthenticationHandlers, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
        return plan -> jdbcAuthenticationHandlers.forEach(h -> plan.registerAuthenticationHandlerWithPrincipalResolver(h, defaultPrincipalResolver));
    }
}

