/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.handler.TenantAuthenticationHandlerBuilder;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.jdbc.TenantJdbcAuthenticationHandlerBuilder;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Authentication}, module="jdbc")
@Configuration(value="CasJdbcMultitenancyConfiguration", proxyBeanMethods=false)
class CasJdbcAuthenticationMultitenancyConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasJdbcAuthenticationMultitenancyConfiguration.class);

    CasJdbcAuthenticationMultitenancyConfiguration() {
    }

    @Configuration(value="CasJdbcMultitenancyAuthenticationHandlersConfiguration", proxyBeanMethods=false)
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Multitenancy})
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasJdbcMultitenancyAuthenticationHandlersConfiguration {
        CasJdbcMultitenancyAuthenticationHandlersConfiguration() {
        }

        @ConditionalOnMissingBean(name={"jdbcMultitenancyAuthenticationPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer jdbcMultitenancyAuthenticationPlanConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return plan -> {
                if (casProperties.getMultitenancy().getCore().isEnabled()) {
                    PasswordPolicyContext passwordPolicyConfiguration = new PasswordPolicyContext();
                    PrincipalFactory principalFactory = PrincipalFactoryUtils.newPrincipalFactory();
                    TenantJdbcAuthenticationHandlerBuilder builder = new TenantJdbcAuthenticationHandlerBuilder(passwordPolicyConfiguration, principalFactory, applicationContext);
                    plan.registerTenantAuthenticationHandlerBuilder((TenantAuthenticationHandlerBuilder)builder);
                }
            };
        }
    }
}

