/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc.config;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.BindModeSearchDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.QueryAndEncodeDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.QueryDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.SearchModeSearchDatabaseAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.jdbc.JdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.BaseJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.BindJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.QueryEncodeJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.QueryJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.SearchJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="CasJdbcAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasJdbcAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasJdbcAuthenticationConfiguration.class);
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;

    @ConditionalOnMissingBean(name={"jdbcAuthenticationHandlers"})
    @Bean
    @RefreshScope
    public Collection<AuthenticationHandler> jdbcAuthenticationHandlers() {
        HashSet<AuthenticationHandler> handlers = new HashSet<AuthenticationHandler>();
        JdbcAuthenticationProperties jdbc = this.casProperties.getAuthn().getJdbc();
        jdbc.getBind().forEach(b -> handlers.add(this.bindModeSearchDatabaseAuthenticationHandler((BindJdbcAuthenticationProperties)b)));
        jdbc.getEncode().forEach(b -> handlers.add(this.queryAndEncodeDatabaseAuthenticationHandler((QueryEncodeJdbcAuthenticationProperties)b)));
        jdbc.getQuery().forEach(b -> handlers.add(this.queryDatabaseAuthenticationHandler((QueryJdbcAuthenticationProperties)b)));
        jdbc.getSearch().forEach(b -> handlers.add(this.searchModeSearchDatabaseAuthenticationHandler((SearchJdbcAuthenticationProperties)b)));
        return handlers;
    }

    @ConditionalOnMissingBean(name={"jdbcPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory jdbcPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"queryAndEncodePasswordPolicyConfiguration"})
    @Bean
    @RefreshScope
    public PasswordPolicyContext queryAndEncodePasswordPolicyConfiguration() {
        return new PasswordPolicyContext();
    }

    @ConditionalOnMissingBean(name={"searchModePasswordPolicyConfiguration"})
    @Bean
    @RefreshScope
    public PasswordPolicyContext searchModePasswordPolicyConfiguration() {
        return new PasswordPolicyContext();
    }

    @ConditionalOnMissingBean(name={"queryPasswordPolicyConfiguration"})
    @Bean
    @RefreshScope
    public PasswordPolicyContext queryPasswordPolicyConfiguration() {
        return new PasswordPolicyContext();
    }

    @ConditionalOnMissingBean(name={"bindSearchPasswordPolicyConfiguration"})
    @Bean
    @RefreshScope
    public PasswordPolicyContext bindSearchPasswordPolicyConfiguration() {
        return new PasswordPolicyContext();
    }

    @ConditionalOnMissingBean(name={"jdbcAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope
    public AuthenticationEventExecutionPlanConfigurer jdbcAuthenticationEventExecutionPlanConfigurer() {
        return plan -> this.jdbcAuthenticationHandlers().forEach(h -> plan.registerAuthenticationHandlerWithPrincipalResolver(h, (PrincipalResolver)this.defaultPrincipalResolver.getObject()));
    }

    private AuthenticationHandler bindModeSearchDatabaseAuthenticationHandler(BindJdbcAuthenticationProperties b) {
        BindModeSearchDatabaseAuthenticationHandler h = new BindModeSearchDatabaseAuthenticationHandler(b.getName(), (ServicesManager)this.servicesManager.getObject(), this.jdbcPrincipalFactory(), Integer.valueOf(b.getOrder()), JpaBeans.newDataSource((AbstractJpaProperties)b));
        this.configureJdbcAuthenticationHandler((AbstractJdbcUsernamePasswordAuthenticationHandler)h, (BaseJdbcAuthenticationProperties)b);
        return h;
    }

    private AuthenticationHandler queryAndEncodeDatabaseAuthenticationHandler(QueryEncodeJdbcAuthenticationProperties b) {
        QueryAndEncodeDatabaseAuthenticationHandler h = new QueryAndEncodeDatabaseAuthenticationHandler(b.getName(), (ServicesManager)this.servicesManager.getObject(), this.jdbcPrincipalFactory(), Integer.valueOf(b.getOrder()), JpaBeans.newDataSource((AbstractJpaProperties)b), b.getAlgorithmName(), b.getSql(), b.getPasswordFieldName(), b.getSaltFieldName(), b.getExpiredFieldName(), b.getDisabledFieldName(), b.getNumberOfIterationsFieldName(), b.getNumberOfIterations(), b.getStaticSalt());
        this.configureJdbcAuthenticationHandler((AbstractJdbcUsernamePasswordAuthenticationHandler)h, (BaseJdbcAuthenticationProperties)b);
        return h;
    }

    private AuthenticationHandler queryDatabaseAuthenticationHandler(QueryJdbcAuthenticationProperties b) {
        Multimap attributes = CoreAuthenticationUtils.transformPrincipalAttributesListIntoMultiMap((List)b.getPrincipalAttributeList());
        LOGGER.trace("Created and mapped principal attributes [{}] for [{}]...", (Object)attributes, (Object)b.getUrl());
        QueryDatabaseAuthenticationHandler h = new QueryDatabaseAuthenticationHandler(b.getName(), (ServicesManager)this.servicesManager.getObject(), this.jdbcPrincipalFactory(), Integer.valueOf(b.getOrder()), JpaBeans.newDataSource((AbstractJpaProperties)b), b.getSql(), b.getFieldPassword(), b.getFieldExpired(), b.getFieldDisabled(), CollectionUtils.wrap((Multimap)attributes));
        this.configureJdbcAuthenticationHandler((AbstractJdbcUsernamePasswordAuthenticationHandler)h, (BaseJdbcAuthenticationProperties)b);
        h.setPasswordPolicyConfiguration(this.queryPasswordPolicyConfiguration());
        return h;
    }

    private AuthenticationHandler searchModeSearchDatabaseAuthenticationHandler(SearchJdbcAuthenticationProperties b) {
        SearchModeSearchDatabaseAuthenticationHandler h = new SearchModeSearchDatabaseAuthenticationHandler(b.getName(), (ServicesManager)this.servicesManager.getObject(), this.jdbcPrincipalFactory(), Integer.valueOf(b.getOrder()), JpaBeans.newDataSource((AbstractJpaProperties)b), b.getFieldUser(), b.getFieldPassword(), b.getTableUsers());
        this.configureJdbcAuthenticationHandler((AbstractJdbcUsernamePasswordAuthenticationHandler)h, (BaseJdbcAuthenticationProperties)b);
        return h;
    }

    private void configureJdbcAuthenticationHandler(AbstractJdbcUsernamePasswordAuthenticationHandler handler, BaseJdbcAuthenticationProperties properties) {
        handler.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)properties.getPasswordEncoder(), (ApplicationContext)this.applicationContext));
        handler.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)properties.getPrincipalTransformation()));
        handler.setPasswordPolicyConfiguration(this.bindSearchPasswordPolicyConfiguration());
        if (StringUtils.isNotBlank((CharSequence)properties.getCredentialCriteria())) {
            handler.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)properties.getCredentialCriteria()));
        }
        LOGGER.trace("Configured authentication handler [{}] to handle database url at [{}]", (Object)handler.getName(), (Object)properties.getUrl());
    }
}

