/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.adaptors.azure.web.flow.AzureAuthenticatorMultifactorTrustWebflowConfigurer;
import org.apereo.cas.adaptors.azure.web.flow.AzureAuthenticatorMultifactorWebflowConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

@Configuration(value="azureAuthenticatorConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
public class AzureAuthenticatorConfiguration
implements CasWebflowExecutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureAuthenticatorConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    private FlowBuilderServices flowBuilderServices;

    @Bean
    public FlowDefinitionRegistry azureAuthenticatorFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder(this.applicationContext, this.flowBuilderServices);
        builder.setBasePath("classpath*:/webflow");
        builder.addFlowLocationPattern("/mfa-azure/*-webflow.xml");
        return builder.build();
    }

    @ConditionalOnMissingBean(name={"azureAuthenticatorMultifactorWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer azureAuthenticatorMultifactorWebflowConfigurer() {
        return new AzureAuthenticatorMultifactorWebflowConfigurer(this.flowBuilderServices, this.loginFlowDefinitionRegistry, this.azureAuthenticatorFlowRegistry(), this.applicationContext, this.casProperties);
    }

    public void configureWebflowExecutionPlan(CasWebflowExecutionPlan plan) {
        plan.registerWebflowConfigurer(this.azureAuthenticatorMultifactorWebflowConfigurer());
    }

    @ConditionalOnClass(value={MultifactorAuthenticationTrustStorage.class})
    @ConditionalOnProperty(prefix="cas.authn.mfa.azure", name={"trustedDeviceEnabled"}, havingValue="true", matchIfMissing=true)
    @Configuration(value="azureMultifactorTrustConfiguration")
    public class AzureAuthenticatorMultifactorTrustConfiguration
    implements CasWebflowExecutionPlanConfigurer {
        @ConditionalOnMissingBean(name={"azureMultifactorTrustWebflowConfigurer"})
        @Bean
        @DependsOn(value={"defaultWebflowConfigurer"})
        public CasWebflowConfigurer azureMultifactorTrustWebflowConfigurer() {
            return new AzureAuthenticatorMultifactorTrustWebflowConfigurer(AzureAuthenticatorConfiguration.this.flowBuilderServices, AzureAuthenticatorConfiguration.this.loginFlowDefinitionRegistry, AzureAuthenticatorConfiguration.this.casProperties.getAuthn().getMfa().getTrusted().isDeviceRegistrationEnabled(), AzureAuthenticatorConfiguration.this.azureAuthenticatorFlowRegistry(), AzureAuthenticatorConfiguration.this.applicationContext, AzureAuthenticatorConfiguration.this.casProperties);
        }

        public void configureWebflowExecutionPlan(CasWebflowExecutionPlan plan) {
            plan.registerWebflowConfigurer(this.azureMultifactorTrustWebflowConfigurer());
        }
    }
}

