/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.azure;

import lombok.Generated;
import net.phonefactor.pfsdk.AuthModeInfo;
import net.phonefactor.pfsdk.PFAuthParams;
import net.phonefactor.pfsdk.PlainTextPinInfo;
import net.phonefactor.pfsdk.StandardPinInfo;
import org.apereo.cas.adaptors.azure.AzureAuthenticatorTokenCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.AzureMultifactorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureAuthenticatorAuthenticationRequestBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureAuthenticatorAuthenticationRequestBuilder.class);
    private final String phoneAttributeName;
    private final AzureMultifactorProperties.AuthenticationModes mode;

    public PFAuthParams build(Principal p, AzureAuthenticatorTokenCredential c) {
        if (!p.getAttributes().containsKey(this.phoneAttributeName)) {
            throw new IllegalArgumentException(this.phoneAttributeName + " is not available as a principal attribute");
        }
        PFAuthParams params = new PFAuthParams();
        params.setPhoneNumber(p.getAttributes().get(this.phoneAttributeName).toString());
        params.setCountryCode("1");
        params.setUsername(p.getId());
        switch (this.mode) {
            case PIN: {
                params.setAuthInfo((AuthModeInfo)new PlainTextPinInfo(c.getToken()));
                break;
            }
            default: {
                params.setAuthInfo((AuthModeInfo)new StandardPinInfo());
            }
        }
        return params;
    }

    @Generated
    public AzureAuthenticatorAuthenticationRequestBuilder(String phoneAttributeName, AzureMultifactorProperties.AuthenticationModes mode) {
        this.phoneAttributeName = phoneAttributeName;
        this.mode = mode;
    }
}

