/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.azure;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import net.phonefactor.pfsdk.PFAuth;
import net.phonefactor.pfsdk.PFAuthParams;
import net.phonefactor.pfsdk.PFAuthResult;
import org.apereo.cas.adaptors.azure.AzureAuthenticatorAuthenticationRequestBuilder;
import org.apereo.cas.adaptors.azure.AzureAuthenticatorTokenCredential;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureAuthenticatorAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureAuthenticatorAuthenticationHandler.class);
    private final PFAuth azureAuthenticatorInstance;
    private final AzureAuthenticatorAuthenticationRequestBuilder authenticationRequestBuilder;

    public AzureAuthenticatorAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, PFAuth azureAuthenticatorInstance, AzureAuthenticatorAuthenticationRequestBuilder builder) {
        super(name, servicesManager, principalFactory, null);
        this.azureAuthenticatorInstance = azureAuthenticatorInstance;
        this.authenticationRequestBuilder = builder;
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws GeneralSecurityException {
        try {
            AzureAuthenticatorTokenCredential c = (AzureAuthenticatorTokenCredential)credential;
            Authentication authentication = WebUtils.getInProgressAuthentication();
            if (authentication == null) {
                throw new IllegalArgumentException("CAS has no reference to an authentication event to locate a principal");
            }
            Principal principal = authentication.getPrincipal();
            LOGGER.debug("Received principal id [{}]", (Object)principal.getId());
            PFAuthParams params = this.authenticationRequestBuilder.build(principal, c);
            PFAuthResult r = this.azureAuthenticatorInstance.authenticate(params);
            if (r.getAuthenticated()) {
                return this.createHandlerResult((Credential)c, this.principalFactory.createPrincipal(principal.getId()));
            }
            LOGGER.error("Authentication failed. Call status: [{}]-[{}]. Error: [{}]", new Object[]{r.getCallStatus(), r.getCallStatusString(), r.getMessageError()});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        throw new FailedLoginException("Failed to authenticate user");
    }

    public boolean supports(Credential credential) {
        return AzureAuthenticatorTokenCredential.class.isAssignableFrom(credential.getClass());
    }
}

