/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.azure;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import net.phonefactor.pfsdk.PFAuth;
import net.phonefactor.pfsdk.PFAuthParams;
import net.phonefactor.pfsdk.PFAuthResult;
import org.apereo.cas.adaptors.azure.AzureAuthenticatorAuthenticationRequestBuilder;
import org.apereo.cas.adaptors.azure.AzureAuthenticatorTokenCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class AzureAuthenticatorAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureAuthenticatorAuthenticationHandler.class);
    private final PFAuth azureAuthenticatorInstance;
    private final AzureAuthenticatorAuthenticationRequestBuilder authenticationRequestBuilder;

    public AzureAuthenticatorAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, PFAuth azureAuthenticatorInstance, AzureAuthenticatorAuthenticationRequestBuilder builder) {
        super(name, servicesManager, principalFactory, null);
        this.azureAuthenticatorInstance = azureAuthenticatorInstance;
        this.authenticationRequestBuilder = builder;
    }

    protected HandlerResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        try {
            AzureAuthenticatorTokenCredential c = (AzureAuthenticatorTokenCredential)credential;
            RequestContext context = RequestContextHolder.getRequestContext();
            Principal principal = WebUtils.getAuthentication((RequestContext)context).getPrincipal();
            LOGGER.debug("Received principal id [{}]", (Object)principal.getId());
            PFAuthParams params = this.authenticationRequestBuilder.build(principal, c);
            PFAuthResult r = this.azureAuthenticatorInstance.authenticate(params);
            if (r.getAuthenticated()) {
                return this.createHandlerResult((Credential)c, this.principalFactory.createPrincipal(principal.getId()), null);
            }
            LOGGER.error("Authentication failed. Call status: [{}]-[{}]. Error: [{}]", new Object[]{r.getCallStatus(), r.getCallStatusString(), r.getMessageError()});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        throw new FailedLoginException("Failed to authenticate user");
    }

    public boolean supports(Credential credential) {
        return AzureAuthenticatorTokenCredential.class.isAssignableFrom(credential.getClass());
    }
}

