/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.azure;

import net.phonefactor.pfsdk.AuthModeInfo;
import net.phonefactor.pfsdk.PFAuthParams;
import net.phonefactor.pfsdk.PlainTextPinInfo;
import net.phonefactor.pfsdk.StandardPinInfo;
import org.apereo.cas.adaptors.azure.AzureAuthenticatorTokenCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;

public class AzureAuthenticatorAuthenticationRequestBuilder {
    private final String phoneAttributeName;
    private final MultifactorAuthenticationProperties.Azure.AuthenticationModes mode;

    public AzureAuthenticatorAuthenticationRequestBuilder(String phoneAttributeName, MultifactorAuthenticationProperties.Azure.AuthenticationModes mode) {
        this.phoneAttributeName = phoneAttributeName;
        this.mode = mode;
    }

    public PFAuthParams build(Principal p, AzureAuthenticatorTokenCredential c) {
        if (!p.getAttributes().containsKey(this.phoneAttributeName)) {
            throw new IllegalArgumentException(this.phoneAttributeName + " is not available as a principal attribute");
        }
        PFAuthParams params = new PFAuthParams();
        params.setPhoneNumber(p.getAttributes().get(this.phoneAttributeName).toString());
        params.setCountryCode("1");
        params.setUsername(p.getId());
        switch (this.mode) {
            case PIN: {
                params.setAuthInfo((AuthModeInfo)new PlainTextPinInfo(c.getToken()));
                break;
            }
            default: {
                params.setAuthInfo((AuthModeInfo)new StandardPinInfo());
            }
        }
        return params;
    }
}

