/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test.system;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ExitCode;
import org.apache.zookeeper.test.system.DuplicateNameException;
import org.apache.zookeeper.test.system.Instance;
import org.apache.zookeeper.test.system.InstanceManager;
import org.apache.zookeeper.test.system.NoAssignmentException;
import org.apache.zookeeper.test.system.NoAvailableContainers;
import org.apache.zookeeper.test.system.QuorumPeerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateLoad {
    protected static final Logger LOG = LoggerFactory.getLogger(GenerateLoad.class);
    static ServerSocket ss;
    static Set<SlaveThread> slaves;
    static Map<Long, Long> totalByTime;
    static volatile long currentInterval;
    static long lastChange;
    static PrintStream sf;
    static PrintStream tf;
    static final int INTERVAL = 6000;
    private static boolean leaderOnly;
    private static boolean leaderServes;

    static synchronized void add(long time, int count, Socket s) {
        long interval = time / 6000L;
        if (currentInterval == 0L || currentInterval > interval) {
            LOG.info("Dropping " + count + " for " + new Date(time) + " " + currentInterval + ">" + interval);
            return;
        }
        Long total = totalByTime.get(interval);
        if (total == null) {
            totalByTime.put(interval, Long.valueOf(count));
        } else {
            totalByTime.put(interval, total + (long)count);
        }
        tf.println(interval + " " + count + " " + s);
    }

    static synchronized long remove(long interval) {
        Long total = totalByTime.remove(interval);
        return total == null ? -1L : total;
    }

    static synchronized void sendChange(int percentage) {
        long now;
        long start = now = Time.currentElapsedTime();
        ReporterThread.percentage = percentage;
        for (SlaveThread st : slaves.toArray(new SlaveThread[0])) {
            st.send(percentage);
        }
        now = Time.currentElapsedTime();
        long delay = now - start;
        if (delay > 1000L) {
            LOG.info("Delay of " + delay + " to send new percentage");
        }
        lastChange = now;
    }

    private static String[] processOptions(String[] args) {
        ArrayList<String> newArgs = new ArrayList<String>();
        for (String a : args) {
            if (a.equals("--leaderOnly")) {
                leaderOnly = true;
                leaderServes = true;
                continue;
            }
            if (a.equals("--leaderServes")) {
                leaderServes = true;
                continue;
            }
            newArgs.add(a);
        }
        return newArgs.toArray(new String[0]);
    }

    public static void main(String[] args) throws InterruptedException, KeeperException, NoAvailableContainers, DuplicateNameException, NoAssignmentException {
        if ((args = GenerateLoad.processOptions(args)).length == 5) {
            try {
                String line;
                int i;
                StringBuilder zkHostPort;
                int clientCount;
                int port;
                InstanceManager im;
                block22: {
                    StatusWatcher statusWatcher = new StatusWatcher();
                    ZooKeeper zk = new ZooKeeper(args[0], 15000, (Watcher)statusWatcher);
                    if (!statusWatcher.waitConnected(5000L)) {
                        LOG.error("Could not connect to " + args[0]);
                        return;
                    }
                    im = new InstanceManager(zk, args[1]);
                    ss = new ServerSocket(0);
                    port = ss.getLocalPort();
                    int serverCount = Integer.parseInt(args[2]);
                    clientCount = Integer.parseInt(args[3]);
                    StringBuilder quorumHostPort = new StringBuilder();
                    zkHostPort = new StringBuilder();
                    for (i = 0; i < serverCount; ++i) {
                        String[] r = QuorumPeerInstance.createServer(im, i, leaderServes);
                        if (i > 0) {
                            quorumHostPort.append(',');
                            zkHostPort.append(',');
                        }
                        zkHostPort.append(r[0]);
                        quorumHostPort.append(r[1]);
                        quorumHostPort.append(";" + r[0].split(":")[1]);
                    }
                    for (i = 0; i < serverCount; ++i) {
                        QuorumPeerInstance.startInstance(im, quorumHostPort.toString(), i);
                    }
                    if (leaderOnly) {
                        IOException lastException;
                        int tries = 0;
                        do {
                            Thread.sleep(1000L);
                            lastException = null;
                            String[] parts = zkHostPort.toString().split(",");
                            for (int i2 = 0; i2 < parts.length; ++i2) {
                                try {
                                    String mode = GenerateLoad.getMode(parts[i2]);
                                    if (!mode.equals("leader")) continue;
                                    zkHostPort = new StringBuilder(parts[i2]);
                                    LOG.info("Connecting exclusively to " + zkHostPort.toString());
                                    break block22;
                                }
                                catch (IOException e) {
                                    lastException = e;
                                }
                            }
                        } while (tries++ <= 3);
                        throw lastException;
                    }
                }
                for (i = 0; i < clientCount; ++i) {
                    im.assignInstance("client" + i, GeneratorInstance.class, zkHostPort.toString() + ' ' + InetAddress.getLocalHost().getCanonicalHostName() + ':' + port, 1);
                }
                new AcceptorThread();
                new ReporterThread();
                BufferedReader is = new BufferedReader(new InputStreamReader(System.in));
                while ((line = is.readLine()) != null) {
                    try {
                        int number;
                        String[] cmdNumber = line.split(" ");
                        if (cmdNumber[0].equals("percentage") && cmdNumber.length > 1) {
                            number = Integer.parseInt(cmdNumber[1]);
                            if (number < 0 || number > 100) {
                                throw new NumberFormatException("must be between 0 and 100");
                            }
                            GenerateLoad.sendChange(number);
                            continue;
                        }
                        if (cmdNumber[0].equals("sleep") && cmdNumber.length > 1) {
                            number = Integer.parseInt(cmdNumber[1]);
                            Thread.sleep(number * 1000);
                            continue;
                        }
                        if (cmdNumber[0].equals("save") && cmdNumber.length > 1) {
                            sf = new PrintStream(cmdNumber[1]);
                            continue;
                        }
                        LOG.error("Commands must be:");
                        LOG.error("\tpercentage new_write_percentage");
                        LOG.error("\tsleep seconds_to_sleep");
                        LOG.error("\tsave file_to_save_output");
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Not a valid number: " + e.getMessage());
                    }
                }
            }
            catch (NumberFormatException e) {
                GenerateLoad.doUsage();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(ExitCode.INVALID_INVOCATION.getValue());
            }
        } else {
            GenerateLoad.doUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMode(String hostPort) throws NumberFormatException, UnknownHostException, IOException {
        String[] parts = hostPort.split(":");
        Socket s = new Socket(parts[0], Integer.parseInt(parts[1]));
        s.getOutputStream().write("stat".getBytes());
        BufferedReader br = new BufferedReader(new InputStreamReader(s.getInputStream()));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("Mode: ")) continue;
                String string = line.substring(6);
                return string;
            }
            String string = "unknown";
            return string;
        }
        finally {
            s.close();
        }
    }

    private static void doUsage() {
        System.err.println("USAGE: " + GenerateLoad.class.getName() + " [--leaderOnly] [--leaderServes] zookeeper_host:port containerPrefix #ofServers #ofClients requestSize");
        System.exit(ExitCode.INVALID_INVOCATION.getValue());
    }

    static {
        slaves = Collections.synchronizedSet(new HashSet());
        totalByTime = new HashMap<Long, Long>();
        try {
            tf = new PrintStream(new FileOutputStream("trace"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static class StatusWatcher
    implements Watcher {
        volatile boolean connected;

        private StatusWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (event.getType() == Watcher.Event.EventType.None) {
                StatusWatcher statusWatcher = this;
                synchronized (statusWatcher) {
                    this.connected = event.getState() == Watcher.Event.KeeperState.SyncConnected;
                    this.notifyAll();
                }
            }
        }

        public synchronized boolean waitConnected(long timeout) throws InterruptedException {
            long endTime = Time.currentElapsedTime() + timeout;
            while (!this.connected && Time.currentElapsedTime() < endTime) {
                this.wait(endTime - Time.currentElapsedTime());
            }
            return this.connected;
        }
    }

    public static class GeneratorInstance
    implements Instance {
        byte[] bytes;
        int percentage = -1;
        int errors;
        final Object statSync = new Object();
        int finished;
        int reads;
        int writes;
        int rlatency;
        int wlatency;
        int outstanding;
        volatile boolean alive;
        Socket s;
        ZooKeeperThread zkThread;
        SenderThread sendThread;
        Instance.Reporter r;

        @Override
        public void configure(final String params) {
            LOG.info("Got " + params);
            new Thread(){

                @Override
                public void run() {
                    try {
                        String line;
                        String[] parts = params.split(" ");
                        String[] hostPort = parts[1].split(":");
                        int bytesSize = 1024;
                        if (parts.length == 3) {
                            try {
                                bytesSize = Integer.parseInt(parts[2]);
                            }
                            catch (Exception e) {
                                LOG.error("Not an integer: " + parts[2]);
                            }
                        }
                        bytes = new byte[bytesSize];
                        s = new Socket(hostPort[0], Integer.parseInt(hostPort[1]));
                        zkThread = new ZooKeeperThread(parts[0]);
                        sendThread = new SenderThread(s);
                        BufferedReader is = new BufferedReader(new InputStreamReader(s.getInputStream()));
                        while ((line = is.readLine()) != null) {
                            percentage = Integer.parseInt(line);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }

        @Override
        public void setReporter(Instance.Reporter r) {
            this.r = r;
        }

        @Override
        public void start() {
            try {
                this.r.report("started");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void stop() {
            this.alive = false;
            this.zkThread.interrupt();
            this.sendThread.interrupt();
            try {
                this.zkThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                this.sendThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                this.r.report("stopped");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.s.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        class SenderThread
        extends Thread {
            Socket s;

            SenderThread(Socket s) {
                this.s = s;
                this.setDaemon(true);
                this.start();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    OutputStream os = this.s.getOutputStream();
                    GeneratorInstance.this.finished = 0;
                    GeneratorInstance.this.errors = 0;
                    while (GeneratorInstance.this.alive) {
                        Thread.sleep(300L);
                        if (GeneratorInstance.this.percentage == -1 || GeneratorInstance.this.finished == 0 && GeneratorInstance.this.errors == 0) continue;
                        String report = Time.currentElapsedTime() + " " + GeneratorInstance.this.percentage + " " + GeneratorInstance.this.finished + " " + GeneratorInstance.this.errors + " " + GeneratorInstance.this.outstanding + "\n";
                        Object object = GeneratorInstance.this.statSync;
                        synchronized (object) {
                            GeneratorInstance.this.finished = 0;
                            GeneratorInstance.this.errors = 0;
                            GeneratorInstance.this.reads = 0;
                            GeneratorInstance.this.writes = 0;
                            GeneratorInstance.this.rlatency = 0;
                            GeneratorInstance.this.wlatency = 0;
                        }
                        os.write(report.getBytes());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        class ZooKeeperThread
        extends Thread
        implements Watcher,
        AsyncCallback.DataCallback,
        AsyncCallback.StatCallback {
            String host;
            static final int outstandingLimit = 100;
            Random r = new Random();
            String path;
            ZooKeeper zk;
            boolean connected;

            ZooKeeperThread(String host) {
                this.setDaemon(true);
                GeneratorInstance.this.alive = true;
                this.host = host;
                this.start();
            }

            synchronized void incOutstanding() throws InterruptedException {
                ++GeneratorInstance.this.outstanding;
                while (GeneratorInstance.this.outstanding > 100) {
                    this.wait();
                }
            }

            synchronized void decOutstanding() {
                --GeneratorInstance.this.outstanding;
                this.notifyAll();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.zk = new ZooKeeper(this.host, 60000, (Watcher)this);
                    ZooKeeperThread zooKeeperThread = this;
                    synchronized (zooKeeperThread) {
                        if (!this.connected) {
                            this.wait(20000L);
                        }
                    }
                    for (int i = 0; i < 300; ++i) {
                        try {
                            Thread.sleep(100L);
                            this.path = this.zk.create("/client", new byte[16], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
                            break;
                        }
                        catch (KeeperException e) {
                            LOG.error("keeper exception thrown", (Throwable)e);
                            continue;
                        }
                    }
                    if (this.path == null) {
                        LOG.error("Couldn't create a node in /!");
                        return;
                    }
                    while (GeneratorInstance.this.alive) {
                        if (this.r.nextInt(100) < GeneratorInstance.this.percentage) {
                            this.zk.setData(this.path, GeneratorInstance.this.bytes, -1, (AsyncCallback.StatCallback)this, (Object)System.currentTimeMillis());
                        } else {
                            this.zk.getData(this.path, false, (AsyncCallback.DataCallback)this, (Object)System.currentTimeMillis());
                        }
                        this.incOutstanding();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    GeneratorInstance.this.alive = false;
                    try {
                        this.zk.close();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(WatchedEvent event) {
                LOG.info(event.toString());
                ZooKeeperThread zooKeeperThread = this;
                synchronized (zooKeeperThread) {
                    if (event.getType() == Watcher.Event.EventType.None) {
                        this.connected = event.getState() == Watcher.Event.KeeperState.SyncConnected;
                        this.notifyAll();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                this.decOutstanding();
                Object object = GeneratorInstance.this.statSync;
                synchronized (object) {
                    if (!GeneratorInstance.this.alive) {
                        return;
                    }
                    if (rc != 0) {
                        LOG.info("Got rc = " + rc);
                        ++GeneratorInstance.this.errors;
                    } else {
                        ++GeneratorInstance.this.finished;
                        GeneratorInstance.this.rlatency = (int)((long)GeneratorInstance.this.rlatency + (Time.currentElapsedTime() - (Long)ctx));
                        ++GeneratorInstance.this.reads;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResult(int rc, String path, Object ctx, Stat stat) {
                this.decOutstanding();
                Object object = GeneratorInstance.this.statSync;
                synchronized (object) {
                    if (rc != 0) {
                        LOG.info("Got rc = " + rc);
                        ++GeneratorInstance.this.errors;
                    } else {
                        ++GeneratorInstance.this.finished;
                        GeneratorInstance.this.wlatency = (int)((long)GeneratorInstance.this.wlatency + (Time.currentElapsedTime() - (Long)ctx));
                        ++GeneratorInstance.this.writes;
                    }
                }
            }
        }
    }

    static class ReporterThread
    extends Thread {
        static int percentage;

        ReporterThread() {
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                currentInterval = Time.currentElapsedTime() / 6000L;
                Thread.sleep(12000L);
                long min = 99999L;
                long max = 0L;
                long total = 0L;
                int number = 0;
                while (true) {
                    long now = Time.currentElapsedTime();
                    long lastInterval = currentInterval++;
                    long count = GenerateLoad.remove(lastInterval);
                    count = count * 1000L / 6000L;
                    if (lastChange != 0L && lastChange + 18000L < now) {
                        if (count < min) {
                            min = count;
                        }
                        if (count > max) {
                            max = count;
                        }
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(lastInterval * 6000L);
                        String report = lastInterval + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13) + " " + percentage + "% " + count + " " + min + " " + (double)(total += count) / (double)(++number) + " " + max;
                        LOG.info(report);
                        if (sf != null) {
                            sf.println(report);
                        }
                    } else {
                        total = 0L;
                        max = 0L;
                        min = 999999999L;
                        number = 0;
                    }
                    Thread.sleep(6000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    static class AcceptorThread
    extends Thread {
        AcceptorThread() {
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        Socket s = ss.accept();
                        LOG.info("Accepted connection from " + s);
                        slaves.add(new SlaveThread(s));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Iterator<SlaveThread> it = slaves.iterator();
                    while (it.hasNext()) {
                        SlaveThread st = it.next();
                        it.remove();
                        st.close();
                    }
                }
            }
            catch (Throwable throwable) {
                Iterator<SlaveThread> it = slaves.iterator();
                while (it.hasNext()) {
                    SlaveThread st = it.next();
                    it.remove();
                    st.close();
                }
                throw throwable;
            }
        }
    }

    static class SlaveThread
    extends Thread {
        Socket s;

        SlaveThread(Socket s) {
            this.setDaemon(true);
            this.s = s;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String result;
                LOG.info("Connected to " + this.s);
                BufferedReader is = new BufferedReader(new InputStreamReader(this.s.getInputStream()));
                while ((result = is.readLine()) != null) {
                    String[] timePercentCount = result.split(" ");
                    if (timePercentCount.length != 5) {
                        LOG.error("Got " + result + " from " + this.s + " exitng.");
                        throw new IOException(result);
                    }
                    long time = Long.parseLong(timePercentCount[0]);
                    int count = Integer.parseInt(timePercentCount[2]);
                    int errs = Integer.parseInt(timePercentCount[3]);
                    if (errs > 0) {
                        LOG.error(this.s + " Got an error! " + errs);
                    }
                    GenerateLoad.add(time, count, this.s);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.close();
            }
        }

        void send(int percentage) {
            try {
                this.s.getOutputStream().write((percentage + "\n").getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        void close() {
            try {
                LOG.info("Closing " + this.s);
                slaves.remove(this);
                this.s.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

