/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.graph.FilterException;
import org.apache.zookeeper.graph.FilterOp;
import org.apache.zookeeper.graph.Log4JSource;
import org.apache.zookeeper.graph.LogEntry;
import org.apache.zookeeper.graph.LogIterator;
import org.apache.zookeeper.graph.LogSource;
import org.apache.zookeeper.graph.TxnLogSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedLogSource
implements LogSource {
    private static final Logger LOG = LoggerFactory.getLogger(MergedLogSource.class);
    protected List<LogSource> sources = new ArrayList<LogSource>();
    private long starttime = 0L;
    private long endtime = 0L;
    private long size = 0L;

    @Override
    public boolean overlapsRange(long starttime, long endtime) {
        return starttime <= this.endtime && endtime >= this.starttime;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long getStartTime() {
        return this.starttime;
    }

    @Override
    public long getEndTime() {
        return this.endtime;
    }

    @Override
    public LogIterator iterator(long starttime, long endtime) throws IllegalArgumentException {
        try {
            return this.iterator(starttime, endtime, null);
        }
        catch (FilterException fe) {
            assert (false);
            return null;
        }
    }

    @Override
    public LogIterator iterator(long starttime, long endtime, FilterOp filter) throws IllegalArgumentException, FilterException {
        if (endtime < starttime) {
            throw new IllegalArgumentException("End time (" + endtime + ") must be greater or equal to starttime (" + starttime + ")");
        }
        return new MergedLogSourceIterator(this, starttime, endtime, filter);
    }

    @Override
    public LogIterator iterator() throws IllegalArgumentException {
        return this.iterator(this.starttime, this.endtime + 1L);
    }

    public MergedLogSource(String[] files) throws IOException {
        this.sources.clear();
        for (String f : files) {
            this.addSource(f);
        }
    }

    public void addSource(String f) throws IOException {
        LogSource s = null;
        s = TxnLogSource.isTransactionFile(f) ? new TxnLogSource(f) : new Log4JSource(f);
        this.size += s.size();
        this.endtime = s.getEndTime() > this.endtime ? s.getEndTime() : this.endtime;
        this.starttime = s.getStartTime() < this.starttime || this.starttime == 0L ? s.getStartTime() : this.starttime;
        this.sources.add(s);
    }

    public String toString() {
        String s = "MergedLogSource(size=" + this.size + ", start=" + this.starttime + ", end=" + this.endtime + ")";
        for (LogSource src : this.sources) {
            s = s + "\n\t- " + src;
        }
        return s;
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Time: " + System.currentTimeMillis());
        MergedLogSource s = new MergedLogSource(args);
        System.out.println(s);
        LogIterator iter = s.iterator();
        System.out.println("Time: " + System.currentTimeMillis());
        System.out.println("Iterator Size: " + iter.size());
        System.out.println("Time: " + System.currentTimeMillis());
        iter.close();
        System.out.println("Time: " + System.currentTimeMillis());
    }

    private class MergedLogSourceIterator
    implements LogIterator {
        private LogEntry next = null;
        private long start = 0L;
        private long end = 0L;
        private MergedLogSource src = null;
        private LogIterator[] sources = null;
        private LogEntry[] nexts = null;
        private FilterOp filter = null;

        public MergedLogSourceIterator(MergedLogSource src, long starttime, long endtime, FilterOp filter) throws IllegalArgumentException, FilterException {
            ArrayList<LogIterator> iters = new ArrayList<LogIterator>();
            for (LogSource s : src.sources) {
                if (!s.overlapsRange(starttime, endtime)) continue;
                iters.add(s.iterator(starttime, endtime, filter));
            }
            this.sources = new LogIterator[iters.size()];
            this.sources = iters.toArray(this.sources);
            this.nexts = new LogEntry[iters.size()];
            for (int i = 0; i < this.sources.length; ++i) {
                if (!this.sources[i].hasNext()) continue;
                this.nexts[i] = (LogEntry)this.sources[i].next();
            }
            this.filter = filter;
        }

        public MergedLogSourceIterator(MergedLogSource src, long starttime, long endtime) throws IllegalArgumentException, FilterException {
            this(src, starttime, endtime, null);
        }

        @Override
        public long size() throws IOException {
            long size = 0L;
            for (LogIterator i : this.sources) {
                size += i.size();
            }
            return size;
        }

        @Override
        public boolean hasNext() {
            for (LogEntry n : this.nexts) {
                if (n == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public LogEntry next() {
            int min = -1;
            for (int i = 0; i < this.nexts.length; ++i) {
                if (this.nexts[i] == null) continue;
                if (min == -1) {
                    min = i;
                    continue;
                }
                if (this.nexts[i].getTimestamp() >= this.nexts[min].getTimestamp()) continue;
                min = i;
            }
            if (min == -1) {
                return null;
            }
            LogEntry e = this.nexts[min];
            this.nexts[min] = (LogEntry)this.sources[min].next();
            return e;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("remove not supported for Merged logs");
        }

        @Override
        public void close() throws IOException {
            for (LogIterator i : this.sources) {
                i.close();
            }
        }
    }
}

