/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph.servlets;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.zookeeper.graph.LogIterator;
import org.apache.zookeeper.graph.LogSource;
import org.apache.zookeeper.graph.servlets.JsonServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumEvents
extends JsonServlet {
    private static final Logger LOG = LoggerFactory.getLogger(NumEvents.class);
    private static final int DEFAULT_PERIOD = 1000;
    private LogSource source = null;

    public NumEvents(LogSource src) throws Exception {
        this.source = src;
    }

    @Override
    String handleRequest(JsonServlet.JsonRequest request) throws Exception {
        String output = "";
        long starttime = 0L;
        long endtime = 0L;
        long period = 0L;
        starttime = request.getNumber("start", 0L);
        endtime = request.getNumber("end", 0L);
        period = request.getNumber("period", 0L);
        if (starttime == 0L) {
            starttime = this.source.getStartTime();
        }
        if (endtime == 0L) {
            endtime = period > 0L ? starttime + period : this.source.getEndTime();
        }
        long size = 0L;
        LogIterator iter = this.source.iterator(starttime, endtime);
        size = iter.size();
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode data = mapper.createObjectNode();
        data.put("startTime", starttime);
        data.put("endTime", endtime);
        data.put("numEntries", iter.size());
        if (LOG.isDebugEnabled()) {
            LOG.debug("handle(start= " + starttime + ", end=" + endtime + ", numEntries=" + size + ")");
        }
        iter.close();
        String jsonString = mapper.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValueAsString((Object)data);
        return jsonString;
    }
}

