/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph.servlets;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.zookeeper.graph.servlets.JsonServlet;

public class Fs
extends JsonServlet {
    @Override
    String handleRequest(JsonServlet.JsonRequest request) throws Exception {
        File base = new File(request.getString("path", "/"));
        if (!base.exists() || !base.isDirectory()) {
            throw new FileNotFoundException("Couldn't find [" + request + "]");
        }
        File[] files = base.listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.isDirectory() != o2.isDirectory()) {
                    if (o1.isDirectory()) {
                        return -1;
                    }
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        String jsonString = Fs.generateJSON(files);
        return jsonString;
    }

    protected static String generateJSON(File[] files) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode fileList = mapper.createArrayNode();
        for (File f : files) {
            ObjectNode node = mapper.createObjectNode().objectNode();
            node.put("file", f.getName());
            node.put("type", f.isDirectory() ? "D" : "F");
            node.put("path", f.getCanonicalPath());
            fileList.add((JsonNode)node);
        }
        String jsonString = mapper.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValueAsString((Object)fileList);
        return jsonString;
    }
}

