/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cluster.protocol;

import com.google.common.collect.Maps;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.HeartbeatRequest;
import io.atomix.protocols.raft.protocol.HeartbeatResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.serializer.Serializer;
import java.net.ConnectException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.zeppelin.cluster.protocol.LocalRaftProtocol;
import org.apache.zeppelin.cluster.protocol.LocalRaftServerProtocol;

public class LocalRaftClientProtocol
extends LocalRaftProtocol
implements RaftClientProtocol {
    private Function<HeartbeatRequest, CompletableFuture<HeartbeatResponse>> heartbeatHandler;
    private final Map<Long, Consumer<PublishRequest>> publishListeners = Maps.newConcurrentMap();

    public LocalRaftClientProtocol(MemberId memberId, Serializer serializer, Map<MemberId, LocalRaftServerProtocol> servers, Map<MemberId, LocalRaftClientProtocol> clients) {
        super(serializer, servers, clients);
        clients.put(memberId, this);
    }

    private CompletableFuture<LocalRaftServerProtocol> getServer(MemberId memberId) {
        LocalRaftServerProtocol server = this.server(memberId);
        if (server != null) {
            return Futures.completedFuture((Object)server);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    public CompletableFuture<OpenSessionResponse> openSession(MemberId memberId, OpenSessionRequest request) {
        return ((CompletableFuture)this.getServer(memberId).thenCompose(protocol -> protocol.openSession(this.encode(request)))).thenApply(this::decode);
    }

    public CompletableFuture<CloseSessionResponse> closeSession(MemberId memberId, CloseSessionRequest request) {
        return ((CompletableFuture)this.getServer(memberId).thenCompose(protocol -> protocol.closeSession(this.encode(request)))).thenApply(this::decode);
    }

    public CompletableFuture<KeepAliveResponse> keepAlive(MemberId memberId, KeepAliveRequest request) {
        return ((CompletableFuture)this.getServer(memberId).thenCompose(protocol -> protocol.keepAlive(this.encode(request)))).thenApply(this::decode);
    }

    public CompletableFuture<QueryResponse> query(MemberId memberId, QueryRequest request) {
        return ((CompletableFuture)this.getServer(memberId).thenCompose(protocol -> protocol.query(this.encode(request)))).thenApply(this::decode);
    }

    public CompletableFuture<CommandResponse> command(MemberId memberId, CommandRequest request) {
        return ((CompletableFuture)this.getServer(memberId).thenCompose(protocol -> protocol.command(this.encode(request)))).thenApply(this::decode);
    }

    public CompletableFuture<MetadataResponse> metadata(MemberId memberId, MetadataRequest request) {
        return ((CompletableFuture)this.getServer(memberId).thenCompose(protocol -> protocol.metadata(this.encode(request)))).thenApply(this::decode);
    }

    CompletableFuture<byte[]> heartbeat(byte[] request) {
        if (this.heartbeatHandler != null) {
            return this.heartbeatHandler.apply((HeartbeatRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    public void registerHeartbeatHandler(Function<HeartbeatRequest, CompletableFuture<HeartbeatResponse>> handler) {
        this.heartbeatHandler = handler;
    }

    public void unregisterHeartbeatHandler() {
        this.heartbeatHandler = null;
    }

    public void reset(Set<MemberId> members, ResetRequest request) {
        members.forEach(nodeId -> {
            LocalRaftServerProtocol server = this.server((MemberId)nodeId);
            if (server != null) {
                server.reset(request.session(), this.encode(request));
            }
        });
    }

    void publish(long sessionId, byte[] request) {
        Consumer<PublishRequest> listener = this.publishListeners.get(sessionId);
        if (listener != null) {
            listener.accept((PublishRequest)this.decode(request));
        }
    }

    public void registerPublishListener(SessionId sessionId, Consumer<PublishRequest> listener, Executor executor) {
        this.publishListeners.put((Long)sessionId.id(), request -> executor.execute(() -> listener.accept((PublishRequest)request)));
    }

    public void unregisterPublishListener(SessionId sessionId) {
        this.publishListeners.remove(sessionId.id());
    }
}

