/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yetus.maven.plugin.fileops;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@Mojo(name="bin4libs", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public final class MakeBins4Libs
extends AbstractMojo {
    @Parameter(defaultValue="bin")
    private String bindir;
    @Parameter(defaultValue="lib")
    private String libdir;
    @Parameter(defaultValue="ASL20")
    private String license;
    @Parameter(defaultValue="${project.build.directory}/${project.artifactId}-${project.version}")
    private String basedir;
    private String wrapper = "exec \"$(dirname -- \"${BASH_SOURCE-0}\")/../";
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;

    public void execute() throws MojoExecutionException {
        Path libPath = Paths.get(this.libdir, new String[0]);
        Path binPath = Paths.get(this.bindir, new String[0]);
        if (!libPath.isAbsolute()) {
            libPath = Paths.get(this.basedir, this.libdir);
        }
        if (!binPath.isAbsolute()) {
            binPath = Paths.get(this.basedir, this.bindir);
        }
        try {
            binPath.toFile().mkdir();
        }
        catch (Exception x) {
            throw new MojoExecutionException("Unable to create " + binPath.toString() + ": " + x);
        }
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_READ);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        File libFile = libPath.toFile();
        if (libFile == null) {
            throw new MojoExecutionException("Cannot convert " + libPath.toString());
        }
        File[] libListOfFiles = libFile.listFiles();
        System.out.println("Processing dir " + libPath.toString());
        for (int i = 0; i < libListOfFiles.length; ++i) {
            if (!libListOfFiles[i].isFile()) continue;
            String basename = FilenameUtils.getBaseName((String)libListOfFiles[i].getName());
            String theName = FilenameUtils.getName((String)libListOfFiles[i].getName());
            String binName = Paths.get(binPath.toString(), basename).toString();
            System.out.println("Creating file " + binName);
            try {
                PrintWriter binFile = new PrintWriter(binName, this.encoding);
                String noneString = "none";
                binFile.println("#!/usr/bin/env bash");
                if (!this.license.equals(noneString)) {
                    InputStream inLicense = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("licenses/" + this.license + ".txt");
                    IOUtils.copy((InputStream)inLicense, (Writer)binFile);
                    inLicense.close();
                }
                binFile.println(this.wrapper + this.libdir + "/" + theName + "\" \"$@\"");
                binFile.close();
                Files.setPosixFilePermissions(Paths.get(binName, new String[0]), perms);
                continue;
            }
            catch (Exception x) {
                throw new MojoExecutionException("Unable to create " + binName + ": " + x);
            }
        }
    }
}

