/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import org.apache.fop.Version;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColorHandler;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPaintingState;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.svg.PDFContext;
import org.apache.fop.svg.PDFGraphics2D;

public class PDFDocumentGraphics2D
extends PDFGraphics2D {
    private final PDFContext pdfContext;
    private int width;
    private int height;
    private float svgWidth;
    private float svgHeight;
    public static final int NORMAL_PDF_RESOLUTION = 72;
    public static final int DEFAULT_NATIVE_DPI = 300;
    private float deviceDPI = 300.0f;
    protected Shape initialClip;
    protected AffineTransform initialTransform;

    public PDFDocumentGraphics2D(boolean textAsShapes) {
        super(textAsShapes);
        this.pdfDoc = new PDFDocument("Apache FOP Version " + Version.getVersion() + ": PDFDocumentGraphics2D");
        this.pdfContext = new PDFContext();
        this.colorHandler = new PDFColorHandler(this.pdfDoc.getResources(), this.resourceContext);
    }

    public PDFDocumentGraphics2D(boolean textAsShapes, OutputStream stream, int width, int height) throws IOException {
        this(textAsShapes);
        this.setupDocument(stream, width, height);
    }

    public PDFDocumentGraphics2D() {
        this(false);
    }

    public void setupDocument(OutputStream stream, int width, int height) throws IOException {
        this.width = width;
        this.height = height;
        this.pdfDoc.outputHeader(stream);
        this.setOutputStream(stream);
    }

    public void setupDefaultFontInfo() {
        if (this.fontInfo == null) {
            FontInfo fontInfo = new FontInfo();
            boolean base14Kerning = false;
            FontSetup.setup(fontInfo, base14Kerning);
            this.setFontInfo(fontInfo);
        }
    }

    public void setDeviceDPI(float deviceDPI) {
        this.deviceDPI = deviceDPI;
    }

    public float getDeviceDPI() {
        return this.deviceDPI;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public PDFDocument getPDFDocument() {
        return this.pdfDoc;
    }

    public PDFContext getPDFContext() {
        return this.pdfContext;
    }

    public void setSVGDimension(float w, float h) {
        this.svgWidth = w;
        this.svgHeight = h;
    }

    public void setBackgroundColor(Color col) {
        StringBuffer sb = new StringBuffer();
        sb.append("q\n");
        this.colorHandler.establishColor(sb, col, true, true);
        sb.append("0 0 ").append(this.width).append(" ").append(this.height).append(" re\n");
        sb.append("f\n");
        sb.append("Q\n");
        this.currentStream.write(sb.toString());
    }

    public void nextPage() {
        this.closePage();
    }

    public void nextPage(int width, int height) {
        this.width = width;
        this.height = height;
        this.nextPage();
    }

    protected void closePage() {
        if (!this.pdfContext.isPagePending()) {
            return;
        }
        this.currentStream.write("Q\n");
        PDFStream pdfStream = this.pdfDoc.getFactory().makeStream("content", false);
        pdfStream.add(this.getString());
        this.pdfDoc.registerObject(pdfStream);
        this.pdfContext.getCurrentPage().setContents(new PDFReference(pdfStream));
        PDFAnnotList annots = this.pdfContext.getCurrentPage().getAnnotations();
        if (annots != null) {
            this.pdfDoc.addObject(annots);
        }
        this.pdfDoc.addObject(this.pdfContext.getCurrentPage());
        this.currentStream = null;
        this.pdfContext.clearCurrentPage();
    }

    @Override
    protected void preparePainting() {
        if (this.pdfContext.isPagePending()) {
            return;
        }
        if (!this.textAsShapes && this.getFontInfo() == null) {
            this.setupDefaultFontInfo();
        }
        try {
            this.startPage();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    protected void startPage() throws IOException {
        if (this.pdfContext.isPagePending()) {
            throw new IllegalStateException("Close page first before starting another");
        }
        this.paintingState = new PDFPaintingState();
        if (this.initialTransform == null) {
            this.initialTransform = this.getTransform();
            this.initialClip = this.getClip();
        } else {
            this.setTransform(this.initialTransform);
            this.setClip(this.initialClip);
        }
        this.currentFontName = "";
        this.currentFontSize = 0.0f;
        if (this.currentStream == null) {
            this.currentStream = new StringWriter();
        }
        PDFResources pdfResources = this.pdfDoc.getResources();
        PDFPage page = this.pdfDoc.getFactory().makePage(pdfResources, this.width, this.height);
        this.resourceContext = page;
        this.pdfContext.setCurrentPage(page);
        this.pageRef = page.makeReference();
        this.currentStream.write("q\n");
        AffineTransform at = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)this.height);
        this.currentStream.write("1 0 0 -1 0 " + this.height + " cm\n");
        if (this.svgWidth != 0.0f) {
            double scaleX = (float)this.width / this.svgWidth;
            double scaleY = (float)this.height / this.svgHeight;
            at.scale(scaleX, scaleY);
            this.currentStream.write("" + PDFNumber.doubleOut(scaleX) + " 0 0 " + PDFNumber.doubleOut(scaleY) + " 0 0 cm\n");
        }
        if (this.deviceDPI != 72.0f) {
            double s = 72.0f / this.deviceDPI;
            at.scale(s, s);
            this.currentStream.write("" + PDFNumber.doubleOut(s) + " 0 0 " + PDFNumber.doubleOut(s) + " 0 0 cm\n");
            this.scale(1.0 / s, 1.0 / s);
        }
        this.paintingState.concatenate(at);
        this.pdfContext.increasePageCount();
    }

    public void finish() throws IOException {
        this.closePage();
        if (this.fontInfo != null) {
            this.pdfDoc.getResources().addFonts(this.pdfDoc, this.fontInfo, null);
        }
        this.pdfDoc.output(this.outputStream);
        this.pdfDoc.outputTrailer(this.outputStream);
        this.outputStream.flush();
    }

    public PDFDocumentGraphics2D(PDFDocumentGraphics2D g) {
        super(g);
        this.pdfContext = g.pdfContext;
        this.width = g.width;
        this.height = g.height;
        this.svgWidth = g.svgWidth;
        this.svgHeight = g.svgHeight;
    }

    @Override
    public Graphics create() {
        this.preparePainting();
        return new PDFDocumentGraphics2D(this);
    }

    @Override
    public void drawString(String s, float x, float y) {
        if (this.textAsShapes) {
            Font font = super.getFont();
            FontRenderContext frc = super.getFontRenderContext();
            GlyphVector gv = font.createGlyphVector(frc, s);
            Shape glyphOutline = gv.getOutline(x, y);
            super.fill(glyphOutline);
        } else {
            super.drawString(s, x, y);
        }
    }
}

