/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class TimesItalic
extends Base14Font {
    private static final URI fontFileURI;
    private static final String fontName = "Times-Italic";
    private static final String fullName = "Times Italic";
    private static final Set familyNames;
    private static final int underlinePosition = -100;
    private static final int underlineThickness = 50;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 653;
    private static final int xHeight = 441;
    private static final int ascender = 683;
    private static final int descender = -205;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private static final Rectangle[] boundingBoxes;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private static final Map kerning;
    private boolean enableKerning = false;

    public TimesItalic() {
        this(false);
    }

    public TimesItalic(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    public String getEncodingName() {
        return encoding;
    }

    public URI getFontURI() {
        return fontFileURI;
    }

    public String getFontName() {
        return fontName;
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int size) {
        return size * 683;
    }

    public int getCapHeight(int size) {
        return size * 653;
    }

    public int getDescender(int size) {
        return size * -205;
    }

    public int getXHeight(int size) {
        return size * 441;
    }

    public int getUnderlinePosition(int size) {
        return size * -100;
    }

    public int getUnderlineThickness(int size) {
        return size * 50;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int i, int size) {
        return size * width[i];
    }

    public Rectangle getBoundingBox(int glyphIndex, int size) {
        Rectangle bbox = boundingBoxes[glyphIndex];
        return new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    public boolean hasKerningInfo() {
        return this.enableKerning;
    }

    public Map getKerningInfo() {
        return kerning;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        URI uri = null;
        try {
            uri = new URI("base14:" + fontName.toLowerCase());
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        fontFileURI = uri;
        width = new int[256];
        boundingBoxes = new Rectangle[256];
        TimesItalic.width[65] = 611;
        TimesItalic.boundingBoxes[65] = new Rectangle(-51, 0, 615, 668);
        TimesItalic.width[198] = 889;
        TimesItalic.boundingBoxes[198] = new Rectangle(-27, 0, 938, 653);
        TimesItalic.width[193] = 611;
        TimesItalic.boundingBoxes[193] = new Rectangle(-51, 0, 615, 876);
        TimesItalic.width[194] = 611;
        TimesItalic.boundingBoxes[194] = new Rectangle(-51, 0, 615, 873);
        TimesItalic.width[196] = 611;
        TimesItalic.boundingBoxes[196] = new Rectangle(-51, 0, 615, 818);
        TimesItalic.width[192] = 611;
        TimesItalic.boundingBoxes[192] = new Rectangle(-51, 0, 615, 876);
        TimesItalic.width[197] = 611;
        TimesItalic.boundingBoxes[197] = new Rectangle(-51, 0, 615, 883);
        TimesItalic.width[195] = 611;
        TimesItalic.boundingBoxes[195] = new Rectangle(-51, 0, 617, 836);
        TimesItalic.width[66] = 611;
        TimesItalic.boundingBoxes[66] = new Rectangle(-8, 0, 596, 653);
        TimesItalic.width[67] = 667;
        TimesItalic.boundingBoxes[67] = new Rectangle(66, -18, 623, 684);
        TimesItalic.width[199] = 667;
        TimesItalic.boundingBoxes[199] = new Rectangle(66, -217, 623, 883);
        TimesItalic.width[68] = 722;
        TimesItalic.boundingBoxes[68] = new Rectangle(-8, 0, 708, 653);
        TimesItalic.width[69] = 611;
        TimesItalic.boundingBoxes[69] = new Rectangle(-1, 0, 635, 653);
        TimesItalic.width[201] = 611;
        TimesItalic.boundingBoxes[201] = new Rectangle(-1, 0, 635, 876);
        TimesItalic.width[202] = 611;
        TimesItalic.boundingBoxes[202] = new Rectangle(-1, 0, 635, 873);
        TimesItalic.width[203] = 611;
        TimesItalic.boundingBoxes[203] = new Rectangle(-1, 0, 635, 818);
        TimesItalic.width[200] = 611;
        TimesItalic.boundingBoxes[200] = new Rectangle(-1, 0, 635, 876);
        TimesItalic.width[208] = 722;
        TimesItalic.boundingBoxes[208] = new Rectangle(-8, 0, 708, 653);
        TimesItalic.width[128] = 500;
        TimesItalic.boundingBoxes[128] = new Rectangle(0, 0, 0, 0);
        TimesItalic.width[70] = 611;
        TimesItalic.boundingBoxes[70] = new Rectangle(8, 0, 637, 653);
        TimesItalic.width[71] = 722;
        TimesItalic.boundingBoxes[71] = new Rectangle(52, -18, 670, 684);
        TimesItalic.width[72] = 722;
        TimesItalic.boundingBoxes[72] = new Rectangle(-8, 0, 775, 653);
        TimesItalic.width[73] = 333;
        TimesItalic.boundingBoxes[73] = new Rectangle(-8, 0, 392, 653);
        TimesItalic.width[205] = 333;
        TimesItalic.boundingBoxes[205] = new Rectangle(-8, 0, 441, 876);
        TimesItalic.width[206] = 333;
        TimesItalic.boundingBoxes[206] = new Rectangle(-8, 0, 433, 873);
        TimesItalic.width[207] = 333;
        TimesItalic.boundingBoxes[207] = new Rectangle(-8, 0, 443, 818);
        TimesItalic.width[204] = 333;
        TimesItalic.boundingBoxes[204] = new Rectangle(-8, 0, 392, 876);
        TimesItalic.width[74] = 444;
        TimesItalic.boundingBoxes[74] = new Rectangle(-6, -18, 497, 671);
        TimesItalic.width[75] = 667;
        TimesItalic.boundingBoxes[75] = new Rectangle(7, 0, 715, 653);
        TimesItalic.width[76] = 556;
        TimesItalic.boundingBoxes[76] = new Rectangle(-8, 0, 567, 653);
        TimesItalic.width[77] = 833;
        TimesItalic.boundingBoxes[77] = new Rectangle(-18, 0, 891, 653);
        TimesItalic.width[78] = 667;
        TimesItalic.boundingBoxes[78] = new Rectangle(-20, -15, 747, 668);
        TimesItalic.width[209] = 667;
        TimesItalic.boundingBoxes[209] = new Rectangle(-20, -15, 747, 851);
        TimesItalic.width[79] = 722;
        TimesItalic.boundingBoxes[79] = new Rectangle(60, -18, 639, 684);
        TimesItalic.width[140] = 944;
        TimesItalic.boundingBoxes[140] = new Rectangle(49, -8, 915, 674);
        TimesItalic.width[211] = 722;
        TimesItalic.boundingBoxes[211] = new Rectangle(60, -18, 639, 894);
        TimesItalic.width[212] = 722;
        TimesItalic.boundingBoxes[212] = new Rectangle(60, -18, 639, 891);
        TimesItalic.width[214] = 722;
        TimesItalic.boundingBoxes[214] = new Rectangle(60, -18, 639, 836);
        TimesItalic.width[210] = 722;
        TimesItalic.boundingBoxes[210] = new Rectangle(60, -18, 639, 894);
        TimesItalic.width[216] = 722;
        TimesItalic.boundingBoxes[216] = new Rectangle(60, -105, 639, 827);
        TimesItalic.width[213] = 722;
        TimesItalic.boundingBoxes[213] = new Rectangle(60, -18, 639, 854);
        TimesItalic.width[80] = 611;
        TimesItalic.boundingBoxes[80] = new Rectangle(0, 0, 605, 653);
        TimesItalic.width[81] = 722;
        TimesItalic.boundingBoxes[81] = new Rectangle(59, -182, 640, 848);
        TimesItalic.width[82] = 611;
        TimesItalic.boundingBoxes[82] = new Rectangle(-13, 0, 601, 653);
        TimesItalic.width[83] = 500;
        TimesItalic.boundingBoxes[83] = new Rectangle(17, -18, 491, 685);
        TimesItalic.width[138] = 500;
        TimesItalic.boundingBoxes[138] = new Rectangle(17, -18, 503, 891);
        TimesItalic.width[84] = 556;
        TimesItalic.boundingBoxes[84] = new Rectangle(59, 0, 574, 653);
        TimesItalic.width[222] = 611;
        TimesItalic.boundingBoxes[222] = new Rectangle(0, 0, 569, 653);
        TimesItalic.width[85] = 722;
        TimesItalic.boundingBoxes[85] = new Rectangle(102, -18, 663, 671);
        TimesItalic.width[218] = 722;
        TimesItalic.boundingBoxes[218] = new Rectangle(102, -18, 663, 894);
        TimesItalic.width[219] = 722;
        TimesItalic.boundingBoxes[219] = new Rectangle(102, -18, 663, 891);
        TimesItalic.width[220] = 722;
        TimesItalic.boundingBoxes[220] = new Rectangle(102, -18, 663, 836);
        TimesItalic.width[217] = 722;
        TimesItalic.boundingBoxes[217] = new Rectangle(102, -18, 663, 894);
        TimesItalic.width[86] = 611;
        TimesItalic.boundingBoxes[86] = new Rectangle(76, -18, 612, 671);
        TimesItalic.width[87] = 833;
        TimesItalic.boundingBoxes[87] = new Rectangle(71, -18, 835, 671);
        TimesItalic.width[88] = 611;
        TimesItalic.boundingBoxes[88] = new Rectangle(-29, 0, 684, 653);
        TimesItalic.width[89] = 556;
        TimesItalic.boundingBoxes[89] = new Rectangle(78, 0, 555, 653);
        TimesItalic.width[221] = 556;
        TimesItalic.boundingBoxes[221] = new Rectangle(78, 0, 555, 876);
        TimesItalic.width[159] = 556;
        TimesItalic.boundingBoxes[159] = new Rectangle(78, 0, 555, 818);
        TimesItalic.width[90] = 556;
        TimesItalic.boundingBoxes[90] = new Rectangle(-6, 0, 612, 653);
        TimesItalic.width[142] = 556;
        TimesItalic.boundingBoxes[142] = new Rectangle(-6, 0, 612, 873);
        TimesItalic.width[97] = 500;
        TimesItalic.boundingBoxes[97] = new Rectangle(17, -11, 459, 452);
        TimesItalic.width[225] = 500;
        TimesItalic.boundingBoxes[225] = new Rectangle(17, -11, 470, 675);
        TimesItalic.width[226] = 500;
        TimesItalic.boundingBoxes[226] = new Rectangle(17, -11, 459, 672);
        TimesItalic.width[180] = 333;
        TimesItalic.boundingBoxes[180] = new Rectangle(180, 494, 223, 170);
        TimesItalic.width[228] = 500;
        TimesItalic.boundingBoxes[228] = new Rectangle(17, -11, 472, 617);
        TimesItalic.width[230] = 667;
        TimesItalic.boundingBoxes[230] = new Rectangle(23, -11, 617, 452);
        TimesItalic.width[224] = 500;
        TimesItalic.boundingBoxes[224] = new Rectangle(17, -11, 459, 675);
        TimesItalic.width[38] = 778;
        TimesItalic.boundingBoxes[38] = new Rectangle(76, -18, 647, 684);
        TimesItalic.width[229] = 500;
        TimesItalic.boundingBoxes[229] = new Rectangle(17, -11, 459, 702);
        TimesItalic.width[94] = 422;
        TimesItalic.boundingBoxes[94] = new Rectangle(0, 301, 422, 365);
        TimesItalic.width[126] = 541;
        TimesItalic.boundingBoxes[126] = new Rectangle(40, 183, 462, 140);
        TimesItalic.width[42] = 500;
        TimesItalic.boundingBoxes[42] = new Rectangle(128, 255, 364, 411);
        TimesItalic.width[64] = 920;
        TimesItalic.boundingBoxes[64] = new Rectangle(118, -18, 688, 684);
        TimesItalic.width[227] = 500;
        TimesItalic.boundingBoxes[227] = new Rectangle(17, -11, 494, 635);
        TimesItalic.width[98] = 500;
        TimesItalic.boundingBoxes[98] = new Rectangle(23, -11, 450, 694);
        TimesItalic.width[92] = 278;
        TimesItalic.boundingBoxes[92] = new Rectangle(-41, -18, 360, 684);
        TimesItalic.width[124] = 275;
        TimesItalic.boundingBoxes[124] = new Rectangle(105, -217, 66, 1000);
        TimesItalic.width[123] = 400;
        TimesItalic.boundingBoxes[123] = new Rectangle(51, -177, 356, 864);
        TimesItalic.width[125] = 400;
        TimesItalic.boundingBoxes[125] = new Rectangle(-7, -177, 356, 864);
        TimesItalic.width[91] = 389;
        TimesItalic.boundingBoxes[91] = new Rectangle(21, -153, 370, 816);
        TimesItalic.width[93] = 389;
        TimesItalic.boundingBoxes[93] = new Rectangle(12, -153, 370, 816);
        TimesItalic.width[166] = 275;
        TimesItalic.boundingBoxes[166] = new Rectangle(105, -142, 66, 850);
        TimesItalic.width[149] = 350;
        TimesItalic.boundingBoxes[149] = new Rectangle(40, 191, 270, 270);
        TimesItalic.width[99] = 444;
        TimesItalic.boundingBoxes[99] = new Rectangle(30, -11, 395, 452);
        TimesItalic.width[231] = 444;
        TimesItalic.boundingBoxes[231] = new Rectangle(30, -217, 395, 658);
        TimesItalic.width[184] = 333;
        TimesItalic.boundingBoxes[184] = new Rectangle(-30, -217, 212, 217);
        TimesItalic.width[162] = 500;
        TimesItalic.boundingBoxes[162] = new Rectangle(77, -143, 395, 703);
        TimesItalic.width[136] = 333;
        TimesItalic.boundingBoxes[136] = new Rectangle(91, 492, 294, 169);
        TimesItalic.width[58] = 333;
        TimesItalic.boundingBoxes[58] = new Rectangle(50, -11, 211, 452);
        TimesItalic.width[44] = 250;
        TimesItalic.boundingBoxes[44] = new Rectangle(-4, -129, 139, 230);
        TimesItalic.width[169] = 760;
        TimesItalic.boundingBoxes[169] = new Rectangle(41, -18, 678, 684);
        TimesItalic.width[164] = 500;
        TimesItalic.boundingBoxes[164] = new Rectangle(-22, 53, 544, 544);
        TimesItalic.width[100] = 500;
        TimesItalic.boundingBoxes[100] = new Rectangle(15, -13, 512, 696);
        TimesItalic.width[134] = 500;
        TimesItalic.boundingBoxes[134] = new Rectangle(101, -159, 387, 825);
        TimesItalic.width[135] = 500;
        TimesItalic.boundingBoxes[135] = new Rectangle(22, -143, 469, 809);
        TimesItalic.width[176] = 400;
        TimesItalic.boundingBoxes[176] = new Rectangle(101, 390, 286, 286);
        TimesItalic.width[168] = 333;
        TimesItalic.boundingBoxes[168] = new Rectangle(107, 548, 298, 98);
        TimesItalic.width[247] = 675;
        TimesItalic.boundingBoxes[247] = new Rectangle(86, -11, 504, 528);
        TimesItalic.width[36] = 500;
        TimesItalic.boundingBoxes[36] = new Rectangle(31, -89, 466, 820);
        TimesItalic.width[101] = 444;
        TimesItalic.boundingBoxes[101] = new Rectangle(31, -11, 381, 452);
        TimesItalic.width[233] = 444;
        TimesItalic.boundingBoxes[233] = new Rectangle(31, -11, 428, 675);
        TimesItalic.width[234] = 444;
        TimesItalic.boundingBoxes[234] = new Rectangle(31, -11, 410, 672);
        TimesItalic.width[235] = 444;
        TimesItalic.boundingBoxes[235] = new Rectangle(31, -11, 420, 617);
        TimesItalic.width[232] = 444;
        TimesItalic.boundingBoxes[232] = new Rectangle(31, -11, 381, 675);
        TimesItalic.width[56] = 500;
        TimesItalic.boundingBoxes[56] = new Rectangle(30, -7, 463, 683);
        TimesItalic.width[133] = 889;
        TimesItalic.boundingBoxes[133] = new Rectangle(57, -11, 705, 111);
        TimesItalic.width[151] = 889;
        TimesItalic.boundingBoxes[151] = new Rectangle(-6, 197, 900, 46);
        TimesItalic.width[150] = 500;
        TimesItalic.boundingBoxes[150] = new Rectangle(-6, 197, 511, 46);
        TimesItalic.width[61] = 675;
        TimesItalic.boundingBoxes[61] = new Rectangle(86, 120, 504, 266);
        TimesItalic.width[240] = 500;
        TimesItalic.boundingBoxes[240] = new Rectangle(27, -11, 455, 694);
        TimesItalic.width[33] = 333;
        TimesItalic.boundingBoxes[33] = new Rectangle(39, -11, 263, 678);
        TimesItalic.width[161] = 389;
        TimesItalic.boundingBoxes[161] = new Rectangle(59, -205, 263, 678);
        TimesItalic.width[102] = 278;
        TimesItalic.boundingBoxes[102] = new Rectangle(-147, -207, 571, 885);
        TimesItalic.width[53] = 500;
        TimesItalic.boundingBoxes[53] = new Rectangle(15, -7, 476, 673);
        TimesItalic.width[131] = 500;
        TimesItalic.boundingBoxes[131] = new Rectangle(25, -182, 482, 864);
        TimesItalic.width[52] = 500;
        TimesItalic.boundingBoxes[52] = new Rectangle(1, 0, 478, 676);
        TimesItalic.width[103] = 500;
        TimesItalic.boundingBoxes[103] = new Rectangle(8, -206, 464, 647);
        TimesItalic.width[223] = 500;
        TimesItalic.boundingBoxes[223] = new Rectangle(-168, -207, 661, 886);
        TimesItalic.width[96] = 333;
        TimesItalic.boundingBoxes[96] = new Rectangle(121, 492, 190, 172);
        TimesItalic.width[62] = 675;
        TimesItalic.boundingBoxes[62] = new Rectangle(84, -8, 508, 522);
        TimesItalic.width[171] = 500;
        TimesItalic.boundingBoxes[171] = new Rectangle(53, 37, 392, 366);
        TimesItalic.width[187] = 500;
        TimesItalic.boundingBoxes[187] = new Rectangle(55, 37, 392, 366);
        TimesItalic.width[139] = 333;
        TimesItalic.boundingBoxes[139] = new Rectangle(51, 37, 230, 366);
        TimesItalic.width[155] = 333;
        TimesItalic.boundingBoxes[155] = new Rectangle(52, 37, 230, 366);
        TimesItalic.width[104] = 500;
        TimesItalic.boundingBoxes[104] = new Rectangle(19, -9, 459, 692);
        TimesItalic.width[45] = 333;
        TimesItalic.boundingBoxes[45] = new Rectangle(49, 192, 233, 63);
        TimesItalic.width[105] = 278;
        TimesItalic.boundingBoxes[105] = new Rectangle(49, -11, 215, 665);
        TimesItalic.width[237] = 278;
        TimesItalic.boundingBoxes[237] = new Rectangle(49, -11, 306, 675);
        TimesItalic.width[238] = 278;
        TimesItalic.boundingBoxes[238] = new Rectangle(33, -11, 294, 672);
        TimesItalic.width[239] = 278;
        TimesItalic.boundingBoxes[239] = new Rectangle(49, -11, 303, 617);
        TimesItalic.width[236] = 278;
        TimesItalic.boundingBoxes[236] = new Rectangle(49, -11, 235, 675);
        TimesItalic.width[106] = 278;
        TimesItalic.boundingBoxes[106] = new Rectangle(-124, -207, 400, 861);
        TimesItalic.width[107] = 444;
        TimesItalic.boundingBoxes[107] = new Rectangle(14, -11, 447, 694);
        TimesItalic.width[108] = 278;
        TimesItalic.boundingBoxes[108] = new Rectangle(41, -11, 238, 694);
        TimesItalic.width[60] = 675;
        TimesItalic.boundingBoxes[60] = new Rectangle(84, -8, 508, 522);
        TimesItalic.width[172] = 675;
        TimesItalic.boundingBoxes[172] = new Rectangle(86, 108, 504, 278);
        TimesItalic.width[109] = 722;
        TimesItalic.boundingBoxes[109] = new Rectangle(12, -9, 692, 450);
        TimesItalic.width[175] = 333;
        TimesItalic.boundingBoxes[175] = new Rectangle(99, 532, 312, 51);
        TimesItalic.width[181] = 500;
        TimesItalic.boundingBoxes[181] = new Rectangle(-30, -209, 527, 637);
        TimesItalic.width[215] = 675;
        TimesItalic.boundingBoxes[215] = new Rectangle(93, 8, 489, 489);
        TimesItalic.width[110] = 500;
        TimesItalic.boundingBoxes[110] = new Rectangle(14, -9, 460, 450);
        TimesItalic.width[57] = 500;
        TimesItalic.boundingBoxes[57] = new Rectangle(23, -17, 469, 693);
        TimesItalic.width[241] = 500;
        TimesItalic.boundingBoxes[241] = new Rectangle(14, -9, 462, 633);
        TimesItalic.width[35] = 500;
        TimesItalic.boundingBoxes[35] = new Rectangle(2, 0, 538, 676);
        TimesItalic.width[111] = 500;
        TimesItalic.boundingBoxes[111] = new Rectangle(27, -11, 441, 452);
        TimesItalic.width[243] = 500;
        TimesItalic.boundingBoxes[243] = new Rectangle(27, -11, 460, 675);
        TimesItalic.width[244] = 500;
        TimesItalic.boundingBoxes[244] = new Rectangle(27, -11, 441, 672);
        TimesItalic.width[246] = 500;
        TimesItalic.boundingBoxes[246] = new Rectangle(27, -11, 462, 617);
        TimesItalic.width[156] = 667;
        TimesItalic.boundingBoxes[156] = new Rectangle(20, -12, 626, 453);
        TimesItalic.width[242] = 500;
        TimesItalic.boundingBoxes[242] = new Rectangle(27, -11, 441, 675);
        TimesItalic.width[49] = 500;
        TimesItalic.boundingBoxes[49] = new Rectangle(49, 0, 360, 676);
        TimesItalic.width[189] = 750;
        TimesItalic.boundingBoxes[189] = new Rectangle(34, -10, 715, 686);
        TimesItalic.width[188] = 750;
        TimesItalic.boundingBoxes[188] = new Rectangle(33, -10, 703, 686);
        TimesItalic.width[185] = 300;
        TimesItalic.boundingBoxes[185] = new Rectangle(43, 271, 241, 405);
        TimesItalic.width[170] = 276;
        TimesItalic.boundingBoxes[170] = new Rectangle(42, 406, 310, 270);
        TimesItalic.width[186] = 310;
        TimesItalic.boundingBoxes[186] = new Rectangle(67, 406, 295, 270);
        TimesItalic.width[248] = 500;
        TimesItalic.boundingBoxes[248] = new Rectangle(28, -135, 441, 689);
        TimesItalic.width[245] = 500;
        TimesItalic.boundingBoxes[245] = new Rectangle(27, -11, 469, 635);
        TimesItalic.width[112] = 500;
        TimesItalic.boundingBoxes[112] = new Rectangle(-75, -205, 544, 646);
        TimesItalic.width[182] = 523;
        TimesItalic.boundingBoxes[182] = new Rectangle(55, -123, 561, 776);
        TimesItalic.width[40] = 333;
        TimesItalic.boundingBoxes[40] = new Rectangle(42, -181, 273, 850);
        TimesItalic.width[41] = 333;
        TimesItalic.boundingBoxes[41] = new Rectangle(16, -180, 273, 849);
        TimesItalic.width[37] = 833;
        TimesItalic.boundingBoxes[37] = new Rectangle(79, -13, 711, 689);
        TimesItalic.width[46] = 250;
        TimesItalic.boundingBoxes[46] = new Rectangle(27, -11, 111, 111);
        TimesItalic.width[183] = 250;
        TimesItalic.boundingBoxes[183] = new Rectangle(70, 199, 111, 111);
        TimesItalic.width[137] = 1000;
        TimesItalic.boundingBoxes[137] = new Rectangle(25, -19, 985, 725);
        TimesItalic.width[43] = 675;
        TimesItalic.boundingBoxes[43] = new Rectangle(86, 0, 504, 506);
        TimesItalic.width[177] = 675;
        TimesItalic.boundingBoxes[177] = new Rectangle(86, 0, 504, 506);
        TimesItalic.width[113] = 500;
        TimesItalic.boundingBoxes[113] = new Rectangle(25, -209, 458, 650);
        TimesItalic.width[63] = 500;
        TimesItalic.boundingBoxes[63] = new Rectangle(132, -12, 340, 676);
        TimesItalic.width[191] = 500;
        TimesItalic.boundingBoxes[191] = new Rectangle(28, -205, 340, 676);
        TimesItalic.width[34] = 420;
        TimesItalic.boundingBoxes[34] = new Rectangle(144, 421, 288, 245);
        TimesItalic.width[132] = 556;
        TimesItalic.boundingBoxes[132] = new Rectangle(57, -129, 348, 230);
        TimesItalic.width[147] = 556;
        TimesItalic.boundingBoxes[147] = new Rectangle(166, 436, 348, 230);
        TimesItalic.width[148] = 556;
        TimesItalic.boundingBoxes[148] = new Rectangle(151, 436, 348, 230);
        TimesItalic.width[145] = 333;
        TimesItalic.boundingBoxes[145] = new Rectangle(171, 436, 139, 230);
        TimesItalic.width[146] = 333;
        TimesItalic.boundingBoxes[146] = new Rectangle(151, 436, 139, 230);
        TimesItalic.width[130] = 333;
        TimesItalic.boundingBoxes[130] = new Rectangle(44, -129, 139, 230);
        TimesItalic.width[39] = 214;
        TimesItalic.boundingBoxes[39] = new Rectangle(132, 421, 109, 245);
        TimesItalic.width[114] = 389;
        TimesItalic.boundingBoxes[114] = new Rectangle(45, 0, 367, 441);
        TimesItalic.width[174] = 760;
        TimesItalic.boundingBoxes[174] = new Rectangle(41, -18, 678, 684);
        TimesItalic.width[115] = 389;
        TimesItalic.boundingBoxes[115] = new Rectangle(16, -13, 350, 455);
        TimesItalic.width[154] = 389;
        TimesItalic.boundingBoxes[154] = new Rectangle(16, -13, 438, 674);
        TimesItalic.width[167] = 500;
        TimesItalic.boundingBoxes[167] = new Rectangle(53, -162, 408, 828);
        TimesItalic.width[59] = 333;
        TimesItalic.boundingBoxes[59] = new Rectangle(27, -129, 234, 570);
        TimesItalic.width[55] = 500;
        TimesItalic.boundingBoxes[55] = new Rectangle(75, -8, 462, 674);
        TimesItalic.width[54] = 500;
        TimesItalic.boundingBoxes[54] = new Rectangle(30, -7, 491, 693);
        TimesItalic.width[47] = 278;
        TimesItalic.boundingBoxes[47] = new Rectangle(-65, -18, 451, 684);
        TimesItalic.width[32] = 250;
        TimesItalic.boundingBoxes[32] = new Rectangle(0, 0, 0, 0);
        TimesItalic.width[163] = 500;
        TimesItalic.boundingBoxes[163] = new Rectangle(10, -6, 507, 676);
        TimesItalic.width[116] = 278;
        TimesItalic.boundingBoxes[116] = new Rectangle(37, -11, 259, 557);
        TimesItalic.width[254] = 500;
        TimesItalic.boundingBoxes[254] = new Rectangle(-75, -205, 544, 888);
        TimesItalic.width[51] = 500;
        TimesItalic.boundingBoxes[51] = new Rectangle(15, -7, 450, 683);
        TimesItalic.width[190] = 750;
        TimesItalic.boundingBoxes[190] = new Rectangle(23, -10, 713, 686);
        TimesItalic.width[179] = 300;
        TimesItalic.boundingBoxes[179] = new Rectangle(43, 268, 296, 408);
        TimesItalic.width[152] = 333;
        TimesItalic.boundingBoxes[152] = new Rectangle(100, 517, 327, 107);
        TimesItalic.width[153] = 980;
        TimesItalic.boundingBoxes[153] = new Rectangle(30, 247, 927, 406);
        TimesItalic.width[50] = 500;
        TimesItalic.boundingBoxes[50] = new Rectangle(12, 0, 440, 676);
        TimesItalic.width[178] = 300;
        TimesItalic.boundingBoxes[178] = new Rectangle(33, 271, 291, 405);
        TimesItalic.width[117] = 500;
        TimesItalic.boundingBoxes[117] = new Rectangle(42, -11, 433, 452);
        TimesItalic.width[250] = 500;
        TimesItalic.boundingBoxes[250] = new Rectangle(42, -11, 435, 675);
        TimesItalic.width[251] = 500;
        TimesItalic.boundingBoxes[251] = new Rectangle(42, -11, 433, 672);
        TimesItalic.width[252] = 500;
        TimesItalic.boundingBoxes[252] = new Rectangle(42, -11, 437, 617);
        TimesItalic.width[249] = 500;
        TimesItalic.boundingBoxes[249] = new Rectangle(42, -11, 433, 675);
        TimesItalic.width[95] = 500;
        TimesItalic.boundingBoxes[95] = new Rectangle(0, -125, 500, 50);
        TimesItalic.width[118] = 444;
        TimesItalic.boundingBoxes[118] = new Rectangle(21, -18, 405, 459);
        TimesItalic.width[119] = 667;
        TimesItalic.boundingBoxes[119] = new Rectangle(16, -18, 632, 459);
        TimesItalic.width[120] = 444;
        TimesItalic.boundingBoxes[120] = new Rectangle(-27, -11, 474, 452);
        TimesItalic.width[121] = 444;
        TimesItalic.boundingBoxes[121] = new Rectangle(-24, -206, 450, 647);
        TimesItalic.width[253] = 444;
        TimesItalic.boundingBoxes[253] = new Rectangle(-24, -206, 483, 870);
        TimesItalic.width[255] = 444;
        TimesItalic.boundingBoxes[255] = new Rectangle(-24, -206, 465, 812);
        TimesItalic.width[165] = 500;
        TimesItalic.boundingBoxes[165] = new Rectangle(27, 0, 576, 653);
        TimesItalic.width[122] = 389;
        TimesItalic.boundingBoxes[122] = new Rectangle(-2, -81, 382, 509);
        TimesItalic.width[158] = 389;
        TimesItalic.boundingBoxes[158] = new Rectangle(-2, -81, 436, 742);
        TimesItalic.width[48] = 500;
        TimesItalic.boundingBoxes[48] = new Rectangle(32, -7, 465, 683);
        kerning = new HashMap();
        Integer first = new Integer(79);
        Map<Integer, Integer> pairs = (HashMap<Integer, Integer>)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap<Integer, Integer>();
            kerning.put(first, pairs);
        }
        Integer second = new Integer(65);
        pairs.put(second, new Integer(-55));
        second = new Integer(87);
        pairs.put(second, new Integer(-50));
        second = new Integer(89);
        pairs.put(second, new Integer(-50));
        second = new Integer(84);
        pairs.put(second, new Integer(-40));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(86);
        pairs.put(second, new Integer(-50));
        second = new Integer(88);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(107);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-10));
        second = new Integer(121);
        pairs.put(second, new Integer(-10));
        second = new Integer(101);
        pairs.put(second, new Integer(-10));
        first = new Integer(112);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        first = new Integer(80);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-80));
        second = new Integer(97);
        pairs.put(second, new Integer(-80));
        second = new Integer(65);
        pairs.put(second, new Integer(-90));
        second = new Integer(46);
        pairs.put(second, new Integer(-135));
        second = new Integer(101);
        pairs.put(second, new Integer(-80));
        second = new Integer(44);
        pairs.put(second, new Integer(-135));
        first = new Integer(86);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-111));
        second = new Integer(79);
        pairs.put(second, new Integer(-30));
        second = new Integer(58);
        pairs.put(second, new Integer(-65));
        second = new Integer(71);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-129));
        second = new Integer(59);
        pairs.put(second, new Integer(-74));
        second = new Integer(45);
        pairs.put(second, new Integer(-55));
        second = new Integer(105);
        pairs.put(second, new Integer(-74));
        second = new Integer(65);
        pairs.put(second, new Integer(-60));
        second = new Integer(97);
        pairs.put(second, new Integer(-111));
        second = new Integer(117);
        pairs.put(second, new Integer(-74));
        second = new Integer(46);
        pairs.put(second, new Integer(-129));
        second = new Integer(101);
        pairs.put(second, new Integer(-111));
        first = new Integer(118);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-74));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-74));
        first = new Integer(32);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-18));
        second = new Integer(87);
        pairs.put(second, new Integer(-40));
        second = new Integer(147);
        pairs.put(second, new Integer(0));
        second = new Integer(89);
        pairs.put(second, new Integer(-75));
        second = new Integer(84);
        pairs.put(second, new Integer(-18));
        second = new Integer(145);
        pairs.put(second, new Integer(0));
        second = new Integer(86);
        pairs.put(second, new Integer(-35));
        first = new Integer(97);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(0));
        second = new Integer(116);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(112);
        pairs.put(second, new Integer(0));
        second = new Integer(103);
        pairs.put(second, new Integer(-10));
        second = new Integer(98);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(0));
        first = new Integer(70);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-105));
        second = new Integer(105);
        pairs.put(second, new Integer(-45));
        second = new Integer(114);
        pairs.put(second, new Integer(-55));
        second = new Integer(97);
        pairs.put(second, new Integer(-75));
        second = new Integer(65);
        pairs.put(second, new Integer(-115));
        second = new Integer(46);
        pairs.put(second, new Integer(-135));
        second = new Integer(101);
        pairs.put(second, new Integer(-75));
        second = new Integer(44);
        pairs.put(second, new Integer(-135));
        first = new Integer(85);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-40));
        second = new Integer(46);
        pairs.put(second, new Integer(-25));
        second = new Integer(44);
        pairs.put(second, new Integer(-25));
        first = new Integer(100);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(100);
        pairs.put(second, new Integer(0));
        second = new Integer(119);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(83);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(122);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        first = new Integer(68);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-35));
        second = new Integer(87);
        pairs.put(second, new Integer(-40));
        second = new Integer(89);
        pairs.put(second, new Integer(-40));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(86);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(146);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(0));
        second = new Integer(100);
        pairs.put(second, new Integer(-25));
        second = new Integer(32);
        pairs.put(second, new Integer(-111));
        second = new Integer(146);
        pairs.put(second, new Integer(-111));
        second = new Integer(114);
        pairs.put(second, new Integer(-25));
        second = new Integer(116);
        pairs.put(second, new Integer(-30));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(115);
        pairs.put(second, new Integer(-40));
        second = new Integer(118);
        pairs.put(second, new Integer(-10));
        first = new Integer(58);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(0));
        first = new Integer(119);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(0));
        second = new Integer(104);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-74));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-74));
        first = new Integer(75);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-40));
        second = new Integer(79);
        pairs.put(second, new Integer(-50));
        second = new Integer(117);
        pairs.put(second, new Integer(-40));
        second = new Integer(121);
        pairs.put(second, new Integer(-40));
        second = new Integer(101);
        pairs.put(second, new Integer(-35));
        first = new Integer(82);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(79);
        pairs.put(second, new Integer(-40));
        second = new Integer(87);
        pairs.put(second, new Integer(-18));
        second = new Integer(85);
        pairs.put(second, new Integer(-40));
        second = new Integer(89);
        pairs.put(second, new Integer(-18));
        second = new Integer(84);
        pairs.put(second, new Integer(0));
        second = new Integer(86);
        pairs.put(second, new Integer(-18));
        first = new Integer(145);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(0));
        second = new Integer(145);
        pairs.put(second, new Integer(-111));
        first = new Integer(103);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(105);
        pairs.put(second, new Integer(0));
        second = new Integer(114);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-15));
        second = new Integer(103);
        pairs.put(second, new Integer(-10));
        second = new Integer(101);
        pairs.put(second, new Integer(-10));
        second = new Integer(44);
        pairs.put(second, new Integer(-10));
        first = new Integer(66);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-25));
        second = new Integer(85);
        pairs.put(second, new Integer(-10));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(98);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(-20));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-40));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(98);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(81);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(85);
        pairs.put(second, new Integer(-10));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(44);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-140));
        second = new Integer(32);
        pairs.put(second, new Integer(0));
        second = new Integer(146);
        pairs.put(second, new Integer(-140));
        first = new Integer(102);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(0));
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(105);
        pairs.put(second, new Integer(-20));
        second = new Integer(146);
        pairs.put(second, new Integer(92));
        second = new Integer(97);
        pairs.put(second, new Integer(0));
        second = new Integer(102);
        pairs.put(second, new Integer(-18));
        second = new Integer(46);
        pairs.put(second, new Integer(-15));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-10));
        first = new Integer(84);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-92));
        second = new Integer(79);
        pairs.put(second, new Integer(-18));
        second = new Integer(119);
        pairs.put(second, new Integer(-74));
        second = new Integer(58);
        pairs.put(second, new Integer(-55));
        second = new Integer(114);
        pairs.put(second, new Integer(-55));
        second = new Integer(104);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-74));
        second = new Integer(59);
        pairs.put(second, new Integer(-65));
        second = new Integer(45);
        pairs.put(second, new Integer(-74));
        second = new Integer(105);
        pairs.put(second, new Integer(-55));
        second = new Integer(65);
        pairs.put(second, new Integer(-50));
        second = new Integer(97);
        pairs.put(second, new Integer(-92));
        second = new Integer(117);
        pairs.put(second, new Integer(-55));
        second = new Integer(121);
        pairs.put(second, new Integer(-74));
        second = new Integer(46);
        pairs.put(second, new Integer(-74));
        second = new Integer(101);
        pairs.put(second, new Integer(-92));
        first = new Integer(121);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-55));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-55));
        first = new Integer(120);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        first = new Integer(101);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-30));
        second = new Integer(112);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-15));
        second = new Integer(103);
        pairs.put(second, new Integer(-40));
        second = new Integer(98);
        pairs.put(second, new Integer(0));
        second = new Integer(120);
        pairs.put(second, new Integer(-20));
        second = new Integer(118);
        pairs.put(second, new Integer(-15));
        second = new Integer(44);
        pairs.put(second, new Integer(-10));
        first = new Integer(99);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(107);
        pairs.put(second, new Integer(-20));
        second = new Integer(104);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(87);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-92));
        second = new Integer(79);
        pairs.put(second, new Integer(-25));
        second = new Integer(58);
        pairs.put(second, new Integer(-65));
        second = new Integer(104);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-92));
        second = new Integer(59);
        pairs.put(second, new Integer(-65));
        second = new Integer(45);
        pairs.put(second, new Integer(-37));
        second = new Integer(105);
        pairs.put(second, new Integer(-55));
        second = new Integer(65);
        pairs.put(second, new Integer(-60));
        second = new Integer(97);
        pairs.put(second, new Integer(-92));
        second = new Integer(117);
        pairs.put(second, new Integer(-55));
        second = new Integer(121);
        pairs.put(second, new Integer(-70));
        second = new Integer(46);
        pairs.put(second, new Integer(-92));
        second = new Integer(101);
        pairs.put(second, new Integer(-92));
        first = new Integer(104);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        first = new Integer(71);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(105);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(118);
        pairs.put(second, new Integer(0));
        first = new Integer(65);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(79);
        pairs.put(second, new Integer(-40));
        second = new Integer(146);
        pairs.put(second, new Integer(-37));
        second = new Integer(119);
        pairs.put(second, new Integer(-55));
        second = new Integer(87);
        pairs.put(second, new Integer(-95));
        second = new Integer(67);
        pairs.put(second, new Integer(-30));
        second = new Integer(112);
        pairs.put(second, new Integer(0));
        second = new Integer(81);
        pairs.put(second, new Integer(-40));
        second = new Integer(71);
        pairs.put(second, new Integer(-35));
        second = new Integer(86);
        pairs.put(second, new Integer(-105));
        second = new Integer(118);
        pairs.put(second, new Integer(-55));
        second = new Integer(148);
        pairs.put(second, new Integer(0));
        second = new Integer(85);
        pairs.put(second, new Integer(-50));
        second = new Integer(117);
        pairs.put(second, new Integer(-20));
        second = new Integer(89);
        pairs.put(second, new Integer(-55));
        second = new Integer(121);
        pairs.put(second, new Integer(-55));
        second = new Integer(84);
        pairs.put(second, new Integer(-37));
        first = new Integer(147);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(0));
        second = new Integer(145);
        pairs.put(second, new Integer(0));
        first = new Integer(78);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-27));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(115);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(0));
        first = new Integer(111);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(103);
        pairs.put(second, new Integer(-10));
        second = new Integer(120);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(-10));
        first = new Integer(114);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-45));
        second = new Integer(100);
        pairs.put(second, new Integer(-37));
        second = new Integer(107);
        pairs.put(second, new Integer(0));
        second = new Integer(114);
        pairs.put(second, new Integer(0));
        second = new Integer(99);
        pairs.put(second, new Integer(-37));
        second = new Integer(112);
        pairs.put(second, new Integer(0));
        second = new Integer(103);
        pairs.put(second, new Integer(-37));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(113);
        pairs.put(second, new Integer(-37));
        second = new Integer(118);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-111));
        second = new Integer(45);
        pairs.put(second, new Integer(-20));
        second = new Integer(105);
        pairs.put(second, new Integer(0));
        second = new Integer(109);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(-15));
        second = new Integer(117);
        pairs.put(second, new Integer(0));
        second = new Integer(116);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-111));
        second = new Integer(110);
        pairs.put(second, new Integer(0));
        second = new Integer(115);
        pairs.put(second, new Integer(-10));
        second = new Integer(101);
        pairs.put(second, new Integer(-37));
        first = new Integer(108);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        first = new Integer(76);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(0));
        second = new Integer(146);
        pairs.put(second, new Integer(-37));
        second = new Integer(87);
        pairs.put(second, new Integer(-55));
        second = new Integer(89);
        pairs.put(second, new Integer(-20));
        second = new Integer(121);
        pairs.put(second, new Integer(-30));
        second = new Integer(84);
        pairs.put(second, new Integer(-20));
        second = new Integer(86);
        pairs.put(second, new Integer(-55));
        first = new Integer(148);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(0));
        first = new Integer(109);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        first = new Integer(89);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-92));
        second = new Integer(45);
        pairs.put(second, new Integer(-74));
        second = new Integer(105);
        pairs.put(second, new Integer(-74));
        second = new Integer(79);
        pairs.put(second, new Integer(-15));
        second = new Integer(58);
        pairs.put(second, new Integer(-65));
        second = new Integer(97);
        pairs.put(second, new Integer(-92));
        second = new Integer(65);
        pairs.put(second, new Integer(-50));
        second = new Integer(117);
        pairs.put(second, new Integer(-92));
        second = new Integer(46);
        pairs.put(second, new Integer(-92));
        second = new Integer(101);
        pairs.put(second, new Integer(-92));
        second = new Integer(59);
        pairs.put(second, new Integer(-65));
        second = new Integer(44);
        pairs.put(second, new Integer(-92));
        first = new Integer(74);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-25));
        second = new Integer(97);
        pairs.put(second, new Integer(-35));
        second = new Integer(65);
        pairs.put(second, new Integer(-40));
        second = new Integer(117);
        pairs.put(second, new Integer(-35));
        second = new Integer(46);
        pairs.put(second, new Integer(-25));
        second = new Integer(101);
        pairs.put(second, new Integer(-25));
        second = new Integer(44);
        pairs.put(second, new Integer(-25));
        first = new Integer(46);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-140));
        second = new Integer(146);
        pairs.put(second, new Integer(-140));
        first = new Integer(110);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(-40));
        familyNames = new HashSet();
        familyNames.add("Times");
    }
}

