/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.tools.BinaryUtils;

public class IncludePageOverlay
extends AbstractNamedAFPObject {
    private int x = 0;
    private int y = 0;
    private int orientation = 0;

    public IncludePageOverlay(String overlayName, int x, int y, int orientation) {
        super(overlayName);
        this.x = x;
        this.y = y;
        this.setOrientation(orientation);
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 90 && orientation != 180 && orientation != 270) {
            throw new IllegalArgumentException("The orientation must be one of the values 0, 90, 180, 270");
        }
        this.orientation = orientation;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        byte[] data = new byte[25];
        data[0] = 90;
        byte[] len = BinaryUtils.convert(24, 2);
        data[1] = len[0];
        data[2] = len[1];
        data[3] = -45;
        data[4] = -81;
        data[5] = -40;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this.nameBytes.length; ++i) {
            data[9 + i] = this.nameBytes[i];
        }
        byte[] xcoord = BinaryUtils.convert(this.x, 3);
        data[17] = xcoord[0];
        data[18] = xcoord[1];
        data[19] = xcoord[2];
        byte[] ycoord = BinaryUtils.convert(this.y, 3);
        data[20] = ycoord[0];
        data[21] = ycoord[1];
        data[22] = ycoord[2];
        switch (this.orientation) {
            case 90: {
                data[23] = 45;
                data[24] = 0;
                break;
            }
            case 180: {
                data[23] = 90;
                data[24] = 0;
                break;
            }
            case 270: {
                data[23] = -121;
                data[24] = 0;
                break;
            }
            default: {
                data[23] = 0;
                data[24] = 0;
            }
        }
        os.write(data);
    }
}

