/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.CTM;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Character;
import org.apache.fop.area.inline.Container;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fo.Constants;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.ImageAdapter;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.render.XMLHandlerConfigurator;
import org.w3c.dom.Document;

public abstract class AbstractRenderer
implements Renderer,
Constants {
    protected static Log log = LogFactory.getLog((String)"org.apache.fop.render");
    protected FOUserAgent userAgent = null;
    protected int currentBPPosition = 0;
    protected int currentIPPosition = 0;
    protected int containingBPPosition = 0;
    protected int containingIPPosition = 0;
    protected PageViewport currentPageViewport;
    private Set warnedXMLHandlers;

    public abstract void setupFontInfo(FontInfo var1);

    public void setUserAgent(FOUserAgent agent) {
        this.userAgent = agent;
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
    }

    public void stopRenderer() throws IOException {
    }

    public boolean supportsOutOfOrder() {
        return false;
    }

    public void processOffDocumentItem(OffDocumentItem odi) {
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return null;
    }

    public ImageAdapter getImageAdapter() {
        return null;
    }

    protected PageViewport getCurrentPageViewport() {
        return this.currentPageViewport;
    }

    public void preparePage(PageViewport page) {
    }

    protected String convertTitleToString(LineArea title) {
        List children = title.getInlineAreas();
        String str = this.convertToString(children);
        return str.trim();
    }

    private String convertToString(List children) {
        StringBuffer sb = new StringBuffer();
        for (int count = 0; count < children.size(); ++count) {
            InlineArea inline = (InlineArea)children.get(count);
            if (inline instanceof TextArea) {
                sb.append(((TextArea)inline).getText());
                continue;
            }
            if (inline instanceof InlineParent) {
                sb.append(this.convertToString(((InlineParent)inline).getChildAreas()));
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public void startPageSequence(LineArea seqTitle) {
    }

    public void startPageSequence(PageSequence pageSequence) {
        this.startPageSequence(pageSequence.getTitle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPage(PageViewport page) throws IOException, FOPException {
        this.currentPageViewport = page;
        try {
            Page p = page.getPage();
            this.renderPageAreas(p);
        }
        finally {
            this.currentPageViewport = null;
        }
    }

    protected void renderPageAreas(Page page) {
        RegionViewport viewport = page.getRegionViewport(35);
        this.renderRegionViewport(viewport);
        viewport = page.getRegionViewport(38);
        this.renderRegionViewport(viewport);
        viewport = page.getRegionViewport(37);
        this.renderRegionViewport(viewport);
        viewport = page.getRegionViewport(34);
        this.renderRegionViewport(viewport);
        viewport = page.getRegionViewport(36);
        this.renderRegionViewport(viewport);
    }

    protected void renderRegionViewport(RegionViewport port) {
        if (port != null) {
            Rectangle2D view = port.getViewArea();
            this.currentBPPosition = 0;
            this.currentIPPosition = 0;
            RegionReference regionReference = port.getRegionReference();
            this.handleRegionTraits(port);
            this.startVParea(regionReference.getCTM(), port.isClip() ? view : null);
            if (regionReference.getRegionClass() == 36) {
                this.renderBodyRegion((BodyRegion)regionReference);
            } else {
                this.renderRegion(regionReference);
            }
            this.endVParea();
        }
    }

    protected abstract void startVParea(CTM var1, Rectangle2D var2);

    protected abstract void endVParea();

    protected void handleRegionTraits(RegionViewport rv) {
    }

    protected void renderRegion(RegionReference region) {
        List blocks = region.getBlocks();
        this.renderBlocks(null, blocks);
    }

    protected void renderBodyRegion(BodyRegion region) {
        Footnote foot;
        MainReference mr;
        BeforeFloat bf = region.getBeforeFloat();
        if (bf != null) {
            this.renderBeforeFloat(bf);
        }
        if ((mr = region.getMainReference()) != null) {
            this.renderMainReference(mr);
        }
        if ((foot = region.getFootnote()) != null) {
            this.renderFootnote(foot);
        }
    }

    protected void renderBeforeFloat(BeforeFloat bf) {
        List blocks = bf.getChildAreas();
        if (blocks != null) {
            this.renderBlocks(null, blocks);
            Block sep = bf.getSeparator();
            if (sep != null) {
                this.renderBlock(sep);
            }
        }
    }

    protected void renderFootnote(Footnote footnote) {
        this.currentBPPosition += footnote.getTop();
        List blocks = footnote.getChildAreas();
        if (blocks != null) {
            Block sep = footnote.getSeparator();
            if (sep != null) {
                this.renderBlock(sep);
            }
            this.renderBlocks(null, blocks);
        }
    }

    protected void renderMainReference(MainReference mr) {
        int saveBPPos;
        int saveIPPos = this.currentIPPosition;
        Span span = null;
        List spans = mr.getSpans();
        int saveSpanBPPos = saveBPPos = this.currentBPPosition;
        for (int count = 0; count < spans.size(); ++count) {
            span = (Span)spans.get(count);
            for (int c = 0; c < span.getColumnCount(); ++c) {
                NormalFlow flow = span.getNormalFlow(c);
                if (flow == null) continue;
                this.currentBPPosition = saveSpanBPPos;
                this.renderFlow(flow);
                this.currentIPPosition += flow.getIPD();
                this.currentIPPosition += mr.getColumnGap();
            }
            this.currentIPPosition = saveIPPos;
            saveSpanBPPos = this.currentBPPosition = saveSpanBPPos + span.getHeight();
        }
        this.currentBPPosition = saveBPPos;
    }

    protected void renderFlow(NormalFlow flow) {
        List blocks = flow.getChildAreas();
        if (blocks != null) {
            this.renderBlocks(null, blocks);
        }
    }

    protected void handleBlockTraits(Block block) {
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        if (bv.getPositioning() == 2) {
            int saveIP = this.currentIPPosition;
            int saveBP = this.currentBPPosition;
            Rectangle clippingRect = null;
            if (bv.getClip()) {
                clippingRect = new Rectangle(saveIP, saveBP, bv.getIPD(), bv.getBPD());
            }
            CTM ctm = bv.getCTM();
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.startVParea(ctm, clippingRect);
            this.handleBlockTraits(bv);
            this.renderBlocks(bv, children);
            this.endVParea();
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
        } else {
            int saveIP = this.currentIPPosition;
            int saveBP = this.currentBPPosition;
            this.handleBlockTraits(bv);
            this.renderBlocks(bv, children);
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP + bv.getAllocBPD();
        }
    }

    protected void renderBlocks(Block parent, List blocks) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        if (parent != null && !Boolean.TRUE.equals(parent.getTrait(Trait.IS_VIEWPORT_AREA))) {
            this.currentBPPosition += parent.getBorderAndPaddingWidthBefore();
        }
        int contBP = this.currentBPPosition;
        int contIP = this.currentIPPosition;
        this.containingBPPosition = this.currentBPPosition;
        this.containingIPPosition = this.currentIPPosition;
        for (int count = 0; count < blocks.size(); ++count) {
            Object obj = blocks.get(count);
            if (obj instanceof Block) {
                this.currentIPPosition = contIP;
                this.containingBPPosition = contBP;
                this.containingIPPosition = contIP;
                this.renderBlock((Block)obj);
                this.containingBPPosition = contBP;
                this.containingIPPosition = contIP;
            } else {
                LineArea line = (LineArea)obj;
                this.currentIPPosition = contIP + parent.getStartIndent() + line.getStartIndent();
                this.renderLineArea(line);
                this.currentBPPosition += line.getAllocBPD();
            }
            this.currentIPPosition = saveIP;
        }
    }

    protected void renderBlock(Block block) {
        List children = block.getChildAreas();
        if (block instanceof BlockViewport) {
            if (children != null) {
                this.renderBlockViewport((BlockViewport)block, children);
            } else {
                this.handleBlockTraits(block);
                this.currentBPPosition += block.getAllocBPD();
            }
        } else {
            int saveIP = this.currentIPPosition;
            int saveBP = this.currentBPPosition;
            this.currentIPPosition += block.getXOffset();
            this.currentBPPosition += block.getYOffset();
            this.currentBPPosition += block.getSpaceBefore();
            this.handleBlockTraits(block);
            if (children != null) {
                this.renderBlocks(block, children);
            }
            if (block.getPositioning() == 2) {
                this.currentBPPosition = saveBP;
            } else {
                this.currentIPPosition = saveIP;
                this.currentBPPosition = saveBP + block.getAllocBPD();
            }
        }
    }

    protected void renderLineArea(LineArea line) {
        List children = line.getInlineAreas();
        int saveBP = this.currentBPPosition;
        this.currentBPPosition += line.getSpaceBefore();
        for (int count = 0; count < children.size(); ++count) {
            InlineArea inline = (InlineArea)children.get(count);
            this.renderInlineArea(inline);
        }
        this.currentBPPosition = saveBP;
    }

    protected void renderInlineArea(InlineArea inlineArea) {
        if (inlineArea instanceof TextArea) {
            this.renderText((TextArea)inlineArea);
        } else if (inlineArea instanceof WordArea) {
            this.renderWord((WordArea)inlineArea);
        } else if (inlineArea instanceof SpaceArea) {
            this.renderSpace((SpaceArea)inlineArea);
        } else if (inlineArea instanceof InlineParent) {
            this.renderInlineParent((InlineParent)inlineArea);
        } else if (inlineArea instanceof InlineBlockParent) {
            this.renderInlineBlockParent((InlineBlockParent)inlineArea);
        } else if (inlineArea instanceof Space) {
            this.renderInlineSpace((Space)inlineArea);
        } else if (inlineArea instanceof Viewport) {
            this.renderViewport((Viewport)inlineArea);
        } else if (inlineArea instanceof Leader) {
            this.renderLeader((Leader)inlineArea);
        }
    }

    protected void renderCharacter(Character ch) {
        this.currentIPPosition += ch.getAllocIPD();
    }

    protected abstract void renderInlineAreaBackAndBorders(InlineArea var1);

    protected void renderInlineSpace(Space space) {
        space.setBPD(0);
        this.renderInlineAreaBackAndBorders(space);
        this.currentIPPosition += space.getAllocIPD();
    }

    protected void renderLeader(Leader area) {
        this.currentIPPosition += area.getAllocIPD();
    }

    protected void renderText(TextArea text) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        Iterator iter = text.getChildAreas().iterator();
        while (iter.hasNext()) {
            this.renderInlineArea((InlineArea)iter.next());
        }
        this.currentIPPosition = saveIP + text.getAllocIPD();
    }

    protected void renderWord(WordArea word) {
        this.currentIPPosition += word.getAllocIPD();
    }

    protected void renderSpace(SpaceArea space) {
        this.currentIPPosition += space.getAllocIPD();
    }

    protected void renderInlineParent(InlineParent ip) {
        this.renderInlineAreaBackAndBorders(ip);
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        this.currentIPPosition += ip.getBorderAndPaddingWidthStart();
        this.currentBPPosition += ip.getOffset();
        Iterator iter = ip.getChildAreas().iterator();
        while (iter.hasNext()) {
            this.renderInlineArea((InlineArea)iter.next());
        }
        this.currentIPPosition = saveIP + ip.getAllocIPD();
        this.currentBPPosition = saveBP;
    }

    protected void renderInlineBlockParent(InlineBlockParent ibp) {
        this.renderInlineAreaBackAndBorders(ibp);
        this.currentIPPosition += ibp.getBorderAndPaddingWidthStart();
        int saveBP = this.currentBPPosition;
        this.currentBPPosition += ibp.getOffset();
        this.renderBlock(ibp.getChildArea());
        this.currentBPPosition = saveBP;
    }

    protected void renderViewport(Viewport viewport) {
        Area content = viewport.getContent();
        int saveBP = this.currentBPPosition;
        this.currentBPPosition += viewport.getOffset();
        Rectangle2D contpos = viewport.getContentPosition();
        if (content instanceof Image) {
            this.renderImage((Image)content, contpos);
        } else if (content instanceof Container) {
            this.renderContainer((Container)content);
        } else if (content instanceof ForeignObject) {
            this.renderForeignObject((ForeignObject)content, contpos);
        }
        this.currentIPPosition += viewport.getAllocIPD();
        this.currentBPPosition = saveBP;
    }

    public void renderImage(Image image, Rectangle2D pos) {
    }

    protected void renderContainer(Container cont) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        List blocks = cont.getBlocks();
        this.renderBlocks(null, blocks);
        this.currentIPPosition = saveIP;
        this.currentBPPosition = saveBP;
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
    }

    public void renderXML(RendererContext ctx, Document doc, String namespace) {
        XMLHandler handler = this.userAgent.getXMLHandlerRegistry().getXMLHandler((Renderer)this, namespace);
        if (handler != null) {
            try {
                XMLHandlerConfigurator configurator = new XMLHandlerConfigurator(this.userAgent);
                configurator.configure(ctx, namespace);
                handler.handleXML(ctx, doc, namespace);
            }
            catch (Throwable t) {
                log.error((Object)"Some XML content will be ignored. Could not render XML", t);
            }
        } else {
            if (this.warnedXMLHandlers == null) {
                this.warnedXMLHandlers = new HashSet();
            }
            if (!this.warnedXMLHandlers.contains(namespace)) {
                this.warnedXMLHandlers.add(namespace);
                log.warn((Object)("Some XML content will be ignored. No handler defined for XML: " + namespace));
            }
        }
    }

    public String getMimeType() {
        return null;
    }

    protected AffineTransform mptToPt(AffineTransform at) {
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        matrix[4] = matrix[4] / 1000.0;
        matrix[5] = matrix[5] / 1000.0;
        return new AffineTransform(matrix);
    }

    protected AffineTransform ptToMpt(AffineTransform at) {
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        matrix[4] = matrix[4] * 1000.0;
        matrix[5] = matrix[5] * 1000.0;
        return new AffineTransform(matrix);
    }
}

