/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.awt.Color;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.NullCharIterator;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.SpaceProperty;
import org.xml.sax.Locator;

public class Block
extends FObjMixed {
    private boolean blockOrInlineItemFound = false;
    private boolean initialPropertySetFound = false;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonFont commonFont;
    private CommonHyphenation commonHyphenation;
    private CommonMarginBlock commonMarginBlock;
    private CommonRelativePosition commonRelativePosition;
    private int breakAfter;
    private int breakBefore;
    private Color color;
    private int hyphenationKeep;
    private Numeric hyphenationLadderCount;
    private int intrusionDisplace;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private Length lastLineEndIndent;
    private int linefeedTreatment;
    private SpaceProperty lineHeight;
    private int lineHeightShiftAdjustment;
    private int lineStackingStrategy;
    private Numeric orphans;
    private int whiteSpaceTreatment;
    private int span;
    private int textAlign;
    private int textAlignLast;
    private Length textIndent;
    private int whiteSpaceCollapse;
    private Numeric widows;
    private int wrapOption;

    public Block(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonFont = pList.getFontProps();
        this.commonHyphenation = pList.getHyphenationProps();
        this.commonMarginBlock = pList.getMarginBlockProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.breakAfter = pList.get(58).getEnum();
        this.breakBefore = pList.get(59).getEnum();
        this.color = pList.get(66).getColor(this.getUserAgent());
        this.hyphenationKeep = pList.get(109).getEnum();
        this.hyphenationLadderCount = pList.get(110).getNumeric();
        this.intrusionDisplace = pList.get(248).getEnum();
        this.keepTogether = pList.get(118).getKeep();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.lastLineEndIndent = pList.get(122).getLength();
        this.linefeedTreatment = pList.get(130).getEnum();
        this.lineHeight = pList.get(131).getSpace();
        this.lineHeightShiftAdjustment = pList.get(132).getEnum();
        this.lineStackingStrategy = pList.get(133).getEnum();
        this.orphans = pList.get(152).getNumeric();
        this.whiteSpaceTreatment = pList.get(240).getEnum();
        this.span = pList.get(204).getEnum();
        this.textAlign = pList.get(223).getEnum();
        this.textAlignLast = pList.get(224).getEnum();
        this.textIndent = pList.get(228).getLength();
        this.whiteSpaceCollapse = pList.get(239).getEnum();
        this.widows = pList.get(241).getNumeric();
        this.wrapOption = pList.get(244).getEnum();
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startBlock(this);
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().endBlock(this);
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public CommonFont getCommonFont() {
        return this.commonFont;
    }

    public CommonHyphenation getCommonHyphenation() {
        return this.commonHyphenation;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public Numeric getHyphenationLadderCount() {
        return this.hyphenationLadderCount;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public int getOrphans() {
        return this.orphans.getValue();
    }

    public int getWidows() {
        return this.widows.getValue();
    }

    public int getLineStackingStrategy() {
        return this.lineStackingStrategy;
    }

    public Color getColor() {
        return this.color;
    }

    public SpaceProperty getLineHeight() {
        return this.lineHeight;
    }

    public int getSpan() {
        return this.span;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public int getTextAlignLast() {
        return this.textAlignLast;
    }

    public Length getTextIndent() {
        return this.textIndent;
    }

    public Length getLastLineEndIndent() {
        return this.lastLineEndIndent;
    }

    public int getWrapOption() {
        return this.wrapOption;
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI)) {
            if (localName.equals("marker")) {
                if (this.blockOrInlineItemFound || this.initialPropertySetFound) {
                    this.nodesOutOfOrderError(loc, "fo:marker", "initial-property-set? (#PCDATA|%inline;|%block;)");
                }
            } else if (localName.equals("initial-property-set")) {
                if (this.initialPropertySetFound) {
                    this.tooManyNodesError(loc, "fo:initial-property-set");
                } else if (this.blockOrInlineItemFound) {
                    this.nodesOutOfOrderError(loc, "fo:initial-property-set", "(#PCDATA|%inline;|%block;)");
                } else {
                    this.initialPropertySetFound = true;
                }
            } else if (this.isBlockOrInlineItem(nsURI, localName)) {
                this.blockOrInlineItemFound = true;
            } else {
                this.invalidChildError(loc, nsURI, localName);
            }
        }
    }

    public int getLinefeedTreatment() {
        return this.linefeedTreatment;
    }

    public int getWhitespaceTreatment() {
        return this.whiteSpaceTreatment;
    }

    public int getWhitespaceCollapse() {
        return this.whiteSpaceCollapse;
    }

    public CommonRelativePosition getCommonRelativePosition() {
        return this.commonRelativePosition;
    }

    public int getHyphenationKeep() {
        return this.hyphenationKeep;
    }

    public int getIntrusionDisplace() {
        return this.intrusionDisplace;
    }

    public int getLineHeightShiftAdjustment() {
        return this.lineHeightShiftAdjustment;
    }

    public CharIterator charIterator() {
        return NullCharIterator.getInstance();
    }

    public String getLocalName() {
        return "block";
    }

    public int getNameId() {
        return 3;
    }
}

