/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFStream;

public class PDFTTFStream
extends PDFStream {
    private int origLength;

    public PDFTTFStream(int len) {
        this.origLength = len;
    }

    protected int output(OutputStream stream) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Writing " + this.origLength + " bytes of TTF font data"));
        }
        int length = super.output(stream);
        log.debug((Object)"Embedded TrueType/OpenType font");
        return length;
    }

    protected void populateStreamDict(Object lengthEntry) {
        this.put("Length1", this.origLength);
        super.populateStreamDict(lengthEntry);
    }

    public void setData(byte[] data, int size) throws IOException {
        this.data.clear();
        this.data.getOutputStream().write(data, 0, size);
    }
}

