/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mozilla.javascript.ClassShutter;

public class RhinoClassShutter
implements ClassShutter {
    public static final List<String> WHITELIST = new ArrayList<String>();

    public boolean visibleToScripts(String fullClassName) {
        if (!(WHITELIST.contains(fullClassName) || fullClassName.endsWith("Permission") || fullClassName.startsWith("org."))) {
            return false;
        }
        if (fullClassName.startsWith("org.mozilla.javascript")) {
            return false;
        }
        if (fullClassName.startsWith("org.apache.batik.")) {
            String batikPkg = fullClassName.substring(17);
            if (batikPkg.startsWith("script")) {
                return false;
            }
            if (batikPkg.startsWith("apps")) {
                return false;
            }
            if (batikPkg.startsWith("bridge.")) {
                String batikBridgeClass = batikPkg.substring(7);
                if (batikBridgeClass.startsWith("ScriptingEnvironment")) {
                    String c;
                    return batikBridgeClass.startsWith("$Window$", 20) && ((c = batikBridgeClass.substring(28)).equals("IntervalScriptTimerTask") || c.equals("IntervalRunnableTimerTask") || c.equals("TimeoutScriptTimerTask") || c.equals("TimeoutRunnableTimerTask"));
                }
                if (batikBridgeClass.startsWith("BaseScriptingEnvironment")) {
                    return false;
                }
            }
        }
        return true;
    }

    static {
        WHITELIST.addAll(Arrays.asList("java.io.PrintStream", "java.lang.System", "java.net.URL"));
    }
}

