/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.terminal.telnet;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.xbean.terminal.telnet.TelnetCodes;
import org.apache.xbean.terminal.telnet.TelnetOption;

public class TelnetInputStream
extends FilterInputStream
implements TelnetCodes {
    private TelnetOption[] options = new TelnetOption[256];
    private OutputStream out = null;

    public TelnetInputStream(InputStream in, OutputStream out) throws IOException {
        super(in);
        this.out = out;
        this.negotiateOption(254, 1);
        this.negotiateOption(254, 6);
        this.negotiateOption(254, 24);
        this.negotiateOption(254, 33);
        this.negotiateOption(254, 34);
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b == 255) {
            this.processCommand();
            b = this.read();
        }
        return b;
    }

    private void processCommand() throws IOException {
        this.print("C: IAC ");
        int command = super.read();
        switch (command) {
            case 251: {
                this.senderWillEnableOption(super.read());
                break;
            }
            case 253: {
                this.pleaseDoEnableOption(super.read());
                break;
            }
            case 252: {
                this.senderWontEnableOption(super.read());
                break;
            }
            case 254: {
                this.pleaseDontEnableOption(super.read());
                break;
            }
            default: {
                this.unimplementedCommand(command);
            }
        }
    }

    private void unimplementedCommand(int command) {
        this.println(command + ": command not found");
    }

    private void senderWillEnableOption(int optionID) throws IOException {
        this.println("WILL " + optionID);
        TelnetOption option = this.getOption(optionID);
        if (option.hasBeenNegotiated()) {
            return;
        }
        if (option.isInNegotiation()) {
            option.enable();
        } else if (!option.isInNegotiation() && option.isSupported()) {
            this.negotiateOption(253, optionID);
            option.enable();
        } else if (!option.isInNegotiation() && !option.isSupported()) {
            this.negotiateOption(254, optionID);
            option.disable();
        }
    }

    private void pleaseDoEnableOption(int optionID) throws IOException {
        this.println("DO " + optionID);
        TelnetOption option = this.getOption(optionID);
        if (option.hasBeenNegotiated()) {
            return;
        }
        if (option.isInNegotiation()) {
            option.enable();
        } else if (!option.isInNegotiation() && option.isSupported()) {
            this.negotiateOption(251, optionID);
            option.enable();
        } else if (!option.isInNegotiation() && !option.isSupported()) {
            this.negotiateOption(252, optionID);
            option.disable();
        }
    }

    private void senderWontEnableOption(int optionID) throws IOException {
        this.println("WONT " + optionID);
        TelnetOption option = this.getOption(optionID);
        if (option.hasBeenNegotiated()) {
            return;
        }
        if (!option.isInNegotiation()) {
            this.negotiateOption(254, optionID);
        }
        option.disable();
    }

    private void pleaseDontEnableOption(int optionID) throws IOException {
        this.println("DONT " + optionID);
        TelnetOption option = this.getOption(optionID);
        if (option.hasBeenNegotiated()) {
            return;
        }
        if (!option.isInNegotiation()) {
            this.negotiateOption(252, optionID);
        }
        option.disable();
    }

    private void println(String s) {
    }

    private void print(String s) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void negotiateOption(int negotiate, int optionID) throws IOException {
        TelnetOption option = this.getOption(optionID);
        option.isInNegotiation(true);
        String n = null;
        switch (negotiate) {
            case 251: {
                n = "WILL ";
                break;
            }
            case 253: {
                n = "DO ";
                break;
            }
            case 252: {
                n = "WONT ";
                break;
            }
            case 254: {
                n = "DONT ";
            }
        }
        this.println("S: IAC " + n + optionID);
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.out.write(255);
            this.out.write(negotiate);
            this.out.write(optionID);
        }
    }

    private TelnetOption getOption(int optionID) {
        TelnetOption opt = this.options[optionID];
        if (opt == null) {
            this.options[optionID] = opt = new TelnetOption(optionID);
        }
        return opt;
    }
}

