/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.v2c;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.xbean.spring.context.impl.PropertyEditorHelper;
import org.apache.xbean.spring.context.impl.QNameReflectionHelper;
import org.apache.xbean.spring.context.v2c.XBeanQNameHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XBeanBeanDefinitionParserDelegate
extends BeanDefinitionParserDelegate {
    public static final String QNAME_ELEMENT = "qname";
    private XBeanQNameHelper qnameHelper;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$BeanDefinition;

    public XBeanBeanDefinitionParserDelegate(XmlReaderContext readerContext) {
        super(readerContext);
        this.qnameHelper = new XBeanQNameHelper(readerContext);
    }

    public Object parsePropertySubElement(Element ele, BeanDefinition bd, String defaultTypeClassName) {
        if (!this.isDefaultNamespace(ele.getNamespaceURI())) {
            return this.internalParseNestedCustomElement(ele);
        }
        if (ele.getTagName().equals(QNAME_ELEMENT)) {
            return this.parseQNameElement(ele);
        }
        return super.parsePropertySubElement(ele, bd, defaultTypeClassName);
    }

    public AbstractBeanDefinition parseBeanDefinitionElement(Element ele, String beanName, BeanDefinition containingBean) {
        AbstractBeanDefinition bd = super.parseBeanDefinitionElement(ele, beanName, containingBean);
        this.qnameHelper.coerceNamespaceAwarePropertyValues((BeanDefinition)bd, ele);
        return bd;
    }

    public boolean isDefaultNamespace(String namespaceUri) {
        return !StringUtils.hasLength((String)namespaceUri) || "http://www.springframework.org/schema/beans".equals(namespaceUri) || "http://xbean.apache.org/schemas/spring/1.0".equals(namespaceUri) || "http://xbean.org/schemas/spring/1.0".equals(namespaceUri);
    }

    protected Object parseQNameElement(Element element) {
        return QNameReflectionHelper.createQName(element, this.getElementText(element));
    }

    protected String getElementText(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString();
    }

    private Object internalParseNestedCustomElement(Element candidateEle) {
        try {
            Method mth = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredMethod("parseNestedCustomElement", class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XBeanBeanDefinitionParserDelegate.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element, class$org$springframework$beans$factory$config$BeanDefinition == null ? (class$org$springframework$beans$factory$config$BeanDefinition = XBeanBeanDefinitionParserDelegate.class$("org.springframework.beans.factory.config.BeanDefinition")) : class$org$springframework$beans$factory$config$BeanDefinition);
            ((AccessibleObject)mth).setAccessible(true);
            return mth.invoke((Object)this, candidateEle, null);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalStateException("Unable to invoke parseNestedCustomElement method", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PropertyEditorHelper.registerCustomEditors();
    }
}

