/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.xbean.propertyeditor.PropertyEditors;
import org.apache.xbean.recipe.Recipe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecipeHelper {
    private RecipeHelper() {
    }

    public static boolean hasDefaultConstructor(Class type) {
        if (!Modifier.isPublic(type.getModifiers())) {
            return false;
        }
        Constructor<?>[] constructors = type.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> constructor = constructors[i];
            if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isSimpleType(Object o) {
        return o == null || o instanceof Boolean || o instanceof Character || o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double || o instanceof String || o instanceof Recipe;
    }

    public static <K, V> List<Map.Entry<K, V>> prioritizeProperties(Map<K, V> properties) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(properties.entrySet());
        Collections.sort(entries, new RecipeComparator());
        return entries;
    }

    public static boolean isInstance(Class type, Object instance) {
        if (type.isPrimitive()) {
            if (instance == null) {
                return false;
            }
            if (type.equals(Boolean.TYPE)) {
                return instance instanceof Boolean;
            }
            if (type.equals(Character.TYPE)) {
                return instance instanceof Character;
            }
            if (type.equals(Byte.TYPE)) {
                return instance instanceof Byte;
            }
            if (type.equals(Short.TYPE)) {
                return instance instanceof Short;
            }
            if (type.equals(Integer.TYPE)) {
                return instance instanceof Integer;
            }
            if (type.equals(Long.TYPE)) {
                return instance instanceof Long;
            }
            if (type.equals(Float.TYPE)) {
                return instance instanceof Float;
            }
            if (type.equals(Double.TYPE)) {
                return instance instanceof Double;
            }
            throw new AssertionError((Object)("Invalid primitve type: " + type));
        }
        return instance == null || type.isInstance(instance);
    }

    public static boolean isConvertable(Class type, Object propertyValue, ClassLoader classLoader) {
        if (propertyValue instanceof Recipe) {
            Recipe recipe = (Recipe)propertyValue;
            return recipe.canCreate(type, classLoader);
        }
        return propertyValue instanceof String && PropertyEditors.canConvert(type);
    }

    public static boolean isAssignableFrom(Class expected, Class actual) {
        if (expected.isPrimitive()) {
            if (expected.equals(Boolean.TYPE)) {
                return actual.equals(Boolean.class);
            }
            if (expected.equals(Character.TYPE)) {
                return actual.equals(Character.class);
            }
            if (expected.equals(Byte.TYPE)) {
                return actual.equals(Byte.class);
            }
            if (expected.equals(Short.TYPE)) {
                return actual.equals(Short.class);
            }
            if (expected.equals(Integer.TYPE)) {
                return actual.equals(Integer.class);
            }
            if (expected.equals(Long.TYPE)) {
                return actual.equals(Long.class);
            }
            if (expected.equals(Float.TYPE)) {
                return actual.equals(Float.class);
            }
            if (expected.equals(Double.TYPE)) {
                return actual.equals(Double.class);
            }
            throw new AssertionError((Object)("Invalid primitve type: " + expected));
        }
        return expected.isAssignableFrom(actual);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecipeComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object left, Object right) {
            float rightPriority;
            if (!(left instanceof Recipe) && !(right instanceof Recipe)) {
                return 0;
            }
            if (left instanceof Recipe && !(right instanceof Recipe)) {
                return 1;
            }
            if (!(left instanceof Recipe) && right instanceof Recipe) {
                return -1;
            }
            float leftPriority = ((Recipe)left).getPriority();
            if (leftPriority > (rightPriority = ((Recipe)right).getPriority())) {
                return 1;
            }
            if (leftPriority < rightPriority) {
                return -1;
            }
            return 0;
        }
    }
}

