/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.xbean.recipe.AbstractRecipe;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.Recipe;
import org.apache.xbean.recipe.RecipeHelper;
import org.apache.xbean.recipe.ValueRecipe;

public class CollectionRecipe
extends AbstractRecipe {
    private final List<Object> list;
    private final String type;

    public CollectionRecipe() {
        this.list = new ArrayList<Object>();
        this.type = ArrayList.class.getName();
    }

    public CollectionRecipe(String type) {
        this.list = new ArrayList<Object>();
        this.type = type;
    }

    public CollectionRecipe(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (!RecipeHelper.hasDefaultConstructor(type)) {
            throw new IllegalArgumentException("Type does not have a default constructor " + type);
        }
        this.list = new ArrayList<Object>();
        this.type = type.getName();
    }

    public CollectionRecipe(Collection collection) {
        if (collection == null) {
            throw new NullPointerException("collection is null");
        }
        this.list = new ArrayList<Object>(collection.size());
        this.type = RecipeHelper.hasDefaultConstructor(collection.getClass()) ? collection.getClass().getName() : (collection instanceof SortedSet ? TreeSet.class.getName() : (collection instanceof Set ? LinkedHashSet.class.getName() : ArrayList.class.getName()));
        this.addAll(collection);
    }

    public CollectionRecipe(String type, Collection collection) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (collection == null) {
            throw new NullPointerException("collection is null");
        }
        this.list = new ArrayList<Object>(collection.size());
        this.type = type;
        this.addAll(collection);
    }

    public CollectionRecipe(Class type, Collection collection) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (!RecipeHelper.hasDefaultConstructor(type)) {
            throw new IllegalArgumentException("Type does not have a default constructor " + type);
        }
        if (collection == null) {
            throw new NullPointerException("collection is null");
        }
        this.list = new ArrayList<Object>(collection.size());
        this.type = type.getName();
        this.addAll(collection);
    }

    public CollectionRecipe(CollectionRecipe collectionRecipe) {
        if (collectionRecipe == null) {
            throw new NullPointerException("setRecipe is null");
        }
        this.type = collectionRecipe.type;
        this.list = new ArrayList<Object>(collectionRecipe.list);
    }

    public boolean canCreate(Class type, ClassLoader classLoader) {
        Class myType = this.getType(classLoader);
        return type.isAssignableFrom(myType);
    }

    public Collection create(ClassLoader classLoader) {
        Object o;
        Class setType = this.getType(classLoader);
        if (!RecipeHelper.hasDefaultConstructor(setType)) {
            throw new ConstructionException("Type does not have a default constructor " + this.type);
        }
        try {
            o = setType.newInstance();
        }
        catch (Exception e) {
            throw new ConstructionException("Error while creating set instance: " + this.type);
        }
        if (!(o instanceof Collection)) {
            throw new ConstructionException("Specified set type does not implement the Collection interface: " + this.type);
        }
        Collection instance = (Collection)o;
        int i = 0;
        for (Object value : this.list) {
            if (value instanceof Recipe) {
                Recipe recipe = (Recipe)value;
                try {
                    value = recipe.create(classLoader);
                }
                catch (ConstructionException e) {
                    e.setPrependAttributeName("[" + this.type + " item " + i + "]");
                    throw e;
                }
            }
            instance.add(value);
            ++i;
        }
        return instance;
    }

    private Class getType(ClassLoader classLoader) {
        Class<?> setType = null;
        try {
            setType = Class.forName(this.type, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Type class could not be found: " + this.type);
        }
        return setType;
    }

    public void add(Boolean value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.list.add(value);
    }

    public void add(Character value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.list.add(value);
    }

    public void add(Byte value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.list.add(value);
    }

    public void add(Short value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.list.add(value);
    }

    public void add(Integer value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.list.add(value);
    }

    public void add(Long value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.list.add(value);
    }

    public void add(Float value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.list.add(value);
    }

    public void add(Double value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.list.add(value);
    }

    public void add(String value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.list.add(value);
    }

    public void add(Recipe value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.list.add(value);
    }

    public void addAll(Collection value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        for (Object o : value) {
            if (o instanceof Boolean) {
                this.add((Boolean)o);
                continue;
            }
            if (o instanceof Character) {
                this.add((Character)o);
                continue;
            }
            if (o instanceof Byte) {
                this.add((Byte)o);
                continue;
            }
            if (o instanceof Short) {
                this.add((Short)o);
                continue;
            }
            if (o instanceof Integer) {
                this.add((Integer)o);
                continue;
            }
            if (o instanceof Long) {
                this.add((Long)o);
                continue;
            }
            if (o instanceof Float) {
                this.add((Float)o);
                continue;
            }
            if (o instanceof Double) {
                this.add((Double)o);
                continue;
            }
            if (o instanceof String) {
                this.add((String)o);
                continue;
            }
            if (o instanceof Recipe) {
                this.add((Recipe)o);
                continue;
            }
            this.add(new ValueRecipe(o));
        }
    }
}

