/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean;

public class Classes {
    public static String getClassName(Class type) {
        return Classes.getClassName(type, false);
    }

    public static String getClassName(Object instance) {
        return Classes.getClassName(instance, false);
    }

    public static String getClassName(Object instance, boolean pretty) {
        if (instance == null) {
            return "null";
        }
        return Classes.getClassName(instance.getClass(), pretty);
    }

    public static String getClassName(Class type, boolean pretty) {
        StringBuffer name = new StringBuffer();
        while (type.isArray()) {
            name.append('[');
            if (pretty) {
                name.append(']');
            }
            type = type.getComponentType();
        }
        if (type.isPrimitive()) {
            if (pretty) {
                name.insert(0, type.getName());
            } else if (type.equals(Boolean.TYPE)) {
                name.append('Z');
            } else if (type.equals(Byte.TYPE)) {
                name.append('B');
            } else if (type.equals(Character.TYPE)) {
                name.append('C');
            } else if (type.equals(Short.TYPE)) {
                name.append('S');
            } else if (type.equals(Integer.TYPE)) {
                name.append('I');
            } else if (type.equals(Long.TYPE)) {
                name.append('J');
            } else if (type.equals(Float.TYPE)) {
                name.append('F');
            } else if (type.equals(Double.TYPE)) {
                name.append('D');
            } else if (type.equals(Void.TYPE)) {
                name.append('V');
            }
        } else if (pretty) {
            name.insert(0, type.getName());
        } else {
            name.append('L');
            name.append(type.getName());
            name.append(';');
        }
        return name.toString();
    }
}

