/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.context;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class VirtualSubcontext
implements Context {
    private final Name nameInContext;
    private final Context context;

    public VirtualSubcontext(Name nameInContext, Context context) throws NamingException {
        if (context instanceof VirtualSubcontext) {
            VirtualSubcontext virtualSubcontext = (VirtualSubcontext)context;
            this.nameInContext = virtualSubcontext.getNameInContext(nameInContext);
            this.context = virtualSubcontext.context;
        } else {
            this.nameInContext = nameInContext;
            this.context = context;
        }
    }

    private Name getNameInContext(Name name) throws NamingException {
        return this.context.composeName(this.nameInContext, name);
    }

    private Name getNameInContext(String name) throws NamingException {
        Name parsedName = this.context.getNameParser("").parse(name);
        return this.context.composeName(this.nameInContext, parsedName);
    }

    public Object lookup(Name name) throws NamingException {
        return this.context.lookup(this.getNameInContext(name));
    }

    public Object lookup(String name) throws NamingException {
        return this.context.lookup(this.getNameInContext(name));
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.context.bind(this.getNameInContext(name), obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.context.bind(this.getNameInContext(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.context.rebind(this.getNameInContext(name), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.context.rebind(this.getNameInContext(name), obj);
    }

    public void unbind(Name name) throws NamingException {
        this.context.unbind(this.getNameInContext(name));
    }

    public void unbind(String name) throws NamingException {
        this.context.unbind(this.getNameInContext(name));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.context.rename(this.getNameInContext(oldName), this.getNameInContext(newName));
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.context.rename(this.getNameInContext(oldName), this.getNameInContext(newName));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.context.list(this.getNameInContext(name));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.context.list(this.getNameInContext(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.context.listBindings(this.getNameInContext(name));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.context.listBindings(this.getNameInContext(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.context.destroySubcontext(this.getNameInContext(name));
    }

    public void destroySubcontext(String name) throws NamingException {
        this.context.destroySubcontext(this.getNameInContext(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.context.createSubcontext(this.getNameInContext(name));
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.context.createSubcontext(this.getNameInContext(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.context.lookupLink(this.getNameInContext(name));
    }

    public Object lookupLink(String name) throws NamingException {
        return this.context.lookupLink(this.getNameInContext(name));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.context.getNameParser(this.getNameInContext(name));
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.context.getNameParser(this.getNameInContext(name));
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.context.composeName(name, prefix);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.context.composeName(name, prefix);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.context.addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.context.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.context.getEnvironment();
    }

    public void close() throws NamingException {
        this.context.close();
    }

    public String getNameInNamespace() throws NamingException {
        Name parsedNameInNamespace = this.context.getNameParser("").parse(this.context.getNameInNamespace());
        return this.context.composeName(parsedNameInNamespace, this.nameInContext).toString();
    }
}

