/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.context;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import org.apache.xbean.naming.context.AbstractContext;
import org.apache.xbean.naming.context.ContextAccess;
import org.apache.xbean.naming.context.ContextFederation;
import org.apache.xbean.naming.context.VirtualSubcontext;

public abstract class AbstractFederatedContext
extends AbstractContext {
    private final ContextFederation contextFederation;
    private final AbstractFederatedContext masterContext;

    public AbstractFederatedContext() {
        this("", ContextAccess.MODIFIABLE);
    }

    public AbstractFederatedContext(String nameInNamespace) {
        this(nameInNamespace, ContextAccess.MODIFIABLE);
    }

    public AbstractFederatedContext(String nameInNamespace, ContextAccess contextAccess) {
        super(nameInNamespace, contextAccess);
        this.masterContext = this;
        this.contextFederation = new ContextFederation(this);
    }

    public AbstractFederatedContext(AbstractFederatedContext masterContext, String path) throws NamingException {
        super(masterContext.getNameInNamespace(path), masterContext.getContextAccess());
        this.masterContext = masterContext;
        this.contextFederation = this.masterContext.contextFederation.createSubcontextFederation(path, this);
    }

    protected Object faultLookup(String stringName, Name parsedName) {
        Object value = this.contextFederation.lookup(parsedName);
        if (value != null) {
            return value;
        }
        return super.faultLookup(stringName, parsedName);
    }

    protected final Map getBindings() throws NamingException {
        Map bindings = this.contextFederation.getFederatedBindings();
        bindings.putAll(this.getWrapperBindings());
        return bindings;
    }

    protected abstract Map getWrapperBindings() throws NamingException;

    protected boolean addBinding(String name, Object value, boolean rebind) throws NamingException {
        if (!(value instanceof Context) || this.isNestedSubcontext(value)) {
            return this.contextFederation.addBinding(name, value, rebind);
        }
        if (value instanceof Context && !this.isNestedSubcontext(value)) {
            Context federatedContext = (Context)value;
            Object existingValue = this.getBinding(name);
            if (existingValue != null) {
                if (!(existingValue instanceof AbstractFederatedContext)) {
                    throw new NameAlreadyBoundException(name);
                }
                AbstractFederatedContext nestedContext = (AbstractFederatedContext)existingValue;
                AbstractFederatedContext.addFederatedContext(nestedContext, federatedContext);
                return true;
            }
            AbstractFederatedContext nestedContext = (AbstractFederatedContext)this.createNestedSubcontext(name, Collections.EMPTY_MAP);
            AbstractFederatedContext.addFederatedContext(nestedContext, federatedContext);
            return this.addBinding(name, nestedContext, rebind);
        }
        return false;
    }

    protected boolean removeBinding(String name, boolean removeNotEmptyContext) throws NamingException {
        return this.contextFederation.removeBinding(name);
    }

    protected static void addFederatedContext(AbstractFederatedContext wrappingContext, Context innerContext) throws NamingException {
        wrappingContext.contextFederation.addContext(innerContext);
        Iterator iterator = wrappingContext.getWrapperBindings().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof AbstractFederatedContext)) continue;
            AbstractFederatedContext nestedContext = (AbstractFederatedContext)value;
            Name parsedName = wrappingContext.getNameParser().parse(name);
            Name nameInNamespace = wrappingContext.getNameInNamespace(parsedName);
            VirtualSubcontext virtualSubcontext = new VirtualSubcontext(nameInNamespace, innerContext);
            AbstractFederatedContext.addFederatedContext(nestedContext, virtualSubcontext);
        }
    }

    public boolean isNestedSubcontext(Object value) {
        if (value instanceof AbstractFederatedContext) {
            AbstractFederatedContext context = (AbstractFederatedContext)value;
            return this.getMasterContext() == context.getMasterContext();
        }
        return false;
    }

    protected AbstractFederatedContext getMasterContext() {
        return this.masterContext;
    }
}

