/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.compendium.cm;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.aries.blueprint.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.ServiceProcessor;
import org.apache.aries.blueprint.compendium.cm.CmUtils;
import org.apache.aries.blueprint.compendium.cm.ManagedObject;
import org.apache.aries.blueprint.compendium.cm.ManagedObjectManager;
import org.apache.aries.blueprint.utils.JavaUtils;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmProperties
implements ManagedObject,
ServiceProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmProperties.class);
    private ExtendedBlueprintContainer blueprintContainer;
    private ConfigurationAdmin configAdmin;
    private ManagedObjectManager managedObjectManager;
    private String persistentId;
    private boolean update;
    private String serviceId;
    private final Object lock = new Object();
    private final Set<ServiceProcessor.ServicePropertiesUpdater> services = new HashSet<ServiceProcessor.ServicePropertiesUpdater>();
    private Dictionary<String, Object> properties;

    public ExtendedBlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(ExtendedBlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void setManagedObjectManager(ManagedObjectManager managedObjectManager) {
        this.managedObjectManager = managedObjectManager;
    }

    public ManagedObjectManager getManagedObjectManager() {
        return this.managedObjectManager;
    }

    public Bundle getBundle() {
        return this.blueprintContainer.getBundleContext().getBundle();
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    public void setPersistentId(String persistentId) {
        this.persistentId = persistentId;
    }

    public boolean getUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        LOGGER.debug("Initializing CmProperties for service={} / pid={}", (Object)this.serviceId, (Object)this.persistentId);
        Properties props = new Properties();
        props.put("service.pid", this.persistentId);
        Bundle bundle = this.blueprintContainer.getBundleContext().getBundle();
        props.put("Bundle-SymbolicName", bundle.getSymbolicName());
        props.put("Bundle-Version", bundle.getHeaders().get("Bundle-Version"));
        Object object = this.lock;
        synchronized (object) {
            this.managedObjectManager.register(this, props);
            Configuration config = CmUtils.getConfiguration(this.configAdmin, this.persistentId);
            if (config != null) {
                this.properties = config.getProperties();
            }
        }
    }

    public void destroy() {
        this.managedObjectManager.unregister(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Dictionary props) {
        LOGGER.debug("Service properties updated for service={} / pid={}, {}", new Object[]{this.serviceId, this.persistentId, props});
        Object object = this.lock;
        synchronized (object) {
            this.properties = props;
            if (this.update) {
                for (ServiceProcessor.ServicePropertiesUpdater service : this.services) {
                    service.updateProperties(props);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperties(ServiceProcessor.ServicePropertiesUpdater service, Dictionary props) {
        if (!this.serviceId.equals(service.getId())) {
            return;
        }
        LOGGER.debug("Service properties initialized for service={} / pid={}, {}", new Object[]{this.serviceId, this.persistentId, props});
        Object object = this.lock;
        synchronized (object) {
            this.services.add(service);
            if (this.properties != null) {
                JavaUtils.copy((Dictionary)props, this.properties);
            }
        }
    }
}

