/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.maven;

import java.beans.PropertyEditorManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.BuildException;
import org.apache.xbean.spring.generator.DocumentationGenerator;
import org.apache.xbean.spring.generator.GeneratorPlugin;
import org.apache.xbean.spring.generator.LogFacade;
import org.apache.xbean.spring.generator.NamespaceMapping;
import org.apache.xbean.spring.generator.QdoxMappingLoader;
import org.apache.xbean.spring.generator.WikiDocumentationGenerator;
import org.apache.xbean.spring.generator.XmlMetadataGenerator;
import org.apache.xbean.spring.generator.XsdGenerator;

public class XBeanMojo
extends AbstractMojo
implements LogFacade {
    private MavenProject project;
    protected MavenProjectHelper projectHelper;
    private String namespace;
    private File srcDir;
    private List<String> includes;
    private List<String> classPathIncludes;
    private String excludedClasses;
    private File outputDir;
    private File schema;
    private String propertyEditorPaths;
    private boolean schemaAsArtifact = true;
    private boolean generateSpringSchemasFile = true;
    private boolean generateSpringHandlersFile = true;
    private boolean strictXsdOrder = true;
    private List<GeneratorPlugin> generatorPlugins = Collections.emptyList();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)" ======= XBeanMojo settings =======");
        this.getLog().debug((CharSequence)("namespace[" + this.namespace + "]"));
        this.getLog().debug((CharSequence)("srcDir[" + this.srcDir + "]"));
        this.getLog().debug((CharSequence)("schema[" + this.schema + "]"));
        this.getLog().debug((CharSequence)("excludedClasses[" + this.excludedClasses + "]"));
        this.getLog().debug((CharSequence)("outputDir[" + this.outputDir + "]"));
        this.getLog().debug((CharSequence)("propertyEditorPaths[" + this.propertyEditorPaths + "]"));
        this.getLog().debug((CharSequence)("schemaAsArtifact[" + this.schemaAsArtifact + "]"));
        this.getLog().debug((CharSequence)("generateSpringSchemasFile[" + this.generateSpringSchemasFile + "]"));
        this.getLog().debug((CharSequence)("generateSpringHandlersFile[" + this.generateSpringHandlersFile + "]"));
        if (this.schema == null) {
            this.schema = new File(this.outputDir, this.project.getArtifactId() + ".xsd");
        }
        if (this.propertyEditorPaths != null) {
            LinkedList<String> editorSearchPath = new LinkedList<String>(Arrays.asList(PropertyEditorManager.getEditorSearchPath()));
            StringTokenizer paths = new StringTokenizer(this.propertyEditorPaths, " ,");
            while (paths.hasMoreElements()) {
                editorSearchPath.add((String)paths.nextElement());
            }
            PropertyEditorManager.setEditorSearchPath(editorSearchPath.toArray(new String[editorSearchPath.size()]));
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            this.schema.getParentFile().mkdirs();
            String[] excludedClasses = null;
            if (this.excludedClasses != null) {
                excludedClasses = this.excludedClasses.split(" *, *");
            }
            Set dependencies = this.project.getDependencyArtifacts();
            ArrayList<File> sourceJars = new ArrayList<File>();
            sourceJars.add(this.srcDir);
            if (this.includes != null) {
                for (String src : this.includes) {
                    sourceJars.add(new File(src));
                }
            }
            for (Artifact dependency : dependencies) {
                if (!"sources".equals(dependency.getClassifier())) continue;
                File file = dependency.getFile();
                sourceJars.add(file);
            }
            File[] srcJars = sourceJars.toArray(new File[sourceJars.size()]);
            QdoxMappingLoader mappingLoader = new QdoxMappingLoader(this.namespace, srcJars, excludedClasses);
            GeneratorPlugin[] plugins = new GeneratorPlugin[]{new XmlMetadataGenerator(this.outputDir.getAbsolutePath(), this.schema, this.generateSpringSchemasFile, this.generateSpringHandlersFile), new DocumentationGenerator(this.schema), new XsdGenerator(this.schema, this.strictXsdOrder), new WikiDocumentationGenerator(this.schema)};
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            Set namespaces = mappingLoader.loadNamespaces();
            if (namespaces.isEmpty()) {
                System.out.println("Warning: no namespaces found!");
            }
            for (NamespaceMapping namespaceMapping : namespaces) {
                for (GeneratorPlugin plugin : plugins) {
                    plugin.setLog((LogFacade)this);
                    plugin.generate(namespaceMapping);
                }
                for (GeneratorPlugin plugin : this.generatorPlugins) {
                    plugin.setLog((LogFacade)this);
                    plugin.generate(namespaceMapping);
                }
            }
            if (this.schemaAsArtifact) {
                this.projectHelper.attachArtifact(this.project, "xsd", null, this.schema);
                this.projectHelper.attachArtifact(this.project, "html", "schema", new File(this.schema.getAbsolutePath() + ".html"));
            }
            Resource res = new Resource();
            res.setDirectory(this.outputDir.toString());
            this.project.addResource(res);
            this.log("...done.");
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public void log(String message) {
        this.getLog().info((CharSequence)message);
    }

    public void log(String message, int level) {
        this.getLog().info((CharSequence)message);
    }

    protected URLClassLoader getClassLoader() throws MojoExecutionException {
        try {
            HashSet<URL> urls = new HashSet<URL>();
            URL mainClasses = new File(this.project.getBuild().getOutputDirectory()).toURL();
            this.getLog().debug((CharSequence)("Adding to classpath : " + mainClasses));
            urls.add(mainClasses);
            URL testClasses = new File(this.project.getBuild().getTestOutputDirectory()).toURL();
            this.getLog().debug((CharSequence)("Adding to classpath : " + testClasses));
            urls.add(testClasses);
            Set dependencies = this.project.getArtifacts();
            Iterator iter = dependencies.iterator();
            for (Artifact classPathElement : dependencies) {
                this.getLog().debug((CharSequence)("Adding artifact: " + classPathElement.getFile() + " to classpath"));
                urls.add(classPathElement.getFile().toURL());
            }
            if (this.classPathIncludes != null) {
                for (String include : this.classPathIncludes) {
                    URL url = new File(include).toURL();
                    this.getLog().debug((CharSequence)("Adding to classpath : " + url));
                    urls.add(url);
                }
            }
            URLClassLoader appClassloader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            return appClassloader;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }
}

