/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import java.security.cert.X509Certificate;
import org.apache.wss4j.common.WSSPolicyException;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.X509Token;
import org.apache.wss4j.policy.stax.assertionStates.TokenAssertionState;
import org.apache.wss4j.stax.securityEvent.X509TokenSecurityEvent;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;
import org.apache.xml.security.stax.securityToken.SecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenConstants;

public class X509TokenAssertionState
extends TokenAssertionState {
    public X509TokenAssertionState(AbstractSecurityAssertion assertion, boolean asserted, boolean initiator) {
        super(assertion, asserted, initiator);
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{SecurityEventConstants.X509Token};
    }

    @Override
    public boolean assertToken(TokenSecurityEvent<? extends SecurityToken> tokenSecurityEvent, AbstractToken abstractToken) throws WSSPolicyException, XMLSecurityException {
        if (!(tokenSecurityEvent instanceof X509TokenSecurityEvent)) {
            throw new WSSPolicyException("Expected a X509TokenSecurityEvent but got " + tokenSecurityEvent.getClass().getName());
        }
        X509Token x509Token = (X509Token)abstractToken;
        SecurityToken securityToken = tokenSecurityEvent.getSecurityToken();
        SecurityTokenConstants.TokenType tokenType = securityToken.getTokenType();
        if (!(WSSecurityTokenConstants.X509V3Token.equals((Object)tokenType) || WSSecurityTokenConstants.X509V1Token.equals((Object)tokenType) || WSSecurityTokenConstants.X509Pkcs7Token.equals((Object)tokenType) || WSSecurityTokenConstants.X509PkiPathV1Token.equals((Object)tokenType))) {
            throw new WSSPolicyException("Invalid Token for this assertion");
        }
        try {
            X509Certificate x509Certificate = securityToken.getX509Certificates()[0];
            if (x509Token.getIssuerName() != null) {
                String certificateIssuerName = x509Certificate.getIssuerX500Principal().getName();
                if (!x509Token.getIssuerName().equals(certificateIssuerName)) {
                    this.setErrorMessage("IssuerName in Policy (" + x509Token.getIssuerName() + ") didn't match with the one in the certificate (" + certificateIssuerName + ")");
                    return false;
                }
            }
            if (x509Token.isRequireKeyIdentifierReference() && !WSSecurityTokenConstants.KeyIdentifier_X509KeyIdentifier.equals((Object)securityToken.getKeyIdentifier()) && !WSSecurityTokenConstants.KeyIdentifier_SkiKeyIdentifier.equals((Object)securityToken.getKeyIdentifier())) {
                this.setErrorMessage("Policy enforces KeyIdentifierReference but we got " + securityToken.getKeyIdentifier());
                return false;
            }
            if (x509Token.isRequireIssuerSerialReference() && !WSSecurityTokenConstants.KeyIdentifier_IssuerSerial.equals((Object)securityToken.getKeyIdentifier())) {
                this.setErrorMessage("Policy enforces IssuerSerialReference but we got " + securityToken.getKeyIdentifier());
                return false;
            }
            if (x509Token.isRequireEmbeddedTokenReference() && !WSSecurityTokenConstants.KeyIdentifier_SecurityTokenDirectReference.equals((Object)securityToken.getKeyIdentifier())) {
                this.setErrorMessage("Policy enforces EmbeddedTokenReference but we got " + securityToken.getKeyIdentifier());
                return false;
            }
            if (x509Token.isRequireThumbprintReference() && !WSSecurityTokenConstants.KeyIdentifier_ThumbprintIdentifier.equals((Object)securityToken.getKeyIdentifier())) {
                this.setErrorMessage("Policy enforces ThumbprintReference but we got " + securityToken.getKeyIdentifier());
                return false;
            }
            if (x509Certificate.getVersion() == 2) {
                this.setErrorMessage("X509Certificate Version " + x509Certificate.getVersion() + " not supported");
                return false;
            }
            if (x509Token.getTokenType() != null) {
                switch (x509Token.getTokenType()) {
                    case WssX509V3Token10: 
                    case WssX509V3Token11: {
                        if (WSSecurityTokenConstants.X509V3Token.equals((Object)securityToken.getTokenType()) && x509Certificate.getVersion() == 3) break;
                        this.setErrorMessage("X509Certificate Version " + x509Certificate.getVersion() + " mismatch; Policy enforces " + x509Token.getTokenType());
                        return false;
                    }
                    case WssX509V1Token11: {
                        if (WSSecurityTokenConstants.X509V1Token.equals((Object)securityToken.getTokenType()) && x509Certificate.getVersion() == 1) break;
                        this.setErrorMessage("X509Certificate Version " + x509Certificate.getVersion() + " mismatch; Policy enforces " + x509Token.getTokenType());
                        return false;
                    }
                    case WssX509PkiPathV1Token10: 
                    case WssX509PkiPathV1Token11: {
                        if (WSSecurityTokenConstants.X509PkiPathV1Token.equals((Object)securityToken.getTokenType())) break;
                        this.setErrorMessage("Policy enforces " + x509Token.getTokenType() + " but we got " + securityToken.getTokenType());
                        return false;
                    }
                    case WssX509Pkcs7Token10: 
                    case WssX509Pkcs7Token11: {
                        this.setErrorMessage("Unsupported token type: " + securityToken.getTokenType());
                        return false;
                    }
                }
            }
        }
        catch (XMLSecurityException e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
        return true;
    }
}

