/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.processor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.OAEPParameterSpec;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import org.apache.wss4j.common.bsp.BSPEnforcer;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.AlgorithmSuite;
import org.apache.wss4j.common.crypto.AlgorithmSuiteValidator;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.token.DOMX509IssuerSerial;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.processor.CertificateResult;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.str.EncryptedKeySTRParser;
import org.apache.wss4j.dom.str.STRParser;
import org.apache.wss4j.dom.str.STRParserParameters;
import org.apache.wss4j.dom.str.STRParserResult;
import org.apache.wss4j.dom.util.EncryptionUtils;
import org.apache.wss4j.dom.util.SignatureUtils;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.util.X509Util;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.AgreementMethod;
import org.apache.xml.security.encryption.KeyDerivationMethod;
import org.apache.xml.security.encryption.XMLCipherUtil;
import org.apache.xml.security.encryption.keys.RecipientKeyInfo;
import org.apache.xml.security.encryption.keys.content.AgreementMethodImpl;
import org.apache.xml.security.encryption.params.KeyAgreementParameters;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptedKeyProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedKeyProcessor.class);
    private final Provider provider;

    public EncryptedKeyProcessor() {
        this(null);
    }

    public EncryptedKeyProcessor(Provider provider) {
        this.provider = provider;
    }

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data) throws WSSecurityException {
        return this.handleToken(elem, data, data.getAlgorithmSuite());
    }

    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, AlgorithmSuite algorithmSuite) throws WSSecurityException {
        WSSecurityEngineResult result;
        LOG.debug("Found encrypted key element");
        String id = elem.getAttributeNS(null, "Id");
        if (!id.isEmpty() && (result = data.getWsDocInfo().getResult(id)) != null && 4 == (Integer)result.get("action")) {
            return Collections.singletonList(result);
        }
        if (data.getCallbackHandler() == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
        }
        String encryptedKeyTransportMethod = X509Util.getEncAlgo(elem);
        if (encryptedKeyTransportMethod == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, "noEncAlgo");
        }
        if (!(!"http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(encryptedKeyTransportMethod) || data.isAllowRSA15KeyTransportAlgorithm() || algorithmSuite != null && algorithmSuite.getKeyWrapAlgorithms().contains("http://www.w3.org/2001/04/xmlenc#rsa-1_5"))) {
            LOG.debug("The Key transport method does not match the requirement");
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY);
        }
        Element keyInfoChildElement = this.getKeyInfoChildElement(elem, data);
        boolean isDHKeyWrap = this.isDiffieHellmanKeyWrap(keyInfoChildElement);
        this.checkBSPCompliance(elem, encryptedKeyTransportMethod, isDHKeyWrap, data.getBSPEnforcer());
        Element xencCipherValue = EncryptionUtils.getCipherValueFromEncryptedData(elem);
        if (xencCipherValue == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "noCipher");
        }
        X509Certificate[] certs = null;
        STRParser.REFERENCE_TYPE referenceType = null;
        PublicKey publicKey = null;
        boolean symmetricKeyWrap = EncryptedKeyProcessor.isSymmetricKeyWrap(encryptedKeyTransportMethod);
        AgreementMethod agreementMethod = null;
        KeyDerivationMethod keyDerivationMethod = null;
        if (isDHKeyWrap) {
            agreementMethod = this.getAgreementMethodFromElement(keyInfoChildElement);
            keyDerivationMethod = this.getKeyDerivationFunction(agreementMethod);
            keyInfoChildElement = this.getRecipientKeyInfoChildElement(agreementMethod);
            if (keyInfoChildElement == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "noRecipientSecTokRef");
            }
        }
        if (!symmetricKeyWrap || isDHKeyWrap) {
            CertificateResult certificateResult = this.getPublicKey(keyInfoChildElement, data);
            certs = certificateResult.getCerts();
            publicKey = certificateResult.getPublicKey();
            referenceType = certificateResult.getCertificatesReferenceType();
        }
        if (algorithmSuite != null) {
            AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
            if (!symmetricKeyWrap) {
                algorithmSuiteValidator.checkAsymmetricKeyLength(publicKey);
            }
            algorithmSuiteValidator.checkEncryptionKeyWrapAlgorithm(encryptedKeyTransportMethod);
            if (agreementMethod != null) {
                algorithmSuiteValidator.checkKeyAgreementMethodAlgorithm(agreementMethod.getAlgorithm());
            }
            if (keyDerivationMethod != null) {
                algorithmSuiteValidator.checkKeyDerivationFunction(keyDerivationMethod.getAlgorithm());
            }
        }
        byte[] encryptedEphemeralKey = null;
        byte[] decryptedBytes = null;
        Element refList = XMLUtils.getDirectChildElement((Node)elem, (String)"ReferenceList", (String)"http://www.w3.org/2001/04/xmlenc#");
        String xopUri = EncryptionUtils.getXOPURIFromCipherValue(xencCipherValue);
        encryptedEphemeralKey = xopUri != null && xopUri.startsWith("cid:") ? WSSecurityUtil.getBytesFromAttachment(xopUri, data) : EncryptionUtils.getDecodedBase64EncodedData(xencCipherValue);
        if (isDHKeyWrap) {
            privateKey = this.getPrivateKey(data, certs, publicKey);
            decryptedBytes = EncryptedKeyProcessor.getDiffieHellmanDecryptedBytes(data, agreementMethod, encryptedKeyTransportMethod, encryptedEphemeralKey, privateKey);
        } else if (symmetricKeyWrap) {
            decryptedBytes = EncryptedKeyProcessor.getSymmetricDecryptedBytes(data, data.getWsDocInfo(), keyInfoChildElement, refList);
        } else {
            privateKey = this.getPrivateKey(data, certs, publicKey);
            decryptedBytes = EncryptedKeyProcessor.getAsymmetricDecryptedBytes(data, data.getWsDocInfo(), encryptedKeyTransportMethod, encryptedEphemeralKey, refList, elem, privateKey);
        }
        List<WSDataRef> dataRefs = this.decryptDataRefs(refList, data.getWsDocInfo(), decryptedBytes, data);
        WSSecurityEngineResult result2 = new WSSecurityEngineResult(4, decryptedBytes, encryptedEphemeralKey, dataRefs, certs);
        result2.put("encrypted-key-transport-method", encryptedKeyTransportMethod);
        result2.put("token-element", elem);
        String tokenId = elem.getAttributeNS(null, "Id");
        if (tokenId.length() != 0) {
            result2.put("id", tokenId);
        }
        if (referenceType != null) {
            result2.put("x509-reference-type", referenceType);
        }
        if (publicKey != null) {
            result2.put("public-key", publicKey);
        }
        data.getWsDocInfo().addResult(result2);
        data.getWsDocInfo().addTokenElement(elem);
        return Collections.singletonList(result2);
    }

    private CertificateResult getPublicKey(Element keyValueElement, RequestData data) throws WSSecurityException {
        CertificateResult.Builder builder = CertificateResult.Builder.create();
        if ("SecurityTokenReference".equals(keyValueElement.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(keyValueElement.getNamespaceURI())) {
            STRParserParameters parameters = new STRParserParameters();
            parameters.setData(data);
            parameters.setStrElement(keyValueElement);
            EncryptedKeySTRParser strParser = new EncryptedKeySTRParser();
            STRParserResult result = strParser.parseSecurityTokenReference(parameters);
            builder.certificates(result.getCertificates());
            builder.publicKey(result.getPublicKey());
            builder.certificatesReferenceType(result.getCertificatesReferenceType());
        } else {
            X509Certificate[] certs = this.getCertificatesFromX509Data(keyValueElement, data);
            builder.certificates(certs);
            if (certs == null || certs.length == 0) {
                XMLSignatureFactory signatureFactory;
                if (this.provider == null) {
                    try {
                        signatureFactory = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig");
                    }
                    catch (NoSuchProviderException ex) {
                        signatureFactory = XMLSignatureFactory.getInstance("DOM");
                    }
                } else {
                    signatureFactory = XMLSignatureFactory.getInstance("DOM", this.provider);
                }
                PublicKey publicKey = X509Util.parseKeyValue((Element)keyValueElement.getParentNode(), signatureFactory);
                builder.publicKey(publicKey);
            }
        }
        return builder.build();
    }

    private PrivateKey getPrivateKey(RequestData data, X509Certificate[] certs, PublicKey publicKey) throws WSSecurityException {
        try {
            if (certs != null && certs.length > 0) {
                return data.getDecCrypto().getPrivateKey(certs[0], data.getCallbackHandler());
            }
            return data.getDecCrypto().getPrivateKey(publicKey, data.getCallbackHandler());
        }
        catch (WSSecurityException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)((Object)ex));
        }
    }

    private static byte[] getSymmetricDecryptedBytes(RequestData data, WSDocInfo wsDocInfo, Element keyInfoChildElement, Element refList) throws WSSecurityException {
        String uri = EncryptedKeyProcessor.getFirstDataRefURI(refList);
        String algorithmURI = null;
        if (uri != null) {
            Element ee = EncryptionUtils.findEncryptedDataElement(wsDocInfo, uri);
            algorithmURI = X509Util.getEncAlgo(ee);
        }
        return X509Util.getSecretKey(keyInfoChildElement, algorithmURI, data.getCallbackHandler());
    }

    private static byte[] getAsymmetricDecryptedBytes(RequestData data, WSDocInfo wsDocInfo, String encryptedKeyTransportMethod, byte[] encryptedEphemeralKey, Element refList, Element encryptedKeyElement, PrivateKey privateKey) throws WSSecurityException {
        if (data.getDecCrypto() == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noDecCryptoFile");
        }
        String cryptoProvider = data.getDecCrypto().getCryptoProvider();
        Cipher cipher = KeyUtils.getCipherInstance((String)encryptedKeyTransportMethod, (String)cryptoProvider);
        try {
            OAEPParameterSpec oaepParameterSpec = null;
            if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(encryptedKeyTransportMethod) || "http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(encryptedKeyTransportMethod)) {
                String digestAlgorithm = EncryptionUtils.getDigestAlgorithm(encryptedKeyElement);
                String mgfAlgorithm = EncryptionUtils.getMGFAlgorithm(encryptedKeyElement);
                byte[] pSourceBytes = EncryptionUtils.getPSource(encryptedKeyElement);
                oaepParameterSpec = XMLCipherUtil.constructOAEPParameters((String)encryptedKeyTransportMethod, (String)digestAlgorithm, (String)mgfAlgorithm, (byte[])pSourceBytes);
            }
            if (oaepParameterSpec == null) {
                cipher.init(4, privateKey);
            } else {
                cipher.init(4, (Key)privateKey, oaepParameterSpec);
            }
        }
        catch (Exception ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, ex);
        }
        try {
            String keyAlgorithm = JCEMapper.translateURItoJCEID((String)encryptedKeyTransportMethod);
            return cipher.unwrap(encryptedEphemeralKey, keyAlgorithm, 3).getEncoded();
        }
        catch (IllegalStateException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)ex);
        }
        catch (Exception ex) {
            return EncryptedKeyProcessor.getRandomKey(refList, wsDocInfo);
        }
    }

    private static byte[] getDiffieHellmanDecryptedBytes(RequestData data, AgreementMethod agreementMethod, String encryptedKeyTransportMethod, byte[] encryptedEphemeralKey, PrivateKey privateKey) throws WSSecurityException {
        SecretKey kek;
        try {
            KeyAgreementParameters parameterSpec = XMLCipherUtil.constructRecipientKeyAgreementParameters((String)encryptedKeyTransportMethod, (AgreementMethod)agreementMethod, (PrivateKey)privateKey);
            kek = org.apache.xml.security.utils.KeyUtils.aesWrapKeyWithDHGeneratedKey((KeyAgreementParameters)parameterSpec);
        }
        catch (XMLSecurityException ex) {
            LOG.debug("Error occurred while resolving the Diffie Hellman key: " + ex.getMessage());
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)((Object)ex));
        }
        String cryptoProvider = data.getDecCrypto().getCryptoProvider();
        Cipher cipher = KeyUtils.getCipherInstance((String)encryptedKeyTransportMethod, (String)cryptoProvider);
        try {
            cipher.init(4, kek);
            String keyAlgorithm = JCEMapper.translateURItoJCEID((String)encryptedKeyTransportMethod);
            return cipher.unwrap(encryptedEphemeralKey, keyAlgorithm, 3).getEncoded();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)ex);
        }
    }

    private boolean isDiffieHellmanKeyWrap(Element keyInfoChildElement) throws WSSecurityException {
        if ("AgreementMethod".equals(keyInfoChildElement.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(keyInfoChildElement.getNamespaceURI())) {
            String algorithmURI = keyInfoChildElement.getAttributeNS(null, "Algorithm");
            if (!("http://www.w3.org/2009/xmlenc11#ECDH-ES".equals(algorithmURI) || "http://www.w3.org/2021/04/xmldsig-more#x25519".equals(algorithmURI) || "http://www.w3.org/2021/04/xmldsig-more#x448".equals(algorithmURI))) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, "unknownAlgorithm", new Object[]{algorithmURI});
            }
            return true;
        }
        return false;
    }

    private AgreementMethod getAgreementMethodFromElement(Element keyInfoChildElement) throws WSSecurityException {
        try {
            return new AgreementMethodImpl(keyInfoChildElement);
        }
        catch (XMLSecurityException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, (Exception)((Object)ex));
        }
    }

    private Element getRecipientKeyInfoChildElement(AgreementMethod agreementMethod) throws WSSecurityException {
        if (agreementMethod == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "noAgreementMethod");
        }
        try {
            RecipientKeyInfo recipientKeyInfo = agreementMethod.getRecipientKeyInfo();
            if (recipientKeyInfo == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "noRecipientKeyInfo");
            }
            Element receiverKeyInfoElement = recipientKeyInfo.getElement();
            return this.getFirstElement(receiverKeyInfoElement);
        }
        catch (XMLSecurityException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, (Exception)((Object)ex));
        }
    }

    private static boolean isSymmetricKeyWrap(String transportAlgorithm) {
        return "http://www.w3.org/2001/04/xmlenc#kw-aes128".equals(transportAlgorithm) || "http://www.w3.org/2001/04/xmlenc#kw-aes192".equals(transportAlgorithm) || "http://www.w3.org/2001/04/xmlenc#kw-aes256".equals(transportAlgorithm) || "http://www.w3.org/2001/04/xmlenc#kw-tripledes".equals(transportAlgorithm) || "http://www.w3.org/2001/04/xmldsig-more#kw-camellia128".equals(transportAlgorithm) || "http://www.w3.org/2001/04/xmldsig-more#kw-camellia192".equals(transportAlgorithm) || "http://www.w3.org/2001/04/xmldsig-more#kw-camellia256".equals(transportAlgorithm) || "http://www.w3.org/2007/05/xmldsig-more#kw-seed128".equals(transportAlgorithm);
    }

    private static byte[] getRandomKey(Element refList, WSDocInfo wsDocInfo) throws WSSecurityException {
        try {
            String alg = "AES";
            int size = 16;
            String uri = EncryptedKeyProcessor.getFirstDataRefURI(refList);
            if (uri != null) {
                Element ee = EncryptionUtils.findEncryptedDataElement(wsDocInfo, uri);
                String algorithmURI = X509Util.getEncAlgo(ee);
                alg = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithmURI);
                size = KeyUtils.getKeyLength((String)algorithmURI);
            }
            KeyGenerator kgen = KeyGenerator.getInstance(alg);
            kgen.init(size * 8);
            SecretKey k = kgen.generateKey();
            return k.getEncoded();
        }
        catch (Throwable ex) {
            try {
                KeyGenerator kgen = KeyGenerator.getInstance("AES");
                kgen.init(128);
                SecretKey k = kgen.generateKey();
                return k.getEncoded();
            }
            catch (NoSuchAlgorithmException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)e);
            }
        }
    }

    private static String getFirstDataRefURI(Element refList) {
        if (refList != null) {
            for (Node node = refList.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType() || !"http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI()) || !"DataReference".equals(node.getLocalName())) continue;
                String dataRefURI = ((Element)node).getAttributeNS(null, "URI");
                return XMLUtils.getIDFromReference((String)dataRefURI);
            }
        }
        return null;
    }

    private Element getKeyInfoChildElement(Element xencEncryptedKey, RequestData data) throws WSSecurityException {
        Element keyInfo = XMLUtils.getDirectChildElement((Node)xencEncryptedKey, (String)"KeyInfo", (String)"http://www.w3.org/2000/09/xmldsig#");
        if (keyInfo != null) {
            Element strElement = null;
            int result = 0;
            for (Node node = keyInfo.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType()) continue;
                ++result;
                strElement = (Element)node;
            }
            if (result != 1) {
                data.getBSPEnforcer().handleBSPRule(BSPRule.R5424);
            }
            if (strElement == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "noSecTokRef");
            }
            return strElement;
        }
        throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "noKeyinfo");
    }

    private KeyDerivationMethod getKeyDerivationFunction(AgreementMethod agreementMethod) throws WSSecurityException {
        if (agreementMethod == null) {
            return null;
        }
        try {
            return agreementMethod.getKeyDerivationMethod();
        }
        catch (XMLSecurityException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, (Exception)((Object)ex));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private X509Certificate[] getCertificatesFromX509Data(Element keyInfoChildElement, RequestData data) throws WSSecurityException {
        if (!"http://www.w3.org/2000/09/xmldsig#".equals(keyInfoChildElement.getNamespaceURI())) return new X509Certificate[0];
        if (!"X509Data".equals(keyInfoChildElement.getLocalName())) return new X509Certificate[0];
        data.getBSPEnforcer().handleBSPRule(BSPRule.R5426);
        Element x509Child = this.getFirstElement(keyInfoChildElement);
        if (x509Child == null) return new X509Certificate[0];
        if (!"http://www.w3.org/2000/09/xmldsig#".equals(x509Child.getNamespaceURI())) return new X509Certificate[0];
        if ("X509IssuerSerial".equals(x509Child.getLocalName())) {
            DOMX509IssuerSerial issuerSerial = new DOMX509IssuerSerial(x509Child);
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ISSUER_SERIAL);
            cryptoType.setIssuerSerial(issuerSerial.getIssuer(), issuerSerial.getSerialNumber());
            return data.getDecCrypto().getX509Certificates(cryptoType);
        }
        if (!"X509Certificate".equals(x509Child.getLocalName())) return new X509Certificate[0];
        byte[] token = EncryptionUtils.getDecodedBase64EncodedData(x509Child);
        if (token == null || token.length == 0) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidCertData", new Object[]{"0"});
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(token);){
            X509Certificate cert = data.getDecCrypto().loadCertificate((InputStream)in);
            if (cert == null) return new X509Certificate[0];
            X509Certificate[] x509CertificateArray = new X509Certificate[]{cert};
            return x509CertificateArray;
        }
        catch (IOException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_TOKEN_UNAVAILABLE, (Exception)e, "parseError");
        }
    }

    private Element getFirstElement(Element element) {
        for (Node currentChild = element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (1 != currentChild.getNodeType()) continue;
            return (Element)currentChild;
        }
        return null;
    }

    protected List<WSDataRef> decryptDataRefs(Element refList, WSDocInfo docInfo, byte[] decryptedBytes, RequestData data) throws WSSecurityException {
        if (refList == null) {
            return Collections.emptyList();
        }
        ArrayList<WSDataRef> dataRefs = new ArrayList<WSDataRef>();
        for (Node node = refList.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (1 != node.getNodeType() || !"http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI()) || !"DataReference".equals(node.getLocalName())) continue;
            String dataRefURI = ((Element)node).getAttributeNS(null, "URI");
            dataRefURI = XMLUtils.getIDFromReference((String)dataRefURI);
            WSDataRef dataRef = this.decryptDataRef(refList.getOwnerDocument(), dataRefURI, docInfo, decryptedBytes, data);
            dataRefs.add(dataRef);
        }
        return dataRefs;
    }

    protected WSDataRef decryptDataRef(Document doc, String dataRefURI, WSDocInfo docInfo, byte[] decryptedData, RequestData data) throws WSSecurityException {
        String symEncAlgo;
        LOG.debug("found data reference: {}", (Object)dataRefURI);
        Element encryptedDataElement = EncryptionUtils.findEncryptedDataElement(docInfo, dataRefURI);
        if (encryptedDataElement != null && data.isRequireSignedEncryptedDataElements()) {
            List<WSSecurityEngineResult> signedResults = docInfo.getResultsByTag(2);
            SignatureUtils.verifySignedElement(encryptedDataElement, signedResults);
        }
        if ((symEncAlgo = X509Util.getEncAlgo(encryptedDataElement)) == null) {
            LOG.warn("No encryption algorithm was specified in the request");
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, "badEncAlgo", new Object[]{null});
        }
        if (!("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(symEncAlgo) || "http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(symEncAlgo) || "http://www.w3.org/2009/xmlenc11#aes128-gcm".equals(symEncAlgo) || "http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(symEncAlgo) || "http://www.w3.org/2009/xmlenc11#aes256-gcm".equals(symEncAlgo))) {
            data.getBSPEnforcer().handleBSPRule(BSPRule.R5620);
        }
        SecretKey symmetricKey = null;
        try {
            symmetricKey = KeyUtils.prepareSecretKey((String)symEncAlgo, (byte[])decryptedData);
        }
        catch (IllegalArgumentException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)ex, "badEncAlgo", new Object[]{symEncAlgo});
        }
        AlgorithmSuite algorithmSuite = data.getAlgorithmSuite();
        if (algorithmSuite != null) {
            AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
            algorithmSuiteValidator.checkSymmetricKeyLength(symmetricKey.getEncoded().length);
            algorithmSuiteValidator.checkSymmetricEncryptionAlgorithm(symEncAlgo);
        }
        return EncryptionUtils.decryptEncryptedData(doc, dataRefURI, encryptedDataElement, symmetricKey, symEncAlgo, data.getAttachmentCallbackHandler(), data.getEncryptionSerializer());
    }

    private void checkBSPCompliance(Element elem, String encAlgo, boolean useKeyWrap, BSPEnforcer bspEnforcer) throws WSSecurityException {
        String attribute = elem.getAttributeNS(null, "Type");
        if (attribute != null && !attribute.isEmpty()) {
            bspEnforcer.handleBSPRule(BSPRule.R3209);
        }
        if ((attribute = elem.getAttributeNS(null, "MimeType")) != null && !attribute.isEmpty()) {
            bspEnforcer.handleBSPRule(BSPRule.R5622);
        }
        if ((attribute = elem.getAttributeNS(null, "Encoding")) != null && !attribute.isEmpty()) {
            bspEnforcer.handleBSPRule(BSPRule.R5623);
        }
        if ((attribute = elem.getAttributeNS(null, "Recipient")) != null && !attribute.isEmpty()) {
            bspEnforcer.handleBSPRule(BSPRule.R5602);
        }
        if (useKeyWrap) {
            if (!("http://www.w3.org/2001/04/xmlenc#kw-aes128".equals(encAlgo) || "http://www.w3.org/2001/04/xmlenc#kw-aes192".equals(encAlgo) || "http://www.w3.org/2001/04/xmlenc#kw-aes256".equals(encAlgo) || "http://www.w3.org/2001/04/xmlenc#kw-tripledes".equals(encAlgo))) {
                bspEnforcer.handleBSPRule(BSPRule.R5625);
            }
        } else if (!("http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(encAlgo) || "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(encAlgo) || "http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(encAlgo))) {
            bspEnforcer.handleBSPRule(BSPRule.R5621);
        }
    }
}

