/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.validate;

import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.token.BinarySecurity;
import org.apache.wss4j.common.token.X509Security;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.UsernamePasswordCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.NoOpValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ValidatorTest {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();

    @Test
    public void testExpiredTimestamp() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
        timestamp.setTimeToLive(-1);
        Document createdDoc = timestamp.build();
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        try {
            this.verify(createdDoc, wssConfig, null, null);
            Assertions.fail((String)"Expected failure on an expired timestamp");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
        }
        wssConfig.setValidator(WSConstants.TIMESTAMP, NoOpValidator.class);
        this.verify(createdDoc, wssConfig, null, null);
    }

    @Test
    public void testUntrustedSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("wss40", "security");
        sign.setKeyIdentifierType(3);
        Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");
        Document signedDoc = sign.build(crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Crypto cryptoCA = CryptoFactory.getInstance((String)"crypto.properties");
        WSSecurityEngine newEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setSigVerCrypto(cryptoCA);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R3063));
        try {
            newEngine.processSecurityHeader(signedDoc, data);
            Assertions.fail((String)"Failure expected on issuer serial");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
        WSSConfig config = WSSConfig.getNewInstance();
        config.setValidator(WSConstants.SIGNATURE, NoOpValidator.class);
        newEngine.setWssConfig(config);
        data.setWssConfig(config);
        newEngine.processSecurityHeader(signedDoc, data);
    }

    @Test
    public void testUsernameTokenBadText() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        builder.setUserInfo("wernerd", "verySecre");
        Document signedDoc = builder.build();
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        try {
            this.verify(signedDoc, wssConfig, new UsernamePasswordCallbackHandler(), null);
            Assertions.fail((String)"Failure expected on a bad password text");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
        wssConfig.setValidator(WSConstants.USERNAME_TOKEN, NoOpValidator.class);
        this.verify(signedDoc, wssConfig, new UsernamePasswordCallbackHandler(), null);
    }

    @Test
    public void testTransformedBST() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        X509Security bst = new X509Security(doc);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        bst.setX509Certificate(certs[0]);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeaderElement(), (Element)bst.getElement());
        if (LOG.isDebugEnabled()) {
            LOG.debug("BST output");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSSConfig config = WSSConfig.getNewInstance();
        config.setValidator(WSConstants.BINARY_TOKEN, (Validator)new BSTValidator());
        WSSecurityEngine secEngine = new WSSecurityEngine();
        secEngine.setWssConfig(config);
        WSHandlerResult results = secEngine.processSecurityHeader(doc, null, null, crypto);
        List bstResults = (List)results.getActionResults().get(4096);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)bstResults.get(0);
        BinarySecurity token = (BinarySecurity)actionResult.get((Object)"binary-security-token");
        Assertions.assertNotNull((Object)token);
        SamlAssertionWrapper samlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"transformed-token");
        Assertions.assertNotNull((Object)samlAssertion);
    }

    @Test
    public void testValidatedBSTSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(1);
        Document signedDoc = builder.build(CryptoFactory.getInstance());
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");
        WSSConfig config = WSSConfig.getNewInstance();
        WSSecurityEngine secEngine = new WSSecurityEngine();
        secEngine.setWssConfig(config);
        try {
            secEngine.processSecurityHeader(doc, null, null, crypto);
            Assertions.fail((String)"Expected failure on untrusted signature");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
        config.setValidator(WSConstants.BINARY_TOKEN, (Validator)new BSTValidator());
        WSHandlerResult results = secEngine.processSecurityHeader(doc, null, null, crypto);
        List bstResults = (List)results.getActionResults().get(4096);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)bstResults.get(0);
        BinarySecurity token = (BinarySecurity)actionResult.get((Object)"binary-security-token");
        Assertions.assertNotNull((Object)token);
    }

    private WSHandlerResult verify(Document doc, WSSConfig wssConfig, CallbackHandler cb, Crypto crypto) throws Exception {
        this.secEngine.setWssConfig(wssConfig);
        return this.secEngine.processSecurityHeader(doc, null, cb, crypto);
    }

    private static class BSTValidator
    implements Validator {
        private BSTValidator() {
        }

        public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
            BinarySecurity token = credential.getBinarySecurityToken();
            if (token == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE);
            }
            try {
                SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
                callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
                callbackHandler.setIssuer("www.example.com");
                SAMLCallback samlCallback = new SAMLCallback();
                SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
                SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
                credential.setTransformedToken(samlAssertion);
                return credential;
            }
            catch (Exception ex) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE);
            }
        }
    }
}

