/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.util;

import java.util.List;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WSSecurityUtilTest {
    @Test
    public void testNewEncryptionAction() throws Exception {
        String action = "Signature Encryption";
        List decodeActions = WSSecurityUtil.decodeAction((String)action);
        Assertions.assertEquals((int)2, (int)decodeActions.size());
        Assertions.assertEquals((int)2, (Integer)((Integer)decodeActions.get(0)));
        Assertions.assertEquals((int)4, (Integer)((Integer)decodeActions.get(1)));
    }

    @Test
    public void testNewEncryptionHandlerAction() throws Exception {
        String action = "Signature Encryption";
        List decodeActions = WSSecurityUtil.decodeHandlerAction((String)action, (WSSConfig)WSSConfig.getNewInstance());
        Assertions.assertEquals((int)2, (int)decodeActions.size());
        Assertions.assertEquals((int)2, (Integer)((HandlerAction)decodeActions.get(0)).getAction());
        Assertions.assertEquals((int)4, (Integer)((HandlerAction)decodeActions.get(1)).getAction());
    }

    @Test
    public void testDeprecatedEncryptionAction() throws Exception {
        String action = "Signature Encrypt";
        List decodeActions = WSSecurityUtil.decodeAction((String)action);
        Assertions.assertEquals((int)2, (int)decodeActions.size());
        Assertions.assertEquals((int)2, (Integer)((Integer)decodeActions.get(0)));
        Assertions.assertEquals((int)4, (Integer)((Integer)decodeActions.get(1)));
    }

    @Test
    public void testDeprecatedEncryptionHandlerAction() throws Exception {
        String action = "Signature Encrypt";
        List decodeActions = WSSecurityUtil.decodeHandlerAction((String)action, (WSSConfig)WSSConfig.getNewInstance());
        Assertions.assertEquals((int)2, (int)decodeActions.size());
        Assertions.assertEquals((int)2, (Integer)((HandlerAction)decodeActions.get(0)).getAction());
        Assertions.assertEquals((int)4, (Integer)((HandlerAction)decodeActions.get(1)).getAction());
    }

    @Test
    public void testNewEncryptionDerivedAction() throws Exception {
        String action = "Signature EncryptionDerived";
        List decodeActions = WSSecurityUtil.decodeAction((String)action);
        Assertions.assertEquals((int)2, (int)decodeActions.size());
        Assertions.assertEquals((int)2, (Integer)((Integer)decodeActions.get(0)));
        Assertions.assertEquals((int)65536, (Integer)((Integer)decodeActions.get(1)));
    }

    @Test
    public void testNewEncryptionHandlerDerivedAction() throws Exception {
        String action = "Signature EncryptionDerived";
        List decodeActions = WSSecurityUtil.decodeHandlerAction((String)action, (WSSConfig)WSSConfig.getNewInstance());
        Assertions.assertEquals((int)2, (int)decodeActions.size());
        Assertions.assertEquals((int)2, (Integer)((HandlerAction)decodeActions.get(0)).getAction());
        Assertions.assertEquals((int)65536, (Integer)((HandlerAction)decodeActions.get(1)).getAction());
    }

    @Test
    public void testDeprecatedEncryptionDerivedAction() throws Exception {
        String action = "Signature EncryptDerived";
        List decodeActions = WSSecurityUtil.decodeAction((String)action);
        Assertions.assertEquals((int)2, (int)decodeActions.size());
        Assertions.assertEquals((int)2, (Integer)((Integer)decodeActions.get(0)));
        Assertions.assertEquals((int)65536, (Integer)((Integer)decodeActions.get(1)));
    }

    @Test
    public void testDeprecatedEncryptionHandlerDerivedAction() throws Exception {
        String action = "Signature EncryptDerived";
        List decodeActions = WSSecurityUtil.decodeHandlerAction((String)action, (WSSConfig)WSSConfig.getNewInstance());
        Assertions.assertEquals((int)2, (int)decodeActions.size());
        Assertions.assertEquals((int)2, (Integer)((HandlerAction)decodeActions.get(0)).getAction());
        Assertions.assertEquals((int)65536, (Integer)((HandlerAction)decodeActions.get(1)).getAction());
    }
}

