/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml.ext;

import java.io.InputStream;
import java.security.KeyStore;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opensaml.xmlsec.signature.Signature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AssertionSigningTest {
    private Crypto issuerCrypto;
    private final String defaultCanonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private final String defaultRSASignatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private final String defaultDSASignatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private final String customSignatureAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    private final String customCanonicalizationAlgorithm = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private final String customSignatureDigestAlgorithm = "http://www.w3.org/2001/04/xmlenc#sha256";
    private final DocumentBuilderFactory dbf;

    public AssertionSigningTest() throws Exception {
        WSSConfig.init();
        this.issuerCrypto = new Merlin();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(AssertionSigningTest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40.jks");
        keyStore.load(input, "security".toCharArray());
        input.close();
        ((Merlin)this.issuerCrypto).setKeyStore(keyStore);
        this.dbf = DocumentBuilderFactory.newInstance();
        this.dbf.setNamespaceAware(true);
    }

    @Test
    public void testSigningWithDefaultAlgorithms() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40", "security", this.issuerCrypto, false);
        Signature signature = samlAssertion.getSaml2().getSignature();
        Assertions.assertTrue((signature.getSignatureAlgorithm().equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || signature.getSignatureAlgorithm().equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"http://www.w3.org/2001/10/xml-exc-c14n#", (Object)signature.getCanonicalizationAlgorithm());
        SAMLKeyInfo keyInfo = new SAMLKeyInfo();
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        keyInfo.setCerts(this.issuerCrypto.getX509Certificates(cryptoType));
        Document doc = this.dbf.newDocumentBuilder().newDocument();
        Element assertionElement = samlAssertion.toDOM(doc);
        doc.appendChild(assertionElement);
        samlAssertion = new SamlAssertionWrapper(assertionElement);
        samlAssertion.verifySignature(keyInfo);
    }

    @Test
    public void testSigningWithCustomAlgorithms() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40", "security", this.issuerCrypto, false, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmlenc#sha256");
        Signature signature = samlAssertion.getSaml2().getSignature();
        Assertions.assertEquals((Object)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", (Object)signature.getSignatureAlgorithm());
        Assertions.assertEquals((Object)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (Object)signature.getCanonicalizationAlgorithm());
        Document doc = this.dbf.newDocumentBuilder().newDocument();
        Element assertionElement = samlAssertion.toDOM(doc);
        doc.appendChild(assertionElement);
        String assertionString = DOM2Writer.nodeToString((Node)assertionElement);
        Assertions.assertTrue((boolean)assertionString.contains("http://www.w3.org/2001/04/xmlenc#sha256"));
        SAMLKeyInfo keyInfo = new SAMLKeyInfo();
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        keyInfo.setCerts(this.issuerCrypto.getX509Certificates(cryptoType));
        samlAssertion = new SamlAssertionWrapper(assertionElement);
        samlAssertion.verifySignature(keyInfo);
    }
}

