/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.KeyInfoBean;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.saml.WSSecSignatureSAML;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignedSamlTokenHOKTest {
    private static final Logger LOG = LoggerFactory.getLogger(SignedSamlTokenHOKTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto trustCrypto;
    private Crypto issuerCrypto;
    private Crypto userCrypto = CryptoFactory.getInstance((String)"wss40.properties");

    public SignedSamlTokenHOKTest() throws Exception {
        WSSConfig.init();
        this.issuerCrypto = new Merlin();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(SignedSamlTokenHOKTest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40_server.jks");
        keyStore.load(input, "security".toCharArray());
        input.close();
        ((Merlin)this.issuerCrypto).setKeyStore(keyStore);
        this.trustCrypto = new Merlin();
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40CA.jks");
        trustStore.load(input, "security".toCharArray());
        input.close();
        ((Merlin)this.trustCrypto).setTrustStore(trustStore);
    }

    @Test
    public void testSAML1AuthnAssertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(secHeader);
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setKeyIdentifierType(1);
        Document signedDoc = wsSign.build(this.userCrypto, samlAssertion, null, null, null);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML 1.1 Authn Assertion (key holder):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmlenc#sha256"));
        Assertions.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        WSHandlerResult results = this.verify(signedDoc, this.trustCrypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertTrue((boolean)receivedSamlAssertion.isSigned());
        Assertions.assertNotNull((Object)receivedSamlAssertion.getSignatureValue());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Header/wsse:Security/saml1:Assertion", (Object)xpath);
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        wsDataRef = (WSDataRef)refs.get(0);
        xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML1AttrAssertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        byte[] ephemeralKey = callbackHandler.getEphemeralKey();
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(secHeader);
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
        wsSign.setKeyIdentifierType(3);
        wsSign.setSecretKey(ephemeralKey);
        Document signedDoc = wsSign.build(this.userCrypto, samlAssertion, null, null, null);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML 1.1 Attr Assertion (key holder):");
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc, this.trustCrypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedAssertion);
        Assertions.assertTrue((boolean)receivedAssertion.isSigned());
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML2AuthnAssertion() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(secHeader);
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setKeyIdentifierType(1);
        Document signedDoc = wsSign.build(this.userCrypto, samlAssertion, null, null, null);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML 2 Authn Assertion (key holder):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmlenc#sha256"));
        Assertions.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        WSHandlerResult results = this.verify(signedDoc, this.trustCrypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML2AttrAssertion() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        byte[] ephemeralKey = callbackHandler.getEphemeralKey();
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(secHeader);
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
        wsSign.setKeyIdentifierType(3);
        wsSign.setSecretKey(ephemeralKey);
        Document signedDoc = wsSign.build(this.userCrypto, samlAssertion, null, null, null);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML 2 Attr Assertion (key holder):");
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc, this.trustCrypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedAssertion);
        Assertions.assertTrue((boolean)receivedAssertion.isSigned());
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML1AuthnAssertionIssuerSerial() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setCertIdentifier(KeyInfoBean.CERT_IDENTIFIER.X509_ISSUER_SERIAL);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(secHeader);
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setKeyIdentifierType(1);
        Document signedDoc = wsSign.build(this.userCrypto, samlAssertion, null, null, null);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion Issuer Serial (holder-of-key):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("X509IssuerSerial"));
        WSHandlerResult results = this.verify(signedDoc, this.userCrypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML1AuthnAssertionKeyValue() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setCertIdentifier(KeyInfoBean.CERT_IDENTIFIER.KEY_VALUE);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(secHeader);
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setKeyIdentifierType(1);
        Document signedDoc = wsSign.build(this.userCrypto, samlAssertion, null, null, null);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion Key Value (holder-of-key):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("KeyValue"));
        WSHandlerResult results = this.verify(signedDoc, this.userCrypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        assert (receivedSamlAssertion.isSigned());
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML2AuthnAssertionKeyValue() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setCertIdentifier(KeyInfoBean.CERT_IDENTIFIER.KEY_VALUE);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(secHeader);
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setKeyIdentifierType(1);
        Document signedDoc = wsSign.build(this.userCrypto, samlAssertion, null, null, null);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion Key Value (holder-of-key):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("KeyValue"));
        WSHandlerResult results = this.verify(signedDoc, this.userCrypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML1AuthnAssertionTrust() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        Crypto crypto = CryptoFactory.getInstance((String)"crypto.properties");
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("16c73ab6-b892-458f-abf5-2f875f74882e");
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        callbackHandler.setCerts(certs);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(secHeader);
        wsSign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setKeyIdentifierType(1);
        Document signedDoc = wsSign.build(crypto, samlAssertion, null, null, null);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML 1.1 Authn Assertion (key holder):");
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc, this.trustCrypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    @Disabled
    public void testSAML2Advice() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        Element adviceElement = samlAssertion.toDOM(doc);
        callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setAssertionAdviceElement(adviceElement);
        samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        byte[] ephemeralKey = callbackHandler.getEphemeralKey();
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(secHeader);
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
        wsSign.setKeyIdentifierType(3);
        wsSign.setSecretKey(ephemeralKey);
        Document signedDoc = wsSign.build(this.userCrypto, samlAssertion, null, null, null);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML 2 Attr Assertion (key holder):");
            LOG.debug(outputString);
        }
        System.out.println(outputString);
        WSHandlerResult results = this.verify(signedDoc, this.trustCrypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedAssertion);
        Assertions.assertTrue((boolean)receivedAssertion.isSigned());
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testX509DataAndKeyValue() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document keyInfoDoc = docBuilder.newDocument();
        Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        PublicKey publicKey = certs[0].getPublicKey();
        KeyInfoFactory keyInfoFactory = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig").getKeyInfoFactory();
        X509Data x509Data = keyInfoFactory.newX509Data(Collections.singletonList(certs[0]));
        KeyValue keyValue = keyInfoFactory.newKeyValue(publicKey);
        List<XMLStructure> keyInfoContent = Arrays.asList(x509Data, keyValue);
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(keyInfoContent, null);
        Element parent = keyInfoDoc.createElement("temp");
        DOMCryptoContext cryptoContext = new DOMCryptoContext(){};
        cryptoContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
        keyInfo.marshal(new DOMStructure(parent), cryptoContext);
        Element keyInfoElement = (Element)parent.getFirstChild();
        callbackHandler.setKeyInfoElement(keyInfoElement);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(secHeader);
        wsSign.setUserInfo("wss40", "security");
        wsSign.setCustomKeyInfoElement(keyInfoElement);
        Document signedDoc = wsSign.build(this.userCrypto, samlAssertion, null, null, null);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML 2 Authn Assertion (key holder):");
            LOG.debug(outputString);
        }
        RequestData data = new RequestData();
        data.setSigVerCrypto(this.userCrypto);
        ArrayList<BSPRule> ignoredRules = new ArrayList<BSPRule>();
        ignoredRules.add(BSPRule.R5417);
        ignoredRules.add(BSPRule.R5402);
        data.setIgnoredBSPRules(ignoredRules);
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        WSHandlerResult results = this.secEngine.processSecurityHeader(securityHeader, data);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML2SubjectWithComment() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        String principal = "uid=joe,ou=people<!---->o=example.com";
        callbackHandler.setSubjectName(principal);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(secHeader);
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setKeyIdentifierType(1);
        Document signedDoc = wsSign.build(this.userCrypto, samlAssertion, null, null, null);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML 2 Authn Assertion (key holder):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmlenc#sha256"));
        Assertions.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        WSHandlerResult results = this.verify(signedDoc, this.trustCrypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
        Principal receivedPrincipal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertEquals((Object)principal, (Object)receivedPrincipal.getName());
    }

    private WSHandlerResult verify(Document doc, Crypto sigCrypto) throws Exception {
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, sigCrypto, this.userCrypto);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

