/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.NameIDBean;
import org.apache.wss4j.common.saml.bean.SubjectConfirmationDataBean;
import org.apache.wss4j.common.token.SecurityTokenReference;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.CustomSamlAssertionValidator;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.common.SAMLElementCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSAMLToken;
import org.apache.wss4j.dom.validate.SamlAssertionValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.Reference;
import org.apache.xml.security.encryption.ReferenceList;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.RetrievalMethod;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.core.Conditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlTokenTest {
    private static final Logger LOG = LoggerFactory.getLogger(SamlTokenTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private static final String IP_ADDRESS = "12.34.56.78";

    public SamlTokenTest() {
        WSSConfig config = WSSConfig.getNewInstance();
        config.setValidator(WSConstants.SAML_TOKEN, (Validator)new CustomSamlAssertionValidator());
        config.setValidator(WSConstants.SAML2_TOKEN, (Validator)new CustomSamlAssertionValidator());
        this.secEngine.setWssConfig(config);
    }

    @Test
    public void testSAML1AuthnAssertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        WSHandlerResult results = this.createAndVerifyMessage(callbackHandler, true);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
        Assertions.assertNull((Object)receivedSamlAssertion.getSignatureValue());
    }

    @Test
    public void testSAML1AuthnAssertionViaElement() throws Exception {
        SAMLElementCallbackHandler callbackHandler = new SAMLElementCallbackHandler();
        callbackHandler.setIssuer("www.example.com");
        WSHandlerResult results = this.createAndVerifyMessage(callbackHandler, true);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
        Assertions.assertNull((Object)receivedSamlAssertion.getSignatureValue());
    }

    @Test
    public void testSAML1AttrAssertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setIssuer("www.example.com");
        WSHandlerResult results = this.createAndVerifyMessage(callbackHandler, true);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML1AuthzAssertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHZ);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setResource("http://resource.org");
        WSHandlerResult results = this.createAndVerifyMessage(callbackHandler, true);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2AuthnAssertion() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        WSHandlerResult results = this.createAndVerifyMessage(callbackHandler, true);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2AttrAssertion() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setIssuer("www.example.com");
        WSHandlerResult results = this.createAndVerifyMessage(callbackHandler, true);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2AuthzAssertion() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHZ);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setResource("http://resource.org");
        WSHandlerResult results = this.createAndVerifyMessage(callbackHandler, true);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSaml1Action() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, SAML1CallbackHandler> config = new TreeMap<String, SAML1CallbackHandler>();
        config.put("samlCallbackRef", new SAML1CallbackHandler());
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(8));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unsigned SAML 1.1 authentication assertion via an Action:");
            LOG.debug(outputString);
        }
        Assertions.assertFalse((boolean)outputString.contains("Signature"));
        WSHandlerResult results = this.verify(doc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML1AuthnBadIssuerAssertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example2.com");
        this.createAndVerifyMessage(callbackHandler, false);
    }

    @Test
    public void testSAML2AuthnBadIssuerAssertion() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example2.com");
        this.createAndVerifyMessage(callbackHandler, false);
    }

    @Test
    public void testSAML1SubjectNameIDFormat() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setSubjectNameIDFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress"));
        WSHandlerResult results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2SubjectNameIDFormat() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setSubjectNameIDFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress"));
        WSHandlerResult results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML1SubjectLocality() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setSubjectLocality(IP_ADDRESS, "test-dns");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains(IP_ADDRESS));
        Assertions.assertTrue((boolean)outputString.contains("test-dns"));
        WSHandlerResult results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2SessionNotOnOrAfter() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setSessionNotOnOrAfter(Instant.now().plus(Duration.ofHours(1L)));
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2.0 Authn Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("SessionNotOnOrAfter"));
        WSHandlerResult results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2SubjectLocality() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setSubjectLocality(IP_ADDRESS, "test-dns");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains(IP_ADDRESS));
        Assertions.assertTrue((boolean)outputString.contains("test-dns"));
        WSHandlerResult results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML1Resource() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHZ);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setResource("http://resource.org");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authz Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("http://resource.org"));
        WSHandlerResult results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2AttrAssertionCustomAttribute() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setIssuer("www.example.com");
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder conditionsV2Builder = (SAMLObjectBuilder)builderFactory.getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsV2Builder.buildObject();
        Instant newNotBefore = Instant.now();
        conditions.setNotBefore(newNotBefore);
        conditions.setNotOnOrAfter(newNotBefore.plus(Duration.ofMinutes(5L)));
        XMLObjectBuilder xsAnyBuilder = builderFactory.getBuilder(XSAny.TYPE_NAME);
        XSAny attributeValue = (XSAny)xsAnyBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        attributeValue.getUnknownXMLObjects().add(conditions);
        ArrayList<Object> attributeValues = new ArrayList<Object>();
        attributeValues.add(attributeValue);
        callbackHandler.setCustomAttributeValues(attributeValues);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Attr Assertion (sender vouches):");
            String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2AttrAssertionIntegerAttribute() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setIssuer("www.example.com");
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        XMLObjectBuilder xsIntegerBuilder = builderFactory.getBuilder(XSInteger.TYPE_NAME);
        XSInteger attributeValue = (XSInteger)xsIntegerBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSInteger.TYPE_NAME);
        attributeValue.setValue(Integer.valueOf(5));
        ArrayList<Object> attributeValues = new ArrayList<Object>();
        attributeValues.add(attributeValue);
        callbackHandler.setCustomAttributeValues(attributeValues);
        WSHandlerResult results = this.createAndVerifyMessage(callbackHandler, true);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2SubjectConfirmationData() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SubjectConfirmationDataBean subjectConfirmationData = new SubjectConfirmationDataBean();
        subjectConfirmationData.setAddress("http://apache.org");
        subjectConfirmationData.setInResponseTo("12345");
        subjectConfirmationData.setNotAfter(Instant.now().plus(Duration.ofMinutes(5L)));
        subjectConfirmationData.setRecipient("http://recipient.apache.org");
        callbackHandler.setSubjectConfirmationData(subjectConfirmationData);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("http://recipient.apache.org"));
        WSHandlerResult results = this.createAndVerifyMessage(callbackHandler, true);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2SubjectConfirmationNameID() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        NameIDBean nameID = new NameIDBean();
        nameID.setNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:unspecified");
        nameID.setNameQualifier("confirmationNameQualifier");
        nameID.setNameValue("confirmationNameQualifierValue");
        nameID.setSPNameQualifier("spNameQualifier");
        callbackHandler.setSubjectConfirmationNameID(nameID);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion (sender vouches):");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("confirmationNameQualifierValue"));
        WSHandlerResult results = this.createAndVerifyMessage(callbackHandler, true);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2EncryptedAssertion() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        wsSign.prepare(samlAssertion);
        Element assertionElement = wsSign.getElement();
        Element encryptedAssertionElement = doc.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
        encryptedAssertionElement.appendChild(assertionElement);
        secHeader.getSecurityHeaderElement().appendChild(encryptedAssertionElement);
        KeyGenerator keygen = KeyGenerator.getInstance("AES");
        keygen.init(128);
        SecretKey secretKey = keygen.generateKey();
        Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        Assertions.assertTrue((certs != null && certs.length > 0 && certs[0] != null ? 1 : 0) != 0);
        this.encryptElement(doc, assertionElement, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", secretKey, "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", certs[0], false, true);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        RequestData requestData = new RequestData();
        requestData.setValidateSamlSubjectConfirmation(false);
        requestData.setCallbackHandler((CallbackHandler)new KeystoreCallbackHandler());
        requestData.setDecCrypto(crypto);
        requestData.setSigVerCrypto(crypto);
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, requestData);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertNotNull((Object)receivedSamlAssertion.getElement());
        Assertions.assertTrue((boolean)"Assertion".equals(receivedSamlAssertion.getElement().getLocalName()));
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult);
    }

    @Test
    public void testSAML2EncryptedAssertionViaSeparateEncryptedKey() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        wsSign.prepare(samlAssertion);
        Element assertionElement = wsSign.getElement();
        Element encryptedAssertionElement = doc.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
        encryptedAssertionElement.appendChild(assertionElement);
        secHeader.getSecurityHeaderElement().appendChild(encryptedAssertionElement);
        KeyGenerator keygen = KeyGenerator.getInstance("AES");
        keygen.init(128);
        SecretKey secretKey = keygen.generateKey();
        Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        Assertions.assertTrue((certs != null && certs.length > 0 && certs[0] != null ? 1 : 0) != 0);
        XMLCipher cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        cipher.init(1, (Key)secretKey);
        EncryptedData builder = cipher.getEncryptedData();
        KeyInfo builderKeyInfo = builder.getKeyInfo();
        if (builderKeyInfo == null) {
            builderKeyInfo = new KeyInfo(doc);
            builderKeyInfo.getElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dsig", "http://www.w3.org/2000/09/xmldsig#");
            builder.setKeyInfo(builderKeyInfo);
        }
        String encryptedKeyId = IDGenerator.generateID(null);
        RetrievalMethod retrievalMethod = new RetrievalMethod(doc, "#" + encryptedKeyId, null, "http://www.w3.org/2001/04/xmlenc#EncryptedKey");
        builderKeyInfo.add(retrievalMethod);
        cipher.doFinal(doc, assertionElement, false);
        String id = IDGenerator.generateID(null);
        Element encryptedData = (Element)encryptedAssertionElement.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
        encryptedData.setAttributeNS(null, "Id", id);
        XMLCipher newCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        newCipher.init(3, (Key)certs[0].getPublicKey());
        EncryptedKey encryptedKey = newCipher.encryptKey(doc, (Key)secretKey);
        KeyInfo encryptedKeyKeyInfo = encryptedKey.getKeyInfo();
        if (encryptedKeyKeyInfo == null) {
            encryptedKeyKeyInfo = new KeyInfo(doc);
            encryptedKeyKeyInfo.getElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dsig", "http://www.w3.org/2000/09/xmldsig#");
            encryptedKey.setKeyInfo(encryptedKeyKeyInfo);
        }
        X509Data x509Data = new X509Data(doc);
        x509Data.addIssuerSerial(certs[0].getIssuerX500Principal().getName(), certs[0].getSerialNumber());
        encryptedKeyKeyInfo.add(x509Data);
        ReferenceList referenceList = newCipher.createReferenceList(1);
        Reference reference = referenceList.newDataReference("#" + id);
        referenceList.add(reference);
        encryptedKey.setReferenceList(referenceList);
        Element encryptedKeyElement = newCipher.martial(encryptedKey);
        encryptedKeyElement.setAttributeNS(null, "Id", encryptedKeyId);
        encryptedAssertionElement.appendChild(encryptedKeyElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        RequestData requestData = new RequestData();
        requestData.setValidateSamlSubjectConfirmation(false);
        requestData.setCallbackHandler((CallbackHandler)new KeystoreCallbackHandler());
        requestData.setDecCrypto(crypto);
        requestData.setSigVerCrypto(crypto);
        requestData.setDisableBSPEnforcement(true);
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, requestData);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertNotNull((Object)receivedSamlAssertion.getElement());
        Assertions.assertTrue((boolean)"Assertion".equals(receivedSamlAssertion.getElement().getLocalName()));
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult);
    }

    @Test
    public void testSAML2EncryptedAssertionNoSTR() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        wsSign.prepare(samlAssertion);
        Element assertionElement = wsSign.getElement();
        Element encryptedAssertionElement = doc.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
        encryptedAssertionElement.appendChild(assertionElement);
        secHeader.getSecurityHeaderElement().appendChild(encryptedAssertionElement);
        KeyGenerator keygen = KeyGenerator.getInstance("AES");
        keygen.init(128);
        SecretKey secretKey = keygen.generateKey();
        Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        Assertions.assertTrue((certs != null && certs.length > 0 && certs[0] != null ? 1 : 0) != 0);
        this.encryptElement(doc, assertionElement, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", secretKey, "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", certs[0], false, false);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        RequestData data = new RequestData();
        data.setDecCrypto(crypto);
        ArrayList<BSPRule> ignoredRules = new ArrayList<BSPRule>();
        ignoredRules.add(BSPRule.R5426);
        data.setIgnoredBSPRules(ignoredRules);
        data.setCallbackHandler((CallbackHandler)new KeystoreCallbackHandler());
        data.setValidateSamlSubjectConfirmation(false);
        WSSecurityEngine newEngine = new WSSecurityEngine();
        WSSConfig config = WSSConfig.getNewInstance();
        config.setValidator(WSConstants.SAML_TOKEN, (Validator)new CustomSamlAssertionValidator());
        config.setValidator(WSConstants.SAML2_TOKEN, (Validator)new CustomSamlAssertionValidator());
        newEngine.setWssConfig(config);
        WSHandlerResult results = newEngine.processSecurityHeader(doc, data);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertNotNull((Object)receivedSamlAssertion.getElement());
        Assertions.assertTrue((boolean)"Assertion".equals(receivedSamlAssertion.getElement().getLocalName()));
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult);
    }

    @Test
    public void testAssertionWrapper() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().newDocument();
        String assertionString = DOM2Writer.nodeToString((Node)samlAssertion.toDOM(doc));
        ByteArrayInputStream in = new ByteArrayInputStream(assertionString.getBytes());
        Document newDoc = dbf.newDocumentBuilder().parse(in);
        SamlAssertionWrapper newAssertion = new SamlAssertionWrapper(newDoc.getDocumentElement());
        String secondAssertionString = newAssertion.assertionToString();
        Assertions.assertEquals((Object)assertionString, (Object)secondAssertionString);
    }

    @Test
    public void testAssertionWrapperNoDocument() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        String assertionString = DOM2Writer.nodeToString((Node)samlAssertion.toDOM(null));
        ByteArrayInputStream in = new ByteArrayInputStream(assertionString.getBytes());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document newDoc = dbf.newDocumentBuilder().parse(in);
        SamlAssertionWrapper newAssertion = new SamlAssertionWrapper(newDoc.getDocumentElement());
        String secondAssertionString = newAssertion.assertionToString();
        Assertions.assertEquals((Object)assertionString, (Object)secondAssertionString);
    }

    @Test
    public void testRequiredSubjectConfirmationMethod() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        WSSConfig config = WSSConfig.getNewInstance();
        SamlAssertionValidator assertionValidator = new SamlAssertionValidator();
        assertionValidator.setRequiredSubjectConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        config.setValidator(WSConstants.SAML_TOKEN, (Validator)assertionValidator);
        config.setValidator(WSConstants.SAML2_TOKEN, (Validator)assertionValidator);
        WSSecurityEngine newEngine = new WSSecurityEngine();
        newEngine.setWssConfig(config);
        RequestData requestData = new RequestData();
        requestData.setValidateSamlSubjectConfirmation(false);
        newEngine.processSecurityHeader(doc, requestData);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        samlAssertion = new SamlAssertionWrapper(samlCallback);
        doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        wsSign = new WSSecSAMLToken(secHeader);
        unsignedDoc = wsSign.build(samlAssertion);
        try {
            newEngine.processSecurityHeader(unsignedDoc, null, null, null);
            Assertions.fail((String)"Failure expected on an incorrect subject confirmation method");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
    }

    @Test
    public void testStandardSubjectConfirmationMethod() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:custom");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        WSSecurityEngine newEngine = new WSSecurityEngine();
        try {
            newEngine.processSecurityHeader(unsignedDoc, null, null, null);
            Assertions.fail((String)"Failure expected on an unknown subject confirmation method");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
        WSSConfig config = WSSConfig.getNewInstance();
        SamlAssertionValidator assertionValidator = new SamlAssertionValidator();
        assertionValidator.setRequireStandardSubjectConfirmationMethod(false);
        config.setValidator(WSConstants.SAML_TOKEN, (Validator)assertionValidator);
        config.setValidator(WSConstants.SAML2_TOKEN, (Validator)assertionValidator);
        newEngine.setWssConfig(config);
        RequestData requestData = new RequestData();
        requestData.setValidateSamlSubjectConfirmation(false);
        newEngine.processSecurityHeader(doc, requestData);
    }

    @Test
    public void testUnsignedBearer() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        WSSecurityEngine newEngine = new WSSecurityEngine();
        try {
            newEngine.processSecurityHeader(unsignedDoc, null, null, null);
            Assertions.fail((String)"Failure expected on an unsigned bearer token");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
        WSSConfig config = WSSConfig.getNewInstance();
        SamlAssertionValidator assertionValidator = new SamlAssertionValidator();
        assertionValidator.setRequireBearerSignature(false);
        config.setValidator(WSConstants.SAML_TOKEN, (Validator)assertionValidator);
        config.setValidator(WSConstants.SAML2_TOKEN, (Validator)assertionValidator);
        newEngine.setWssConfig(config);
        RequestData requestData = new RequestData();
        requestData.setValidateSamlSubjectConfirmation(false);
        newEngine.processSecurityHeader(doc, requestData);
    }

    @Test
    public void testSAML2Advice() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        Element adviceElement = samlAssertion.toDOM(doc);
        callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setAssertionAdviceElement(adviceElement);
        samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("Advice"));
        WSHandlerResult results = this.verify(unsignedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2SpecialCharacter() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setIssuer("www.example.com");
        String newSubjectName = "uid=j\u00f6e,ou=people,ou=saml-demo,o=example.com";
        callbackHandler.setSubjectName(newSubjectName);
        ArrayList<Object> customAttributeValue = new ArrayList<Object>(1);
        customAttributeValue.add("j\u00f6an");
        callbackHandler.setCustomAttributeValues(customAttributeValue);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        RequestData requestData = new RequestData();
        requestData.setValidateSamlSubjectConfirmation(false);
        WSSecurityEngine newEngine = new WSSecurityEngine();
        WSHandlerResult results = newEngine.processSecurityHeader(doc, requestData);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2IssuerFormat() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setIssuerFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
        WSHandlerResult results = this.createAndVerifyMessage(callbackHandler, true);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSAML2SubjectWithComment() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        String principal = "uid=joe,ou=people<!---->o=example.com";
        callbackHandler.setSubjectName(principal);
        WSHandlerResult results = this.createAndVerifyMessage(callbackHandler, true);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
        Principal receivedPrincipal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertEquals((Object)principal, (Object)receivedPrincipal.getName());
    }

    private void encryptElement(Document document, Element elementToEncrypt, String algorithm, Key encryptingKey, String keyTransportAlgorithm, X509Certificate wrappingCert, boolean content, boolean useSecurityTokenReference) throws Exception {
        XMLCipher cipher = XMLCipher.getInstance((String)algorithm);
        cipher.init(1, encryptingKey);
        if (wrappingCert != null) {
            XMLCipher newCipher = XMLCipher.getInstance((String)keyTransportAlgorithm);
            newCipher.init(3, (Key)wrappingCert.getPublicKey());
            EncryptedKey encryptedKey = newCipher.encryptKey(document, encryptingKey);
            KeyInfo encryptedKeyKeyInfo = encryptedKey.getKeyInfo();
            if (encryptedKeyKeyInfo == null) {
                encryptedKeyKeyInfo = new KeyInfo(document);
                encryptedKeyKeyInfo.getElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dsig", "http://www.w3.org/2000/09/xmldsig#");
                encryptedKey.setKeyInfo(encryptedKeyKeyInfo);
            }
            if (useSecurityTokenReference) {
                SecurityTokenReference securityTokenReference = new SecurityTokenReference(document);
                securityTokenReference.addWSSENamespace();
                securityTokenReference.setKeyIdentifierSKI(wrappingCert, null);
                encryptedKeyKeyInfo.addUnknownElement(securityTokenReference.getElement());
            } else {
                X509Data x509Data = new X509Data(document);
                x509Data.addIssuerSerial(wrappingCert.getIssuerX500Principal().getName(), wrappingCert.getSerialNumber());
                encryptedKeyKeyInfo.add(x509Data);
            }
            EncryptedData builder = cipher.getEncryptedData();
            KeyInfo builderKeyInfo = builder.getKeyInfo();
            if (builderKeyInfo == null) {
                builderKeyInfo = new KeyInfo(document);
                builderKeyInfo.getElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dsig", "http://www.w3.org/2000/09/xmldsig#");
                builder.setKeyInfo(builderKeyInfo);
            }
            builderKeyInfo.add(encryptedKey);
        }
        cipher.doFinal(document, elementToEncrypt, content);
    }

    private WSHandlerResult createAndVerifyMessage(CallbackHandler samlCallbackHandler, boolean success) throws Exception {
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)samlCallbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        try {
            WSHandlerResult results = this.verify(unsignedDoc);
            if (!success) {
                Assertions.fail((String)"Failure expected in processing the SAML assertion");
            }
            return results;
        }
        catch (WSSecurityException ex) {
            Assertions.assertFalse((boolean)success);
            Assertions.assertTrue((boolean)ex.getMessage().contains("SAML token security failure"));
            return null;
        }
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        RequestData requestData = new RequestData();
        requestData.setValidateSamlSubjectConfirmation(false);
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, requestData);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

