/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.token.Reference;
import org.apache.wss4j.common.token.SecurityTokenReference;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecDKSign;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SamlTokenDerivedTest {
    private static final Logger LOG = LoggerFactory.getLogger(SamlTokenDerivedTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto;

    public SamlTokenDerivedTest() throws Exception {
        WSSConfig config = WSSConfig.getNewInstance();
        this.secEngine.setWssConfig(config);
        this.crypto = CryptoFactory.getInstance((String)"crypto.properties");
    }

    @Test
    public void testSAML1AuthnAssertionDerived() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        SecurityTokenReference secRefSaml = this.createSamlSTR(doc, samlAssertion, WSSConfig.getNewInstance());
        secHeader.getSecurityHeaderElement().appendChild(samlAssertion.toDOM(doc));
        secHeader.getSecurityHeaderElement().appendChild(secRefSaml.getElement());
        WSSecDKSign sigBuilder = this.createDKSign(doc, secRefSaml, secHeader);
        PrivateKey key = this.crypto.getPrivateKey("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        Document signedDoc = sigBuilder.build(key.getEncoded());
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion Derived (sender vouches):");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs.size() == 2 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
        wsDataRef = (WSDataRef)refs.get(1);
        xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Header/wsse:Security/saml1:Assertion", (Object)xpath);
    }

    private SecurityTokenReference createSamlSTR(Document doc, SamlAssertionWrapper samlAssertion, WSSConfig wssConfig) {
        SecurityTokenReference secRefSaml = new SecurityTokenReference(doc);
        String secRefID = wssConfig.getIdAllocator().createSecureId("STRSAMLId-", (Object)secRefSaml);
        secRefSaml.setID(secRefID);
        Reference ref = new Reference(doc);
        ref.setURI("#" + samlAssertion.getId());
        ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
        secRefSaml.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        secRefSaml.setReference(ref);
        return secRefSaml;
    }

    private WSSecDKSign createDKSign(Document doc, SecurityTokenReference secRefSaml, WSSecHeader secHeader) throws WSSecurityException {
        SecurityTokenReference secToken = new SecurityTokenReference(doc);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("16c73ab6-b892-458f-abf5-2f875f74882e");
        X509Certificate[] certs = this.crypto.getX509Certificates(cryptoType);
        secToken.setKeyIdentifierThumb(certs[0]);
        WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
        sigBuilder.setStrElem(secToken.getElement());
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        WSEncryptionPart encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        sigBuilder.getParts().add(encP);
        encP = new WSEncryptionPart("STRTransform", "", "Element");
        encP.setId(secRefSaml.getID());
        encP.setElement(secRefSaml.getElement());
        sigBuilder.getParts().add(encP);
        return sigBuilder;
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        RequestData requestData = new RequestData();
        requestData.setCallbackHandler(this.callbackHandler);
        requestData.setDecCrypto(this.crypto);
        requestData.setSigVerCrypto(this.crypto);
        requestData.setValidateSamlSubjectConfirmation(false);
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, requestData);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

