/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.validate.SamlAssertionValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SamlTokenCustomSignatureTest {
    private static final Logger LOG = LoggerFactory.getLogger(SamlTokenCustomSignatureTest.class);
    private Crypto crypto;

    public SamlTokenCustomSignatureTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"crypto.properties");
    }

    @Test
    public void testSAML1AuthnAssertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        Element assertionElement = samlAssertion.toDOM(doc);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        secHeader.getSecurityHeaderElement().appendChild(assertionElement);
        this.signAssertion(doc, assertionElement);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion (Bearer):");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            Assertions.fail((String)"Failure expected on a signature that doesn't conform with the signature profile");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
        this.verifyWithoutProfile(doc);
    }

    @Test
    public void testSAML1AuthnAssertionValidatorMap() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        Element assertionElement = samlAssertion.toDOM(doc);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        secHeader.getSecurityHeaderElement().appendChild(assertionElement);
        this.signAssertion(doc, assertionElement);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion (Bearer):");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            Assertions.fail((String)"Failure expected on a signature that doesn't conform with the signature profile");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
        SamlAssertionValidator validator = new SamlAssertionValidator();
        validator.setValidateSignatureAgainstProfile(false);
        HashMap<QName, SamlAssertionValidator> validatorMap = new HashMap<QName, SamlAssertionValidator>();
        validatorMap.put(WSConstants.SAML_TOKEN, validator);
        RequestData requestData = new RequestData();
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signatureVerificationPropFile", "crypto.properties");
        config.put("validatorMap", validatorMap);
        requestData.setMsgContext(config);
        requestData.setSigVerCrypto(this.crypto);
        CustomHandler handler = new CustomHandler();
        ArrayList<Integer> actions = new ArrayList<Integer>();
        actions.add(16);
        handler.receive(actions, requestData);
        WSSecurityEngine secEngine = new WSSecurityEngine();
        secEngine.processSecurityHeader(doc, requestData);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSAML2AuthnAssertion() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        Element assertionElement = samlAssertion.toDOM(doc);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        secHeader.getSecurityHeaderElement().appendChild(assertionElement);
        this.signAssertion(doc, assertionElement);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2.0 Authn Assertion (Bearer):");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            Assertions.fail((String)"Failure expected on a signature that doesn't conform with the signature profile");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
        this.verifyWithoutProfile(doc);
    }

    @Test
    public void testAddSAML1AndSign() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        Element assertionElement = samlAssertion.toDOM(doc);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        secHeader.getSecurityHeaderElement().appendChild(assertionElement);
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("Assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "Element");
        encP.setRequired(false);
        sign.getParts().add(encP);
        Document signedDoc = sign.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        this.verify(signedDoc);
    }

    @Test
    public void testAddSAML1AndSignAction() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("16c73ab6-b892-458f-abf5-2f875f74882e");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "crypto.properties");
        config.put("password", "security");
        config.put("signatureKeyIdentifier", "DirectReference");
        config.put("signatureParts", "{Element}{urn:oasis:names:tc:SAML:1.0:assertion}Assertion");
        config.put("samlCallbackRef", callbackHandler);
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        HandlerAction action = new HandlerAction(Integer.valueOf(8));
        actions.add(action);
        action = new HandlerAction(Integer.valueOf(2));
        actions.add(action);
        handler.send(doc, reqData, actions, true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message:");
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    private void signAssertion(Document doc, Element assertionElement) throws Exception {
        XMLSignature sig = new XMLSignature(doc, null, "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        assertionElement.appendChild(sig.getElement());
        Transforms transforms = new Transforms(doc);
        String filter = "here()/ancestor::ds.Signature/parent::node()/descendant-or-self::*";
        XPath2FilterContainer xpathC = XPath2FilterContainer.newInstanceIntersect((Document)doc, (String)filter);
        xpathC.setXPathNamespaceContext("dsig-xpath", "http://www.w3.org/2002/06/xmldsig-filter2");
        Element node = xpathC.getElement();
        transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", node);
        sig.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        PrivateKey privateKey = this.crypto.getPrivateKey("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sig.sign((Key)privateKey);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("16c73ab6-b892-458f-abf5-2f875f74882e");
        X509Certificate cert = this.crypto.getX509Certificates(cryptoType)[0];
        sig.addKeyInfo(cert);
        sig.checkSignatureValue(cert);
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData requestData = new RequestData();
        requestData.setDecCrypto(this.crypto);
        requestData.setSigVerCrypto(this.crypto);
        requestData.setValidateSamlSubjectConfirmation(false);
        WSHandlerResult results = secEngine.processSecurityHeader(doc, requestData);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }

    private WSHandlerResult verifyWithoutProfile(Document doc) throws Exception {
        SamlAssertionValidator validator = new SamlAssertionValidator();
        validator.setValidateSignatureAgainstProfile(false);
        WSSecurityEngine secEngine = new WSSecurityEngine();
        WSSConfig config = secEngine.getWssConfig();
        config.setValidator(WSConstants.SAML_TOKEN, (Validator)validator);
        config.setValidator(WSConstants.SAML2_TOKEN, (Validator)validator);
        WSHandlerResult results = secEngine.processSecurityHeader(doc, null, null, this.crypto);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

