/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import jakarta.xml.soap.SOAPPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.CustomSamlAssertionValidator;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.validate.Validator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SamlTokenActionTest {
    private static final Logger LOG = LoggerFactory.getLogger(SamlTokenActionTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private Crypto crypto;

    public SamlTokenActionTest() throws WSSecurityException {
        WSSConfig config = WSSConfig.getNewInstance();
        this.crypto = CryptoFactory.getInstance((String)"wss40.properties");
        config.setValidator(WSConstants.SAML_TOKEN, (Validator)new CustomSamlAssertionValidator());
        config.setValidator(WSConstants.SAML2_TOKEN, (Validator)new CustomSamlAssertionValidator());
        this.secEngine.setWssConfig(config);
    }

    @Test
    public void testAssertionAction() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        KeystoreCallbackHandler callbackHandler = new KeystoreCallbackHandler();
        SAML1CallbackHandler samlCallbackHandler = new SAML1CallbackHandler();
        samlCallbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        samlCallbackHandler.setIssuer("www.example.com");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("passwordCallbackRef", callbackHandler);
        config.put("samlCallbackRef", samlCallbackHandler);
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(8));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc, callbackHandler);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testAssertionActionWithSAAJ() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        KeystoreCallbackHandler callbackHandler = new KeystoreCallbackHandler();
        SAML1CallbackHandler samlCallbackHandler = new SAML1CallbackHandler();
        samlCallbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        samlCallbackHandler.setIssuer("www.example.com");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("passwordCallbackRef", callbackHandler);
        config.put("samlCallbackRef", samlCallbackHandler);
        reqData.setMsgContext(config);
        SOAPPart doc = SOAPUtil.toSAAJSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(8));
        handler.send((Document)doc, reqData, Collections.singletonList(action), true);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify((Document)doc, callbackHandler);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSignedAssertionAction() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        KeystoreCallbackHandler callbackHandler = new KeystoreCallbackHandler();
        SAML1CallbackHandler samlCallbackHandler = new SAML1CallbackHandler();
        samlCallbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        samlCallbackHandler.setIssuer("www.example.com");
        samlCallbackHandler.setIssuerCrypto(this.crypto);
        samlCallbackHandler.setIssuerName("wss40");
        samlCallbackHandler.setIssuerPassword("security");
        samlCallbackHandler.setSignAssertion(true);
        TreeMap<String, CallbackHandler> config = new TreeMap<String, CallbackHandler>();
        config.put("passwordCallbackRef", callbackHandler);
        config.put("samlCallbackRef", samlCallbackHandler);
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(16));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc, callbackHandler);
        Assertions.assertEquals((int)2, (int)results.getActionResults().keySet().size());
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertTrue((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testAssertionWithSignatureAction() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        KeystoreCallbackHandler callbackHandler = new KeystoreCallbackHandler();
        SAML1CallbackHandler samlCallbackHandler = new SAML1CallbackHandler();
        samlCallbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        samlCallbackHandler.setIssuer("www.example.com");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("passwordCallbackRef", callbackHandler);
        config.put("samlCallbackRef", samlCallbackHandler);
        config.put("signatureParts", "{}{urn:oasis:names:tc:SAML:1.0:assertion}Assertion;");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(8)));
        actions.add(new HandlerAction(Integer.valueOf(2)));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc, callbackHandler);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(8)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertFalse((boolean)receivedSamlAssertion.isSigned());
    }

    @Test
    public void testSignedSAML2AssertionAction() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        KeystoreCallbackHandler callbackHandler = new KeystoreCallbackHandler();
        SAML2CallbackHandler samlCallbackHandler = new SAML2CallbackHandler();
        samlCallbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        samlCallbackHandler.setIssuer("www.example.com");
        samlCallbackHandler.setSignAssertion(true);
        samlCallbackHandler.setIssuerCrypto(this.crypto);
        samlCallbackHandler.setIssuerName("wss40");
        samlCallbackHandler.setIssuerPassword("security");
        TreeMap<String, SAML2CallbackHandler> config = new TreeMap<String, SAML2CallbackHandler>();
        config.put("samlCallbackRef", samlCallbackHandler);
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(8));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc, callbackHandler);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertTrue((boolean)receivedSamlAssertion.isSigned());
    }

    private WSHandlerResult verify(Document doc, CallbackHandler callbackHandler) throws Exception {
        RequestData requestData = new RequestData();
        requestData.setCallbackHandler(callbackHandler);
        requestData.setDecCrypto(this.crypto);
        requestData.setSigVerCrypto(this.crypto);
        requestData.setValidateSamlSubjectConfirmation(false);
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, requestData);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

