/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import java.time.Duration;
import java.time.Instant;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.CustomSamlAssertionValidator;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSAMLToken;
import org.apache.wss4j.dom.validate.Validator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SamlAuthnTest {
    private static final Logger LOG = LoggerFactory.getLogger(SamlAuthnTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();

    public SamlAuthnTest() {
        WSSConfig config = WSSConfig.getNewInstance();
        config.setValidator(WSConstants.SAML_TOKEN, (Validator)new CustomSamlAssertionValidator());
        config.setValidator(WSConstants.SAML2_TOKEN, (Validator)new CustomSamlAssertionValidator());
        this.secEngine.setWssConfig(config);
    }

    @Test
    public void testSAML1AuthnAssertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        this.createAndVerifyMessage(callbackHandler, true);
    }

    @Test
    public void testSAML2AuthnAssertion() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        this.createAndVerifyMessage(callbackHandler, true);
    }

    @Test
    public void testSAML1FutureAuthnInstant() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setAuthenticationInstant(Instant.now().plus(Duration.ofMinutes(70L)));
        this.createAndVerifyMessage(callbackHandler, false);
    }

    @Test
    public void testSAML2FutureAuthnInstant() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setAuthenticationInstant(Instant.now().plus(Duration.ofMinutes(70L)));
        this.createAndVerifyMessage(callbackHandler, false);
    }

    @Test
    public void testSAML2StaleSessionNotOnOrAfter() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setSessionNotOnOrAfter(Instant.now().minus(Duration.ofMinutes(70L)));
        this.createAndVerifyMessage(callbackHandler, false);
    }

    @Test
    public void testSAML1ValidSubjectLocality() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setSubjectLocality("127.0.0.1", "xyz.ws.apache.org");
        this.createAndVerifyMessage(callbackHandler, true);
    }

    @Test
    public void testSAML2ValidSubjectLocality() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setSubjectLocality("127.0.0.1", "xyz.ws.apache.org");
        this.createAndVerifyMessage(callbackHandler, true);
    }

    @Test
    public void testSAML1InvalidSubjectLocality() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setSubjectLocality("xyz.ws.apache.org", "xyz.ws.apache.org");
        this.createAndVerifyMessage(callbackHandler, false);
    }

    @Test
    public void testSAML2InalidSubjectLocality() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        callbackHandler.setSubjectLocality("xyz.ws.apache.org", "xyz.ws.apache.org");
        this.createAndVerifyMessage(callbackHandler, false);
    }

    private void createAndVerifyMessage(CallbackHandler samlCallbackHandler, boolean success) throws Exception {
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)samlCallbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(unsignedDoc);
            if (!success) {
                Assertions.fail((String)"Failure expected in processing the SAML assertion");
            }
        }
        catch (WSSecurityException ex) {
            Assertions.assertFalse((boolean)success);
            Assertions.assertTrue((boolean)ex.getMessage().contains("SAML token security failure"));
        }
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        RequestData requestData = new RequestData();
        requestData.setValidateSamlSubjectConfirmation(false);
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, requestData);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

