/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.processor;

import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReferenceListDataRefTest {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceListDataRefTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    public ReferenceListDataRefTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testDataRefReferenceListProcessor() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        LOG.info("Before Encryption Triple DES....");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        builder.prepare(this.crypto, symmetricKey);
        WSEncryptionPart encP = new WSEncryptionPart("add", "http://ws.apache.org/counter/counter_port_type", "Element");
        builder.getParts().add(encP);
        Element refs = builder.encrypt(symmetricKey);
        builder.addExternalRefElement(refs);
        builder.prependToHeader();
        builder.prependBSTElementToHeader();
        Document encryptedDoc = doc;
        LOG.info("After Encryption Triple DES....");
        this.checkDataRef(encryptedDoc);
    }

    private void checkDataRef(Document doc) throws Exception {
        WSHandlerResult wsResults = this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
        boolean found = false;
        for (int i = 0; i < wsResults.getResults().size(); ++i) {
            List dataRefs;
            WSSecurityEngineResult wsSecEngineResult = (WSSecurityEngineResult)wsResults.getResults().get(i);
            int action = (Integer)wsSecEngineResult.get((Object)"action");
            if (action != 4 || (dataRefs = (List)wsSecEngineResult.get((Object)"data-ref-uris")) == null || dataRefs.isEmpty()) continue;
            for (Object obj : dataRefs) {
                Assertions.assertTrue((boolean)(obj instanceof WSDataRef));
                WSDataRef dataRef = (WSDataRef)obj;
                Assertions.assertEquals((Object)"add", (Object)dataRef.getName().getLocalPart());
                Assertions.assertEquals((Object)"http://ws.apache.org/counter/counter_port_type", (Object)dataRef.getName().getNamespaceURI());
                Assertions.assertNotNull((Object)dataRef.getWsuId());
                Assertions.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc", (Object)dataRef.getAlgorithm());
                found = true;
            }
        }
        Assertions.assertTrue((boolean)found);
    }
}

