/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.misc;

import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;

public class SecurityHeaderTest {
    private static final String DUPLICATE_NULL_ACTOR_MSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Header><wsse:Security SOAP-ENV:mustUnderstand=\"1\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"></wsse:Security><wsse:Security SOAP-ENV:mustUnderstand=\"1\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"></wsse:Security></SOAP-ENV:Header><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body>\r\n       \r\n</SOAP-ENV:Envelope>";
    private static final String DUPLICATE_ACTOR_MSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Header><wsse:Security SOAP-ENV:actor=\"user\" SOAP-ENV:mustUnderstand=\"1\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"></wsse:Security><wsse:Security SOAP-ENV:actor=\"user\" SOAP-ENV:mustUnderstand=\"1\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"></wsse:Security></SOAP-ENV:Header><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body>\r\n       \r\n</SOAP-ENV:Envelope>";
    private static final String TWO_ACTOR_MSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Header><wsse:Security SOAP-ENV:mustUnderstand=\"1\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"></wsse:Security><wsse:Security SOAP-ENV:actor=\"user\" SOAP-ENV:mustUnderstand=\"1\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"></wsse:Security></SOAP-ENV:Header><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body>\r\n       \r\n</SOAP-ENV:Envelope>";
    private WSSecurityEngine secEngine = new WSSecurityEngine();

    @Test
    public void testDuplicateNullActor() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)DUPLICATE_NULL_ACTOR_MSG);
        try {
            this.secEngine.processSecurityHeader(doc, null, null, null);
            Assertions.fail((String)"Failure expected on a null actor");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDuplicateActor() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)DUPLICATE_ACTOR_MSG);
        try {
            this.secEngine.processSecurityHeader(doc, "user", null, null);
            Assertions.fail((String)"Failure expected on a duplicate actor");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTwoActors() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)TWO_ACTOR_MSG);
        this.secEngine.processSecurityHeader(doc, null, null, null);
        this.secEngine.processSecurityHeader(doc, "user", null, null);
    }
}

