/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.misc;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.SAMLTokenPrincipal;
import org.apache.wss4j.common.principal.UsernameTokenPrincipal;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.token.BinarySecurity;
import org.apache.wss4j.common.token.X509Security;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.common.UsernamePasswordCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSAMLToken;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PrincipalTest {
    private static final Logger LOG = LoggerFactory.getLogger(PrincipalTest.class);
    private CallbackHandler callbackHandler = new UsernamePasswordCallbackHandler();

    @Test
    public void testUsernameToken() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setUserInfo("wernerd", "verySecret");
        Document signedDoc = builder.build();
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc, null);
        Principal principal = (Principal)((WSSecurityEngineResult)results.getResults().get(0)).get((Object)"principal");
        Assertions.assertTrue((boolean)(principal instanceof UsernameTokenPrincipal));
        Assertions.assertTrue((boolean)"wernerd".equals(principal.getName()));
        UsernameTokenPrincipal userPrincipal = (UsernameTokenPrincipal)principal;
        Assertions.assertNotNull((Object)userPrincipal.getCreatedTime());
        Assertions.assertNotNull((Object)userPrincipal.getNonce());
        Assertions.assertNotNull((Object)userPrincipal.getPassword());
        Assertions.assertTrue((boolean)userPrincipal.isPasswordDigest());
        Assertions.assertTrue((boolean)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(userPrincipal.getPasswordType()));
    }

    @Test
    public void testTransformedUsernameToken() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setUserInfo("wernerd", "verySecret");
        Document signedDoc = builder.build();
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc, new DummyValidator(), WSConstants.USERNAME_TOKEN, null);
        Principal principal = (Principal)((WSSecurityEngineResult)results.getResults().get(0)).get((Object)"principal");
        Assertions.assertTrue((boolean)(principal instanceof SAMLTokenPrincipal));
        Assertions.assertTrue((boolean)principal.getName().contains("uid=joe"));
        Assertions.assertNotNull((Object)((SAMLTokenPrincipal)principal).getToken());
    }

    @Test
    public void testSAMLToken() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(unsignedDoc, null);
        List samlResults = (List)results.getActionResults().get(8);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)samlResults.get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertTrue((boolean)(principal instanceof SAMLTokenPrincipal));
        Assertions.assertTrue((boolean)principal.getName().contains("uid=joe"));
        Assertions.assertNotNull((Object)((SAMLTokenPrincipal)principal).getToken());
    }

    @Test
    public void testSAML2Token() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(unsignedDoc, null);
        List samlResults = (List)results.getActionResults().get(8);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)samlResults.get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertTrue((boolean)(principal instanceof SAMLTokenPrincipal));
        Assertions.assertTrue((boolean)principal.getName().contains("uid=joe"));
        Assertions.assertNotNull((Object)((SAMLTokenPrincipal)principal).getToken());
    }

    @Test
    public void testTransformedSAMLToken() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSAMLToken wsSign = new WSSecSAMLToken(secHeader);
        Document unsignedDoc = wsSign.build(samlAssertion);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(unsignedDoc, new DummyValidator(), WSConstants.SAML_TOKEN, null);
        List samlResults = (List)results.getActionResults().get(8);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)samlResults.get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertTrue((boolean)(principal instanceof SAMLTokenPrincipal));
        Assertions.assertTrue((boolean)principal.getName().contains("uid=joe"));
        Assertions.assertNotNull((Object)((SAMLTokenPrincipal)principal).getToken());
    }

    @Test
    public void testBinarySecurityToken() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        X509Security bst = new X509Security(doc);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        bst.setX509Certificate(certs[0]);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeaderElement(), (Element)bst.getElement());
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc, new DummyValidator(), WSConstants.BINARY_TOKEN, crypto);
        List bstResults = (List)results.getActionResults().get(4096);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)bstResults.get(0);
        BinarySecurity token = (BinarySecurity)actionResult.get((Object)"binary-security-token");
        Assertions.assertNotNull((Object)token);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertTrue((boolean)(principal instanceof SAMLTokenPrincipal));
        Assertions.assertTrue((boolean)principal.getName().contains("uid=joe"));
        Assertions.assertNotNull((Object)((SAMLTokenPrincipal)principal).getToken());
    }

    private WSHandlerResult verify(Document doc, Crypto crypto) throws Exception {
        return this.verify(doc, null, null, crypto);
    }

    private WSHandlerResult verify(Document doc, Validator validator, QName validatorName, Crypto crypto) throws Exception {
        RequestData requestData = new RequestData();
        requestData.setCallbackHandler(this.callbackHandler);
        requestData.setDecCrypto(crypto);
        requestData.setSigVerCrypto(crypto);
        requestData.setValidateSamlSubjectConfirmation(false);
        WSSecurityEngine secEngine = new WSSecurityEngine();
        WSSConfig config = WSSConfig.getNewInstance();
        secEngine.setWssConfig(config);
        if (validator != null && validatorName != null) {
            config.setValidator(validatorName, validator);
        }
        return secEngine.processSecurityHeader(doc, requestData);
    }

    private static class DummyValidator
    implements Validator {
        private DummyValidator() {
        }

        public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
            try {
                SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
                callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
                callbackHandler.setIssuer("www.example.com");
                SAMLCallback samlCallback = new SAMLCallback();
                SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
                SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
                credential.setTransformedToken(samlAssertion);
                return credential;
            }
            catch (Exception ex) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE);
            }
        }
    }
}

