/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.misc;

import java.io.IOException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.bsp.BSPEnforcer;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.token.Reference;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FaultCodeTest
implements CallbackHandler {
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    public FaultCodeTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testFailedCheck() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40", "security");
        builder.setKeyIdentifierType(1);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(this.crypto, symmetricKey);
        try {
            this.verify(encryptedDoc);
            Assertions.fail((String)"Failure expected with a bad password");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
            Assertions.assertEquals((Object)"The private key for the supplied alias does not exist in the keystore", (Object)ex.getMessage());
            QName faultCode = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "FailedCheck");
            Assertions.assertTrue((boolean)ex.getFaultCode().equals(faultCode));
        }
    }

    @Test
    public void testUnsupportedAlgorithm() throws Exception {
        try {
            this.secEngine.getWssConfig();
            KeyUtils.getCipherInstance((String)"Bad Algorithm");
            Assertions.fail((String)"Failure expected on an unsupported algorithm");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM ? 1 : 0) != 0);
            Assertions.assertEquals((Object)"unsupported key transport encryption algorithm: No such algorithm: \"Bad Algorithm\"", (Object)ex.getMessage());
            QName faultCode = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UnsupportedAlgorithm");
            Assertions.assertTrue((boolean)ex.getFaultCode().equals(faultCode));
        }
    }

    @Test
    public void testMessageExpired() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecTimestamp builder = new WSSecTimestamp(secHeader);
        builder.setTimeToLive(-1);
        Document timestampedDoc = builder.build();
        try {
            this.verify(timestampedDoc);
            Assertions.fail((String)"Failure expected on an expired message");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
            Assertions.assertEquals((Object)"Invalid timestamp: The message timestamp has expired", (Object)ex.getMessage());
            QName faultCode = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "MessageExpired");
            Assertions.assertTrue((boolean)ex.getFaultCode().equals(faultCode));
        }
    }

    @Test
    public void testFailedAuthentication() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.addCreated();
        builder.addNonce();
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        Document timestampedDoc = builder.build();
        try {
            this.verify(timestampedDoc);
            Assertions.fail((String)"Failure expected on a bad password");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
            Assertions.assertEquals((Object)"The security token could not be authenticated or authorized", (Object)ex.getMessage());
            QName faultCode = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "FailedAuthentication");
            Assertions.assertTrue((boolean)ex.getFaultCode().equals(faultCode));
        }
    }

    @Test
    public void testInvalidSecurityToken() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.addCreated();
        builder.addNonce();
        builder.setUserInfo(null, "security");
        builder.build();
        try {
            new UsernameToken(doc.getDocumentElement(), false, new BSPEnforcer());
            Assertions.fail((String)"Failure expected on an invalid security token");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN ? 1 : 0) != 0);
            Assertions.assertEquals((Object)"Bad element, expected \"{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd}UsernameToken\" while got \"{http://schemas.xmlsoap.org/soap/envelope/}Envelope\"", (Object)ex.getMessage());
            QName faultCode = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurityToken");
            Assertions.assertTrue((boolean)ex.getFaultCode().equals(faultCode));
        }
    }

    @Test
    public void testInvalidSecurity() throws Exception {
        try {
            new Reference((Element)null);
            Assertions.fail((String)"Failure expected on processing the security header");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
            Assertions.assertEquals((Object)"<Reference> token could not be retrieved", (Object)ex.getMessage());
            QName faultCode = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "InvalidSecurity");
            Assertions.assertTrue((boolean)ex.getFaultCode().equals(faultCode));
        }
    }

    private void verify(Document doc) throws Exception {
        this.secEngine.processSecurityHeader(doc, null, (CallbackHandler)this, this.crypto);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof WSPasswordCallback)) {
                throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
            }
            WSPasswordCallback pc = (WSPasswordCallback)callback;
            pc.setPassword("securit");
        }
    }
}

