/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message.token;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.common.UsernamePasswordCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class WCFUsernameTokenTest {
    private static final Logger LOG = LoggerFactory.getLogger(WCFUsernameTokenTest.class);
    private static final String SOAPUTMSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Header><wsse:Security SOAP-ENV:mustUnderstand=\"1\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"><wsse:UsernameToken wsu:Id=\"UsernameToken-29477163\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"><wsse:Username>wernerd</wsse:Username><wsse:Password wsse:Type=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText\">verySecret</wsse:Password></wsse:UsernameToken></wsse:Security></SOAP-ENV:Header><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body>\r\n       \r\n</SOAP-ENV:Envelope>";
    private CallbackHandler callbackHandler = new UsernamePasswordCallbackHandler();

    @Test
    public void testNamespaceQualifiedTypeRejected() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPUTMSG);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message with UserNameToken PW Digest:");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            Assertions.fail((String)"Failure expected on a bad password type");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNamespaceQualifiedTypeAccepted() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPUTMSG);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message with UserNameToken PW Digest:");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        RequestData requestData = new RequestData();
        requestData.setAllowNamespaceQualifiedPasswordTypes(true);
        requestData.setWssConfig(WSSConfig.getNewInstance());
        requestData.setIgnoredBSPRules(Collections.singletonList(BSPRule.R4201));
        this.verify(doc, requestData);
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        return this.verify(doc, new ArrayList<BSPRule>(0));
    }

    private WSHandlerResult verify(Document doc, List<BSPRule> ignoredRules) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData requestData = new RequestData();
        requestData.setIgnoredBSPRules(ignoredRules);
        requestData.setCallbackHandler(this.callbackHandler);
        return secEngine.processSecurityHeader(doc, requestData);
    }

    private WSHandlerResult verify(Document doc, RequestData requestData) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        requestData.setCallbackHandler(this.callbackHandler);
        return secEngine.processSecurityHeader(doc, requestData);
    }
}

