/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message.token;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.token.Reference;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ReferenceTest {
    private static final String TEST_REFERENCE_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wss:Reference xmlns:wss=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" ValueType=\"TheValueType\" URI=\"TheURI\" />";
    private static final String BOGUS_REFERENCE_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wss:Reference xmlns:wss=\"http://something-completely-different\" ValueType=\"TheValueType\" URI=\"TheURI\" />";
    private Reference ref = new Reference(ReferenceTest.createReferenceDocument("<?xml version=\"1.0\" encoding=\"UTF-8\"?><wss:Reference xmlns:wss=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" ValueType=\"TheValueType\" URI=\"TheURI\" />", "test", "equalscheck").getDocumentElement());
    private Reference refEqual = new Reference(ReferenceTest.createReferenceDocument("<?xml version=\"1.0\" encoding=\"UTF-8\"?><wss:Reference xmlns:wss=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" ValueType=\"TheValueType\" URI=\"TheURI\" />", "test", "equalscheck").getDocumentElement());
    private Reference refNotEqual = new Reference(ReferenceTest.createReferenceDocument("<?xml version=\"1.0\" encoding=\"UTF-8\"?><wss:Reference xmlns:wss=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" ValueType=\"TheValueType\" URI=\"TheURI\" />", "test", "unequalscheck").getDocumentElement());

    public ReferenceTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testConstructor() throws Exception {
        try {
            new Reference((Element)null);
            Assertions.fail((String)"Expected failure on null Element passed to ctor");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        try {
            new Reference(ReferenceTest.createReferenceDocument(BOGUS_REFERENCE_TEMPLATE, "foo", "bar").getDocumentElement());
            Assertions.fail((String)"Expected failure on bogus template");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
        new Reference(ReferenceTest.createReferenceDocument(TEST_REFERENCE_TEMPLATE, "foo", "bar"));
        new Reference(ReferenceTest.createReferenceDocument(TEST_REFERENCE_TEMPLATE, "foo", "bar").getDocumentElement());
    }

    @Test
    public void testAccessors() throws Exception {
        Reference ref = new Reference(ReferenceTest.createReferenceDocument(TEST_REFERENCE_TEMPLATE, "foo", "bar").getDocumentElement());
        Assertions.assertEquals((Object)ref.getValueType(), (Object)"foo");
        Assertions.assertEquals((Object)ref.getURI(), (Object)"bar");
    }

    @Test
    public void testEquals() throws Exception {
        Assertions.assertTrue((boolean)this.ref.equals((Object)this.refEqual));
        Assertions.assertTrue((boolean)this.refEqual.equals((Object)this.ref));
        Assertions.assertFalse((boolean)this.ref.equals((Object)this.refNotEqual));
        Assertions.assertFalse((boolean)this.ref.equals(null));
        Assertions.assertFalse((boolean)"string".equals(this.ref));
    }

    @Test
    public void testHashcode() throws Exception {
        Assertions.assertEquals((int)this.ref.hashCode(), (int)this.refEqual.hashCode());
        Assertions.assertFalse((this.ref.hashCode() == this.refNotEqual.hashCode() ? 1 : 0) != 0);
    }

    private static Document createReferenceDocument(String template, String valueType, String uri) throws ParserConfigurationException, SAXException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(template.replaceFirst("TheValueType", valueType).replaceFirst("TheURI", uri).getBytes());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(in);
    }
}

