/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.AttachmentCallbackHandler;
import org.apache.wss4j.dom.message.WSSecDKEncrypt;
import org.apache.wss4j.dom.message.WSSecDKSign;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XOPAttachmentTest {
    private static final String SOAP_BODY = "<add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add>";
    private static final String SOAP_HEADER_MSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Header>       <foo:bar1 xmlns:foo=\"urn:foo.bar\" >baz1</foo:bar1>       <foo:foobar xmlns:foo=\"urn:foo.bar\" >baz</foo:foobar>       <foo:bar2 xmlns:foo=\"urn:foo.bar\" >baz2</foo:bar2>   </soapenv:Header>   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\"></ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    private static final Logger LOG = LoggerFactory.getLogger(XOPAttachmentTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private Crypto crypto;

    public XOPAttachmentTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance();
    }

    protected byte[] readInputStream(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int read = 0;
            byte[] buf = new byte[4096];
            while ((read = inputStream.read(buf)) != -1) {
                byteArrayOutputStream.write(buf, 0, read);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    @Test
    public void testManualEncryptedSOAPBody() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        encrypt.getParts().add(new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", "Content"));
        encrypt.getParts().add(new WSEncryptionPart("cid:Attachments", "Content"));
        String attachmentId = UUID.randomUUID().toString();
        Attachment attachment = new Attachment();
        attachment.setId(attachmentId);
        attachment.setSourceStream((InputStream)new ByteArrayInputStream(SOAP_BODY.getBytes(StandardCharsets.UTF_8)));
        AttachmentCallbackHandler attachmentCallbackHandler = new AttachmentCallbackHandler(Collections.singletonList(attachment));
        encrypt.setAttachmentCallbackHandler((CallbackHandler)attachmentCallbackHandler);
        List<Attachment> encryptedAttachments = attachmentCallbackHandler.getResponseAttachments();
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        Element soapBody = WSSecurityUtil.findBodyElement((Document)encryptedDoc);
        Assertions.assertNotNull((Object)soapBody);
        Element encryptedData = XMLUtils.getDirectChildElement((Node)soapBody, (String)"EncryptedData", (String)"http://www.w3.org/2001/04/xmlenc#");
        encryptedData.removeAttributeNS(null, "Type");
        Element cipherData = XMLUtils.getDirectChildElement((Node)encryptedData, (String)"CipherData", (String)"http://www.w3.org/2001/04/xmlenc#");
        Assertions.assertNotNull((Object)cipherData);
        Element cipherValue = XMLUtils.getDirectChildElement((Node)cipherData, (String)"CipherValue", (String)"http://www.w3.org/2001/04/xmlenc#");
        Assertions.assertNotNull((Object)cipherValue);
        XMLUtils.setNamespace((Element)cipherValue, (String)"http://www.w3.org/2004/08/xop/include", (String)"xop");
        Element cipherValueChild = encryptedDoc.createElementNS("http://www.w3.org/2004/08/xop/include", "Include");
        cipherValueChild.setAttributeNS(null, "href", "cid:" + encryptedAttachments.get(0).getId());
        cipherValue.replaceChild(cipherValueChild, cipherValue.getFirstChild());
        Element securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock((Document)encryptedDoc, (Element)encryptedDoc.getDocumentElement(), (boolean)false);
        Element encryptedAttachmentData = XMLUtils.getDirectChildElement((Node)securityHeader, (String)"EncryptedData", (String)"http://www.w3.org/2001/04/xmlenc#");
        Assertions.assertNotNull((Object)encryptedAttachmentData);
        String encryptedDataId = encryptedAttachmentData.getAttributeNS(null, "Id");
        securityHeader.removeChild(encryptedAttachmentData);
        Element encryptedKey = XMLUtils.getDirectChildElement((Node)securityHeader, (String)"EncryptedKey", (String)"http://www.w3.org/2001/04/xmlenc#");
        Assertions.assertNotNull((Object)encryptedKey);
        Element referenceList = XMLUtils.getDirectChildElement((Node)encryptedKey, (String)"ReferenceList", (String)"http://www.w3.org/2001/04/xmlenc#");
        Assertions.assertNotNull((Object)referenceList);
        for (Node child = referenceList.getFirstChild(); child != null; child = child.getNextSibling()) {
            String uri;
            if (!(child instanceof Element) || !"DataReference".equals(child.getLocalName()) || !"http://www.w3.org/2001/04/xmlenc#".equals(child.getNamespaceURI()) || !(uri = ((Element)child).getAttributeNS(null, "URI")).equals("#" + encryptedDataId)) continue;
            referenceList.removeChild(child);
            break;
        }
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        attachmentCallbackHandler = new AttachmentCallbackHandler(encryptedAttachments);
        this.verify(encryptedDoc, attachmentCallbackHandler);
        String processedDoc = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        Assertions.assertTrue((boolean)processedDoc.contains(SOAP_BODY));
    }

    @Test
    public void testEncryptedSOAPBody() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        AttachmentCallbackHandler outboundAttachmentCallback = new AttachmentCallbackHandler();
        encrypt.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        encrypt.setStoreBytesInAttachment(true);
        encrypt.getParts().add(new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", "Content"));
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        List<Attachment> encryptedAttachments = outboundAttachmentCallback.getResponseAttachments();
        Assertions.assertNotNull(encryptedAttachments);
        Assertions.assertTrue((encryptedAttachments.size() == 2 ? 1 : 0) != 0);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        AttachmentCallbackHandler inboundAttachmentCallback = new AttachmentCallbackHandler(encryptedAttachments);
        this.verify(encryptedDoc, inboundAttachmentCallback);
        String processedDoc = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        Assertions.assertTrue((boolean)processedDoc.contains(SOAP_BODY));
    }

    @Test
    public void testEncryptedSOAPBodyURLEncoding() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        AttachmentCallbackHandler outboundAttachmentCallback = new AttachmentCallbackHandler();
        encrypt.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        encrypt.setStoreBytesInAttachment(true);
        encrypt.getParts().add(new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", "Content"));
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        List<Attachment> encryptedAttachments = outboundAttachmentCallback.getResponseAttachments();
        Assertions.assertNotNull(encryptedAttachments);
        Assertions.assertTrue((encryptedAttachments.size() == 2 ? 1 : 0) != 0);
        String newId = "http://tempuri.org/1/636966400494014846";
        String oldId = encryptedAttachments.get(1).getId();
        encryptedAttachments.get(1).setId(newId);
        List xopElements = XMLUtils.findElements((Node)doc.getDocumentElement(), (String)"Include", (String)"http://www.w3.org/2004/08/xop/include");
        for (Element xop : xopElements) {
            if (!xop.hasAttribute("href") || !xop.getAttributeNS(null, "href").equals("cid:" + oldId)) continue;
            xop.setAttributeNS(null, "href", "cid:" + URLEncoder.encode(newId, StandardCharsets.UTF_8.name()));
        }
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        AttachmentCallbackHandler inboundAttachmentCallback = new AttachmentCallbackHandler(encryptedAttachments);
        this.verify(encryptedDoc, inboundAttachmentCallback);
        String processedDoc = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        Assertions.assertTrue((boolean)processedDoc.contains(SOAP_BODY));
    }

    @Test
    public void testSignedSOAPBody() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(1);
        AttachmentCallbackHandler outboundAttachmentCallback = new AttachmentCallbackHandler();
        builder.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        builder.setStoreBytesInAttachment(true);
        Document signedDoc = builder.build(this.crypto);
        List<Attachment> signedAttachments = outboundAttachmentCallback.getResponseAttachments();
        Assertions.assertNotNull(signedAttachments);
        Assertions.assertTrue((signedAttachments.size() == 1 ? 1 : 0) != 0);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        AttachmentCallbackHandler inboundAttachmentCallback = new AttachmentCallbackHandler(signedAttachments);
        this.verify(signedDoc, inboundAttachmentCallback);
    }

    @Test
    public void testSignedSOAPBodyAndBinarySecurityToken() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(2);
        builder.setIncludeSignatureToken(true);
        AttachmentCallbackHandler outboundAttachmentCallback = new AttachmentCallbackHandler();
        builder.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        builder.setStoreBytesInAttachment(true);
        Document signedDoc = builder.build(this.crypto);
        List<Attachment> signedAttachments = outboundAttachmentCallback.getResponseAttachments();
        Assertions.assertNotNull(signedAttachments);
        Assertions.assertTrue((signedAttachments.size() == 1 ? 1 : 0) != 0);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        AttachmentCallbackHandler inboundAttachmentCallback = new AttachmentCallbackHandler(signedAttachments);
        this.verify(signedDoc, inboundAttachmentCallback);
    }

    @Test
    public void testEncryptedHeaderAsEncryptedData() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAP_HEADER_MSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        AttachmentCallbackHandler outboundAttachmentCallback = new AttachmentCallbackHandler();
        encrypt.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        encrypt.setStoreBytesInAttachment(true);
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        encrypt.getParts().add(new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", "Content"));
        encrypt.getParts().add(encP);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        List<Attachment> encryptedAttachments = outboundAttachmentCallback.getResponseAttachments();
        Assertions.assertNotNull(encryptedAttachments);
        Assertions.assertTrue((encryptedAttachments.size() == 3 ? 1 : 0) != 0);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        AttachmentCallbackHandler inboundAttachmentCallback = new AttachmentCallbackHandler(encryptedAttachments);
        this.verify(encryptedDoc, inboundAttachmentCallback);
    }

    @Test
    public void testEncryptedHeaderasEncryptedHeader() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAP_HEADER_MSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        AttachmentCallbackHandler outboundAttachmentCallback = new AttachmentCallbackHandler();
        encrypt.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        encrypt.setStoreBytesInAttachment(true);
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "Header");
        encrypt.getParts().add(new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", "Content"));
        encrypt.getParts().add(encP);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        List<Attachment> encryptedAttachments = outboundAttachmentCallback.getResponseAttachments();
        Assertions.assertNotNull(encryptedAttachments);
        Assertions.assertTrue((encryptedAttachments.size() == 3 ? 1 : 0) != 0);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        AttachmentCallbackHandler inboundAttachmentCallback = new AttachmentCallbackHandler(encryptedAttachments);
        this.verify(encryptedDoc, inboundAttachmentCallback);
    }

    @Test
    public void testDerivedEncryptedSOAPBody() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        AttachmentCallbackHandler outboundAttachmentCallback = new AttachmentCallbackHandler();
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey(secHeader);
        encrKeyBuilder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e");
        encrKeyBuilder.setKeyIdentifierType(8);
        encrKeyBuilder.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        encrKeyBuilder.setStoreBytesInAttachment(true);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        encrKeyBuilder.prepare(this.crypto, symmetricKey);
        byte[] ek = symmetricKey.getEncoded();
        String tokenIdentifier = encrKeyBuilder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setTokenIdentifier(tokenIdentifier);
        encrBuilder.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        encrBuilder.setStoreBytesInAttachment(true);
        Document encryptedDoc = encrBuilder.build(ek);
        encrKeyBuilder.prependToHeader();
        encrKeyBuilder.prependBSTElementToHeader();
        List<Attachment> encryptedAttachments = outboundAttachmentCallback.getResponseAttachments();
        Assertions.assertNotNull(encryptedAttachments);
        Assertions.assertTrue((encryptedAttachments.size() == 2 ? 1 : 0) != 0);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        AttachmentCallbackHandler inboundAttachmentCallback = new AttachmentCallbackHandler(encryptedAttachments);
        this.verify(encryptedDoc, inboundAttachmentCallback);
        String processedDoc = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        Assertions.assertTrue((boolean)processedDoc.contains(SOAP_BODY));
    }

    @Test
    public void testDerivedSignedSOAPBody() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        AttachmentCallbackHandler outboundAttachmentCallback = new AttachmentCallbackHandler();
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey(secHeader);
        encrKeyBuilder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e");
        encrKeyBuilder.setKeyIdentifierType(8);
        encrKeyBuilder.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        encrKeyBuilder.setStoreBytesInAttachment(true);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        encrKeyBuilder.prepare(this.crypto, symmetricKey);
        byte[] ek = symmetricKey.getEncoded();
        String tokenIdentifier = encrKeyBuilder.getId();
        WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
        sigBuilder.setTokenIdentifier(tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        sigBuilder.setStoreBytesInAttachment(true);
        Document signedDoc = sigBuilder.build(ek);
        encrKeyBuilder.prependToHeader();
        encrKeyBuilder.prependBSTElementToHeader();
        List<Attachment> signedAttachments = outboundAttachmentCallback.getResponseAttachments();
        Assertions.assertNotNull(signedAttachments);
        Assertions.assertTrue((signedAttachments.size() == 1 ? 1 : 0) != 0);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        AttachmentCallbackHandler inboundAttachmentCallback = new AttachmentCallbackHandler(signedAttachments);
        this.verify(signedDoc, inboundAttachmentCallback);
        String processedDoc = XMLUtils.prettyDocumentToString((Document)signedDoc);
        Assertions.assertTrue((boolean)processedDoc.contains(SOAP_BODY));
    }

    @Test
    public void testSignedEncryptedSOAPBody() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        AttachmentCallbackHandler outboundAttachmentCallback = new AttachmentCallbackHandler();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(1);
        builder.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        builder.setStoreBytesInAttachment(true);
        builder.getParts().add(new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", "Content"));
        builder.build(this.crypto);
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        encrypt.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        encrypt.setStoreBytesInAttachment(true);
        encrypt.getParts().add(new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", "Content"));
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        List<Attachment> encryptedAttachments = outboundAttachmentCallback.getResponseAttachments();
        Assertions.assertNotNull(encryptedAttachments);
        Assertions.assertTrue((encryptedAttachments.size() == 3 ? 1 : 0) != 0);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        AttachmentCallbackHandler inboundAttachmentCallback = new AttachmentCallbackHandler(encryptedAttachments);
        this.verify(encryptedDoc, inboundAttachmentCallback);
        String processedDoc = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        Assertions.assertTrue((boolean)processedDoc.contains(SOAP_BODY));
    }

    @Test
    public void testSignedEncryptedSOAPBodyViaHandler() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("16c73ab6-b892-458f-abf5-2f875f74882e");
        AttachmentCallbackHandler outboundAttachmentCallback = new AttachmentCallbackHandler();
        reqData.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("signaturePropFile", "crypto.properties");
        config.put("encryptionPropFile", "crypto.properties");
        config.put("signatureKeyIdentifier", "DirectReference");
        config.put("password", "security");
        config.put("storeBytesInAttachment", "true");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(2)));
        actions.add(new HandlerAction(Integer.valueOf(4)));
        handler.send(doc, reqData, actions, true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message:");
            LOG.debug(outputString);
        }
        List<Attachment> encryptedAttachments = outboundAttachmentCallback.getResponseAttachments();
        Assertions.assertNotNull(encryptedAttachments);
        Assertions.assertTrue((encryptedAttachments.size() == 3 ? 1 : 0) != 0);
        AttachmentCallbackHandler inboundAttachmentCallback = new AttachmentCallbackHandler(encryptedAttachments);
        this.verify(doc, inboundAttachmentCallback);
        String processedDoc = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)processedDoc.contains(SOAP_BODY));
    }

    @Test
    public void testEncryptedSignedSOAPBodyViaHandler() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("16c73ab6-b892-458f-abf5-2f875f74882e");
        AttachmentCallbackHandler outboundAttachmentCallback = new AttachmentCallbackHandler();
        reqData.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("signaturePropFile", "crypto.properties");
        config.put("encryptionPropFile", "crypto.properties");
        config.put("signatureKeyIdentifier", "DirectReference");
        config.put("password", "security");
        config.put("storeBytesInAttachment", "true");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(4)));
        actions.add(new HandlerAction(Integer.valueOf(2)));
        handler.send(doc, reqData, actions, true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message:");
            LOG.debug(outputString);
        }
        List<Attachment> encryptedAttachments = outboundAttachmentCallback.getResponseAttachments();
        Assertions.assertNotNull(encryptedAttachments);
        Assertions.assertTrue((boolean)encryptedAttachments.isEmpty());
        AttachmentCallbackHandler inboundAttachmentCallback = new AttachmentCallbackHandler(encryptedAttachments);
        this.verify(doc, inboundAttachmentCallback);
        String processedDoc = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)processedDoc.contains(SOAP_BODY));
    }

    @Test
    public void testSignatureValueInAttachment() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(1);
        AttachmentCallbackHandler outboundAttachmentCallback = new AttachmentCallbackHandler();
        builder.setAttachmentCallbackHandler((CallbackHandler)outboundAttachmentCallback);
        builder.setStoreBytesInAttachment(true);
        Document signedDoc = builder.build(this.crypto);
        List<Attachment> signedAttachments = outboundAttachmentCallback.getResponseAttachments();
        Assertions.assertNotNull(signedAttachments);
        Assertions.assertTrue((signedAttachments.size() == 1 ? 1 : 0) != 0);
        Element signatureValue = XMLUtils.findElement((Node)signedDoc.getDocumentElement(), (String)"SignatureValue", (String)"http://www.w3.org/2000/09/xmldsig#");
        Assertions.assertNotNull((Object)signatureValue);
        String attachmentId = UUID.randomUUID().toString();
        Attachment attachment = new Attachment();
        attachment.setId(attachmentId);
        byte[] decodedBytes = Base64.getMimeDecoder().decode(signatureValue.getTextContent());
        attachment.setSourceStream((InputStream)new ByteArrayInputStream(decodedBytes));
        signedAttachments.add(attachment);
        XMLUtils.setNamespace((Element)signatureValue, (String)"http://www.w3.org/2004/08/xop/include", (String)"xop");
        Element signatureValueChild = signedDoc.createElementNS("http://www.w3.org/2004/08/xop/include", "xop:Include");
        signatureValueChild.setAttributeNS(null, "href", "cid:" + attachmentId);
        signatureValue.replaceChild(signatureValueChild, signatureValue.getFirstChild());
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        AttachmentCallbackHandler inboundAttachmentCallback = new AttachmentCallbackHandler(signedAttachments);
        this.verify(signedDoc, inboundAttachmentCallback);
    }

    private WSHandlerResult verify(Document doc, CallbackHandler attachmentCallbackHandler) throws Exception {
        RequestData requestData = new RequestData();
        requestData.setAttachmentCallbackHandler(attachmentCallbackHandler);
        requestData.setSigVerCrypto(this.crypto);
        requestData.setDecCrypto(this.crypto);
        requestData.setCallbackHandler((CallbackHandler)new KeystoreCallbackHandler());
        requestData.setExpandXopInclude(true);
        return this.secEngine.processSecurityHeader(doc, requestData);
    }
}

