/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.UsernameTokenUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.UsernamePasswordCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class UTSignatureTest {
    private static final Logger LOG = LoggerFactory.getLogger(UTSignatureTest.class);
    private CallbackHandler callbackHandler = new UsernamePasswordCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance();

    @Test
    public void testSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(true, 1000);
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)true);
        builder.prepare(salt);
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        sign.setCustomTokenId(builder.getId());
        sign.setSecretKey(builder.getDerivedKey(salt));
        sign.setKeyIdentifierType(9);
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        Document signedDoc = sign.build(null);
        builder.prependToHeader();
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(64)).get(0);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertTrue((boolean)principal.getName().contains("bob"));
        try {
            this.verify(signedDoc, false);
            Assertions.fail((String)"Failure expected on deriving keys from a UsernameToken not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBadUserSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setUserInfo("colm", "security");
        builder.addDerivedKey(true, 1000);
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)true);
        builder.prepare(salt);
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        sign.setCustomTokenId(builder.getId());
        sign.setSecretKey(builder.getDerivedKey(salt));
        sign.setKeyIdentifierType(9);
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        Document signedDoc = sign.build(null);
        builder.prependToHeader();
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            Assertions.fail((String)"Failure expected on a bad derived signature");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHandlerSignature() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, CallbackHandler> messageContext = new TreeMap<String, CallbackHandler>();
        messageContext.put("passwordCallbackRef", this.callbackHandler);
        reqData.setMsgContext(messageContext);
        reqData.setUsername("bob");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(64));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(64)).get(0);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertTrue((boolean)principal.getName().contains("bob"));
    }

    @Test
    public void testHandlerSignatureIterations() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, Object> messageContext = new TreeMap<String, Object>();
        messageContext.put("passwordCallbackRef", this.callbackHandler);
        messageContext.put("derivedKeyIterations", "1234");
        reqData.setMsgContext(messageContext);
        reqData.setUsername("bob");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(64));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        Assertions.assertTrue((boolean)outputString.contains("1234"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(64)).get(0);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertTrue((boolean)principal.getName().contains("bob"));
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        return this.verify(doc, true);
    }

    private WSHandlerResult verify(Document doc, boolean allowUsernameTokenDerivedKeys) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData requestData = new RequestData();
        requestData.setAllowUsernameTokenNoPassword(allowUsernameTokenDerivedKeys);
        requestData.setCallbackHandler(this.callbackHandler);
        requestData.setSigVerCrypto(this.crypto);
        requestData.setDecCrypto(this.crypto);
        return secEngine.processSecurityHeader(doc, requestData);
    }
}

